/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.model;

import com.sun.deploy.cache.ResourceProviderImpl;
import com.sun.deploy.model.DeployCacheJarAccess;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;

public abstract class ResourceProvider {
    public static final int DOWNLOAD_NORMAL = 1;
    public static final int DOWNLOAD_NATIVE = 16;
    public static final int DOWNLOAD_JAR = 256;
    public static final int DOWNLOAD_PACK200 = 4096;
    public static final int DOWNLOAD_VERSION = 65536;
    public static final int DOWNLOAD_LAZY = 0x100000;
    private static final String BACKGROUND_STRING = "background";
    private static final String APPCONTEXT_BG_KEY = "deploy-bg-";
    private static final String APPCONTEXT_DISABLE_UPDATE_KEY = "deploy-bg-disable-update-per-policy";
    private boolean isBackgroundListStored = false;

    public static ResourceProvider get() {
        return ProviderHolder.instance;
    }

    public abstract Resource getResource(URL var1, String var2, boolean var3, int var4, DownloadDelegate var5) throws IOException;

    public final Resource getResource(URL location, String version) throws IOException {
        return this.getResource(location, version, true, 1, null);
    }

    public final Resource getCachedResource(URL location, String version) {
        try {
            return this.getResource(location, version, false, 0, null);
        }
        catch (IOException e) {
            Trace.ignored(e);
            return null;
        }
    }

    public abstract String getCachedResourceFilePath(URL var1, String var2) throws IOException;

    public final File getCachedJNLPFile(URL location, String version) {
        return this.getCachedJNLPFile(location, version, false);
    }

    public final File getCachedJNLPFile(URL location, String version, boolean download) {
        try {
            Resource r = this.getResource(location, version, download, 1, null);
            if (r != null) {
                return r.getDataFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public final boolean isCached(URL url, String version) {
        return this.getCachedResource(url, version) != null;
    }

    public final JarFile getJarFile(URL location, String version, int downloadTypes) throws IOException {
        Resource r = this.getResource(location, version, true, downloadTypes, null);
        return r != null ? r.getJarFile() : null;
    }

    public final JarFile getCachedJarFile(URL location, String version) {
        Resource r = this.getCachedResource(location, version);
        return r != null ? r.getJarFile() : null;
    }

    public abstract Resource getJreResource(URL var1, String var2, boolean var3, boolean var4, String var5) throws IOException;

    public abstract boolean isUpdateAvailable(URL var1, String var2, int var3, Map<String, List<String>> var4) throws IOException;

    public abstract boolean checkUpdateAvailable(URL var1, Resource var2, int var3, Map<String, List<String>> var4) throws IOException;

    public boolean isUpdateAvailable(URL location, String version) throws IOException {
        return this.isUpdateAvailable(location, version, 1, null);
    }

    public abstract Resource downloadUpdate(URL var1, String var2, int var3, boolean var4) throws IOException;

    public final Resource downloadUpdate(URL location, String version) throws IOException {
        return this.downloadUpdate(location, version, 1, true);
    }

    public abstract void markReady(Resource[] var1) throws IOException;

    public abstract void markRetired(Resource var1, boolean var2);

    public abstract File getShortcutImage(URL var1, String var2, boolean var3) throws IOException;

    public abstract String getLibraryDirForJar(String var1, URL var2, String var3) throws IOException;

    public abstract Resource getSystemResource(URL var1, String var2);

    public abstract int incrementInternalUse();

    public abstract void decrementInternalUse(int var1);

    public abstract void setBackgroundUpdateRequest(boolean var1);

    public abstract boolean isBackgroundUpdateRequest();

    public abstract void decrementsInternalUse(int var1);

    public abstract boolean isInternalUse();

    public abstract LocalApplicationProperties getLocalApplicationProperties(URL var1, String var2, boolean var3);

    public abstract boolean canCache(URL var1);

    public abstract File getCacheDir();

    public abstract String getCurrentVersion(URL var1);

    public abstract ResourceObject getResourceObject(String var1);

    public synchronized void storeAppContextBackgroundList(List<String> list) {
        if (this.isBackgroundListStored) {
            return;
        }
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String href = list.get(i);
            if (href == null) continue;
            UpdateTracker.addPending(href);
            ToolkitStore.get().getAppContext().put(APPCONTEXT_BG_KEY + href, BACKGROUND_STRING);
        }
        this.isBackgroundListStored = true;
    }

    public void clearAppContextBackgroundList(List<String> list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String href = list.get(i);
            if (href == null) continue;
            ToolkitStore.get().getAppContext().remove(APPCONTEXT_BG_KEY + href);
        }
    }

    protected static boolean isInBackgroundUpdateCheckList(URL url) {
        String background = (String)ToolkitStore.get().getAppContext().get(APPCONTEXT_BG_KEY + url);
        return background != null && background.equals(BACKGROUND_STRING);
    }

    public void disableUpdatePerPolicy() {
        ToolkitStore.get().getAppContext().put(APPCONTEXT_DISABLE_UPDATE_KEY, "true");
    }

    public boolean isUpdateDisabledPerPolicy() {
        String value = (String)ToolkitStore.get().getAppContext().get(APPCONTEXT_DISABLE_UPDATE_KEY);
        return value != null;
    }

    public abstract boolean hasEnhancedJarAccess();

    public abstract DeployCacheJarAccess getJarAccess();

    private static class ProviderHolder {
        static ResourceProvider instance = new ResourceProviderImpl();

        private ProviderHolder() {
        }
    }
}

