/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.net.URL;

public class JfxRuntime {
    private final String version;
    private final VersionID versionId;
    private final String path;
    private final String home;
    private final boolean isFX2;
    private static final String RT_JAR = "jfxrt.jar";

    protected static JfxRuntime runtimeForJRE(File home, String product) {
        String version = null;
        String path = null;
        boolean isJDK7 = false;
        if (product.startsWith("1.7")) {
            version = JfxRuntime.noDash(product.replaceFirst("1.7", "2.2"));
            path = home + File.separator + "lib" + File.separator;
            isJDK7 = true;
        } else if (product.startsWith("1.8")) {
            version = JfxRuntime.noDash(product);
            path = home + File.separator + "lib" + File.separator + "ext" + File.separator;
        } else if (product.startsWith("9") || product.startsWith("10")) {
            version = JfxRuntime.noDash(product);
            path = null;
        }
        if (path != null) {
            if (new File(path + RT_JAR).exists()) {
                return new JfxRuntime(version, home.toString(), path, isJDK7);
            }
        } else if (version != null && new File(home + File.separator + "lib" + File.separator + "javafx.properties").exists()) {
            return new JfxRuntime(version, home.toString(), null, false);
        }
        return null;
    }

    private static String noDash(String in) {
        int dashIndex = in.indexOf("-");
        if (dashIndex != -1) {
            return in.substring(0, dashIndex);
        }
        return in;
    }

    private JfxRuntime(String version, String home, String path, boolean isJDK7) {
        this.version = version;
        String string = this.home = home.endsWith(File.separator) ? home : home + File.separator;
        this.path = path == null ? null : (path.endsWith(File.separator) ? path : path + File.separator);
        this.versionId = new VersionID(version);
        this.isFX2 = isJDK7;
    }

    public String getJfxJarPath() {
        return this.path + RT_JAR;
    }

    public URL getFX2URL() {
        try {
            File f;
            if (this.isFX2 && (f = new File(this.path + RT_JAR)).exists()) {
                return f.getCanonicalFile().toURI().toURL();
            }
        }
        catch (Exception e) {
            Trace.ignored(e);
        }
        return null;
    }

    public File getHome() {
        return new File(this.home);
    }

    public VersionID getProductVersion() {
        return this.versionId;
    }

    public String toString() {
        return "JavaFX " + this.version + " at: " + this.path;
    }
}

