/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Locale;
import org.jsoup.UncheckedIOException;
import org.jsoup.helper.Validate;

public final class CharacterReader {
    static final char EOF = '\uffff';
    private static final int maxStringCacheLen = 12;
    static final int maxBufferLen = 32768;
    private static final int readAheadLimit = 24576;
    private final char[] charBuf;
    private final Reader reader;
    private int bufLength;
    private int bufSplitPoint;
    private int bufPos;
    private int readerPos;
    private int bufMark;
    private final String[] stringCache = new String[512];

    public CharacterReader(Reader input, int sz) {
        Validate.notNull(input);
        Validate.isTrue(input.markSupported());
        this.reader = input;
        this.charBuf = new char[sz > 32768 ? 32768 : sz];
        this.bufferUp();
    }

    public CharacterReader(Reader input) {
        this(input, 32768);
    }

    public CharacterReader(String input) {
        this(new StringReader(input), input.length());
    }

    private void bufferUp() {
        if (this.bufPos < this.bufSplitPoint) {
            return;
        }
        try {
            this.reader.skip(this.bufPos);
            this.reader.mark(32768);
            int read = this.reader.read(this.charBuf);
            this.reader.reset();
            if (read != -1) {
                this.bufLength = read;
                this.readerPos += this.bufPos;
                this.bufPos = 0;
                this.bufMark = 0;
                this.bufSplitPoint = this.bufLength > 24576 ? 24576 : this.bufLength;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int pos() {
        return this.readerPos + this.bufPos;
    }

    public boolean isEmpty() {
        this.bufferUp();
        return this.bufPos >= this.bufLength;
    }

    private boolean isEmptyNoBufferUp() {
        return this.bufPos >= this.bufLength;
    }

    public char current() {
        this.bufferUp();
        return this.isEmptyNoBufferUp() ? (char)'\uffff' : this.charBuf[this.bufPos];
    }

    char consume() {
        this.bufferUp();
        char val = this.isEmptyNoBufferUp() ? (char)'\uffff' : this.charBuf[this.bufPos];
        ++this.bufPos;
        return val;
    }

    void unconsume() {
        --this.bufPos;
    }

    public void advance() {
        ++this.bufPos;
    }

    void mark() {
        this.bufMark = this.bufPos;
    }

    void rewindToMark() {
        this.bufPos = this.bufMark;
    }

    int nextIndexOf(char c) {
        this.bufferUp();
        int i = this.bufPos;
        while (i < this.bufLength) {
            if (c == this.charBuf[i]) {
                return i - this.bufPos;
            }
            ++i;
        }
        return -1;
    }

    int nextIndexOf(CharSequence seq) {
        this.bufferUp();
        char startChar = seq.charAt(0);
        int offset = this.bufPos;
        while (offset < this.bufLength) {
            if (startChar != this.charBuf[offset]) {
                while (++offset < this.bufLength && startChar != this.charBuf[offset]) {
                }
            }
            int i = offset + 1;
            int last = i + seq.length() - 1;
            if (offset < this.bufLength && last <= this.bufLength) {
                int j = 1;
                while (i < last && seq.charAt(j) == this.charBuf[i]) {
                    ++i;
                    ++j;
                }
                if (i == last) {
                    return offset - this.bufPos;
                }
            }
            ++offset;
        }
        return -1;
    }

    public String consumeTo(char c) {
        int offset = this.nextIndexOf(c);
        if (offset != -1) {
            String consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, offset);
            this.bufPos += offset;
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String seq) {
        int offset = this.nextIndexOf(seq);
        if (offset != -1) {
            String consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, offset);
            this.bufPos += offset;
            return consumed;
        }
        return this.consumeToEnd();
    }

    public String consumeToAny(char ... chars) {
        this.bufferUp();
        int start = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block0: while (this.bufPos < remaining) {
            char[] cArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (val[this.bufPos] == c) break block0;
                ++n2;
            }
            ++this.bufPos;
        }
        return this.bufPos > start ? CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start) : "";
    }

    String consumeToAnySorted(char ... chars) {
        this.bufferUp();
        int start = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        while (this.bufPos < remaining) {
            if (Arrays.binarySearch(chars, val[this.bufPos]) >= 0) break;
            ++this.bufPos;
        }
        return this.bufPos > start ? CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start) : "";
    }

    String consumeData() {
        this.bufferUp();
        int start = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        while (this.bufPos < remaining) {
            char c = val[this.bufPos];
            if (c == '&' || c == '<' || c == '\u0000') break;
            ++this.bufPos;
        }
        return this.bufPos > start ? CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start) : "";
    }

    String consumeTagName() {
        this.bufferUp();
        int start = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        while (this.bufPos < remaining) {
            char c = val[this.bufPos];
            if (c == '\t' || c == '\n' || c == '\r' || c == '\f' || c == ' ' || c == '/' || c == '>' || c == '\u0000') break;
            ++this.bufPos;
        }
        return this.bufPos > start ? CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start) : "";
    }

    String consumeToEnd() {
        this.bufferUp();
        String data = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, this.bufLength - this.bufPos);
        this.bufPos = this.bufLength;
        return data;
    }

    String consumeLetterSequence() {
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength) {
            char c = this.charBuf[this.bufPos];
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && !Character.isLetter(c)) break;
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start);
    }

    String consumeLetterThenDigitSequence() {
        char c;
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength) {
            c = this.charBuf[this.bufPos];
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && !Character.isLetter(c)) break;
            ++this.bufPos;
        }
        while (!this.isEmptyNoBufferUp()) {
            c = this.charBuf[this.bufPos];
            if (c < '0' || c > '9') break;
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start);
    }

    String consumeHexSequence() {
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength) {
            char c = this.charBuf[this.bufPos];
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F') && (c < 'a' || c > 'f')) break;
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start);
    }

    String consumeDigitSequence() {
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength) {
            char c = this.charBuf[this.bufPos];
            if (c < '0' || c > '9') break;
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start);
    }

    boolean matches(char c) {
        return !this.isEmpty() && this.charBuf[this.bufPos] == c;
    }

    boolean matches(String seq) {
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        int offset = 0;
        while (offset < scanLength) {
            if (seq.charAt(offset) != this.charBuf[this.bufPos + offset]) {
                return false;
            }
            ++offset;
        }
        return true;
    }

    boolean matchesIgnoreCase(String seq) {
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        int offset = 0;
        while (offset < scanLength) {
            char upTarget;
            char upScan = Character.toUpperCase(seq.charAt(offset));
            if (upScan != (upTarget = Character.toUpperCase(this.charBuf[this.bufPos + offset]))) {
                return false;
            }
            ++offset;
        }
        return true;
    }

    boolean matchesAny(char ... seq) {
        if (this.isEmpty()) {
            return false;
        }
        this.bufferUp();
        char c = this.charBuf[this.bufPos];
        char[] cArray = seq;
        int n = seq.length;
        int n2 = 0;
        while (n2 < n) {
            char seek = cArray[n2];
            if (seek == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean matchesAnySorted(char[] seq) {
        this.bufferUp();
        return !this.isEmpty() && Arrays.binarySearch(seq, this.charBuf[this.bufPos]) >= 0;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c);
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= '0' && c <= '9';
    }

    boolean matchConsume(String seq) {
        this.bufferUp();
        if (this.matches(seq)) {
            this.bufPos += seq.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String seq) {
        if (this.matchesIgnoreCase(seq)) {
            this.bufPos += seq.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String seq) {
        String loScan = seq.toLowerCase(Locale.ENGLISH);
        String hiScan = seq.toUpperCase(Locale.ENGLISH);
        return this.nextIndexOf(loScan) > -1 || this.nextIndexOf(hiScan) > -1;
    }

    public String toString() {
        return new String(this.charBuf, this.bufPos, this.bufLength - this.bufPos);
    }

    private static String cacheString(char[] charBuf, String[] stringCache, int start, int count) {
        if (count > 12) {
            return new String(charBuf, start, count);
        }
        if (count < 1) {
            return "";
        }
        int hash = 0;
        int offset = start;
        int i = 0;
        while (i < count) {
            hash = 31 * hash + charBuf[offset++];
            ++i;
        }
        int index = hash & stringCache.length - 1;
        String cached = stringCache[index];
        if (cached == null) {
            stringCache[index] = cached = new String(charBuf, start, count);
        } else {
            if (CharacterReader.rangeEquals(charBuf, start, count, cached)) {
                return cached;
            }
            stringCache[index] = cached = new String(charBuf, start, count);
        }
        return cached;
    }

    static boolean rangeEquals(char[] charBuf, int start, int count, String cached) {
        if (count == cached.length()) {
            int i = start;
            int j = 0;
            while (count-- != 0) {
                if (charBuf[i++] == cached.charAt(j++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean rangeEquals(int start, int count, String cached) {
        return CharacterReader.rangeEquals(this.charBuf, start, count, cached);
    }
}

