/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.Waiter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Message;
import sun.plugin2.message.Queue;
import sun.plugin2.message.transport.Transport;
import sun.plugin2.util.PojoUtil;

public class Pipe {
    private static final boolean DEBUG = Config.getDebug();
    private static final String logDir = Environment.getenv((String)"JPI2_PIPE_LOGDIR");
    private final PrintWriter logger;
    private Transport transport;
    private boolean initiatingSide;
    private static final ThreadLocal<Queue> perThreadMsgQueue = new ThreadLocal();
    private Queue mainMsgQueue = new Queue();
    private Map<Conversation, Queue> activeConversations = new HashMap<Conversation, Queue>();
    private int curConversationID;
    private volatile boolean shouldShutdown;
    private volatile boolean shutdownComplete;

    public Pipe(Transport transport, boolean initiatingSide) {
        PrintWriter pw = null;
        if (logDir != null && !initiatingSide) {
            File tmp = new File(logDir);
            if (tmp.isDirectory() && tmp.canWrite()) {
                try {
                    File of = new File(logDir, "pipe_" + System.currentTimeMillis());
                    of.createNewFile();
                    pw = new PrintWriter(new FileWriter(of));
                    Trace.println((String)("Pipe traffic logged in " + of.getAbsolutePath()));
                }
                catch (IOException e) {
                    Trace.println((String)"Failed to setup pipe logger.");
                    Trace.ignored((Throwable)e);
                }
            } else {
                Trace.println((String)"Ignore pipe log request, JPI2_PIPE_LOGDIR should be a writable directory.");
            }
        }
        this.logger = pw;
        this.transport = transport;
        this.initiatingSide = initiatingSide;
        if (DEBUG) {
            System.out.println("Pipe.cstr: " + this);
        }
        WorkerThread worker = new WorkerThread();
        worker.setDaemon(true);
        worker.start();
    }

    protected void finalize() throws Exception {
        if (this.logger != null) {
            this.logger.close();
        }
    }

    public static boolean isLoggingEnabled() {
        return logDir != null;
    }

    private void logMessage(Message msg, boolean outbound) {
        if (this.logger != null) {
            Object txt = outbound ? "-> Sent " : "<- Recv ";
            txt = (String)txt + " at " + System.currentTimeMillis();
            txt = (String)txt + "\n  by thread[" + Thread.currentThread().getId() + "]" + Thread.currentThread().getName();
            txt = (String)txt + "\n  " + msg.getClass().getName();
            txt = (String)txt + "\n" + PojoUtil.toJson(msg);
            this.logger.println((String)txt);
            this.logger.flush();
        }
    }

    public void send(Message message) throws IOException {
        this.logMessage(message, true);
        this.transport.write(message);
    }

    public Message poll() throws IOException {
        this.checkForShutdown();
        return this.mainMsgQueue.get();
    }

    public Message poll(Conversation conversation) throws IOException {
        this.checkForShutdown();
        Queue threadLocalQueue = perThreadMsgQueue.get();
        if (threadLocalQueue == null) {
            return null;
        }
        return threadLocalQueue.get(-1, conversation);
    }

    public Message receive(final long millisToWait) throws InterruptedException, IOException {
        this.checkForShutdown();
        try {
            return (Message)Waiter.runAndWait((Waiter.WaiterTask)new Waiter.WaiterTask(){

                public Object run() throws InterruptedException {
                    return Pipe.this.mainMsgQueue.waitForMessage(millisToWait);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex instanceof InterruptedException) {
                throw (InterruptedException)ex;
            }
            return null;
        }
    }

    public Message receive(final long millisToWait, final Conversation conversation) throws InterruptedException, IOException {
        this.checkForShutdown();
        Queue q = this.activeConversations.get(conversation);
        final Queue threadLocalQueue = perThreadMsgQueue.get();
        if (q == null || q != threadLocalQueue) {
            Trace.ignored((Throwable)new Throwable("Conversation is not matching thread queue, something is not right..."));
            Trace.println((String)("Conversation " + conversation + " bound to queue " + q), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("Thread " + Thread.currentThread().getName() + " bound to queue " + threadLocalQueue), (TraceLevel)TraceLevel.BASIC);
        }
        if (threadLocalQueue == null) {
            Trace.ignored((Throwable)new Throwable("No queue bound to this thread, somthing is not right..."));
            return null;
        }
        try {
            return (Message)Waiter.runAndWait((Waiter.WaiterTask)new Waiter.WaiterTask(){

                public Object run() throws InterruptedException {
                    return threadLocalQueue.waitForMessage(millisToWait, -1, conversation);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex instanceof InterruptedException) {
                throw (InterruptedException)ex;
            }
            return null;
        }
    }

    public synchronized Conversation beginConversation() {
        int id = this.curConversationID++;
        Conversation conversation = new Conversation(this.initiatingSide, id);
        Queue threadLocalQueue = perThreadMsgQueue.get();
        if (threadLocalQueue == null) {
            threadLocalQueue = new Queue();
            perThreadMsgQueue.set(threadLocalQueue);
        }
        this.activeConversations.put(conversation, threadLocalQueue);
        return conversation;
    }

    public synchronized boolean joinConversation(Conversation conversation) {
        Queue q = this.activeConversations.get(conversation);
        Queue threadLocalQueue = perThreadMsgQueue.get();
        if (q != null) {
            return q == threadLocalQueue;
        }
        if (threadLocalQueue == null) {
            threadLocalQueue = new Queue();
            perThreadMsgQueue.set(threadLocalQueue);
        }
        this.activeConversations.put(conversation, threadLocalQueue);
        return true;
    }

    public void endConversation(Conversation conversation) {
        this.activeConversations.remove(conversation);
    }

    public void shutdown() {
        this.shouldShutdown = true;
    }

    private synchronized Queue getQueue(Conversation conversation) {
        return this.activeConversations.get(conversation);
    }

    private synchronized void interruptActiveQueues() {
        this.mainMsgQueue.interrupt();
        Iterator<Queue> iter = this.activeConversations.values().iterator();
        while (iter.hasNext()) {
            iter.next().interrupt();
        }
    }

    public boolean shutdownComplete() {
        return this.shutdownComplete;
    }

    private void checkForShutdown() throws IOException {
        if (this.shutdownComplete) {
            throw new IOException("Pipe is already shut down");
        }
    }

    public String toString() {
        return "Pipe{transport=" + this.transport + ", initiatingSide=" + this.initiatingSide + "}";
    }

    class WorkerThread
    extends Thread {
        public WorkerThread() {
            super("Java Plug-In Pipe Worker Thread (" + (Pipe.this.initiatingSide ? "Server-Side" : "Client-Side") + ")");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (!Pipe.this.shouldShutdown) {
                        Message msg = null;
                        Pipe.this.transport.waitForData(500L);
                        while ((msg = Pipe.this.transport.read()) != null) {
                            Queue queue;
                            Pipe.this.logMessage(msg, false);
                            Conversation c = msg.getConversation();
                            boolean dispatched = false;
                            if (c != null && (queue = Pipe.this.getQueue(c)) != null) {
                                queue.put(msg);
                                dispatched = true;
                            }
                            if (dispatched) continue;
                            Pipe.this.mainMsgQueue.put(msg);
                        }
                    }
                }
                catch (IOException e) {
                    Pipe.this.interruptActiveQueues();
                    if (DEBUG) {
                        System.out.println("Terminating " + Thread.currentThread().getName() + " due to exception:");
                        e.printStackTrace();
                    }
                }
            }
            finally {
                Pipe.this.shutdownComplete = true;
                Pipe pipe = Pipe.this;
                synchronized (pipe) {
                    Pipe.this.notifyAll();
                }
            }
        }
    }
}

