/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.javascript.ocx;

import com.sun.deploy.trace.Trace;
import netscape.javascript.JSException;
import sun.plugin.com.DispatchClient;
import sun.plugin.viewer.context.IExplorerAppletContext;

public class JSObject
extends sun.plugin.javascript.JSObject {
    public static final int DISPATCH_METHOD = 1;
    public static final int DISPATCH_PROPERTYGET = 2;
    public static final int DISPATCH_PROPERTYPUT = 4;
    private DispatchClient dispClient = null;
    private int handle = 0;
    private String infoString = null;
    private IExplorerAppletContext aac;
    private boolean lockThis = false;
    private boolean released = false;

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + (this.dispClient != null ? this.dispClient.hashCode() : 0);
        hash = 17 * hash + (this.infoString != null ? this.infoString.hashCode() : 0);
        return hash;
    }

    public JSObject(DispatchClient client) {
        this.dispClient = client;
    }

    public JSObject(DispatchClient client, int handle) {
        this.dispClient = client;
        this.handle = handle;
    }

    public void setIExplorerAppletContext(IExplorerAppletContext aac) {
        this.aac = aac;
        this.handle = aac.getAppletContextHandle();
        aac.addJSObjectToExportedList(this);
        if (this.lockThis) {
            aac.addJSObjectToLockedList(this);
        }
        this.aac = aac;
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized void cleanup() {
        if (!this.released) {
            this.dispClient.release(this.handle);
            this.released = true;
        }
    }

    public synchronized Object invoke(String methodName, Object[] args, int flag) throws JSException {
        this.checkValidity();
        Trace.msgLiveConnectPrintln((String)"com.method.jsinvoke", (Object[])new Object[]{methodName});
        Object result = this.dispClient.invoke(this.handle, methodName, flag, args);
        if (result != null && result instanceof JSObject) {
            ((JSObject)result).setIExplorerAppletContext(this.aac);
        }
        return result;
    }

    @Override
    public Object call(String methodName, Object ... args) throws JSException {
        return this.invoke(methodName, args, 1);
    }

    @Override
    public synchronized Object eval(String s) throws JSException {
        Object[] args = new Object[1];
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'' || c == '\"' || c == '\\') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        args[0] = "evalIntermediateValueToReturn=0;evalIntermediateValueToReturn=eval('" + buffer.toString() + "');";
        netscape.javascript.JSObject jsObject = this;
        String strRep = this.toString();
        if (strRep.indexOf("Window") == -1) {
            jsObject = this.aac.getJSObject();
        }
        try {
            jsObject.call("execScript", args);
        }
        catch (JSException ex0) {
            throw new JSException("Failure to evaluate " + s);
        }
        try {
            return jsObject.getMember("evalIntermediateValueToReturn");
        }
        catch (JSException ex1) {
            return null;
        }
    }

    @Override
    public Object getMember(String name) throws JSException {
        return this.invoke(name, null, 2);
    }

    @Override
    public void setMember(String name, Object value) throws JSException {
        Object[] args = new Object[]{value};
        this.invoke(name, args, 4);
    }

    @Override
    public void removeMember(String name) throws JSException {
        throw new JSException("removeMember does not support " + this.toString() + "." + name);
    }

    @Override
    public Object getSlot(int index) throws JSException {
        Object[] args = new Object[]{index, index};
        return this.invoke("item", args, 1);
    }

    @Override
    public void setSlot(int index, Object value) throws JSException {
        Object[] args = new Object[]{index, value};
        this.invoke("add", args, 1);
    }

    public String toString() {
        if (this.infoString == null) {
            this.infoString = this.dispClient.getDispType(this.handle);
            this.infoString = this.infoString == null ? this.objectToString() : "[object " + this.infoString + "]";
        }
        return this.infoString;
    }

    private String objectToString() {
        Object retVal = null;
        String strVal = null;
        try {
            retVal = this.invoke("toString", null, 1);
        }
        catch (JSException e) {
            retVal = "[object JSObject]";
        }
        if (retVal != null) {
            strVal = retVal.toString();
        }
        return strVal;
    }

    private void checkValidity() throws JSException {
        if (this.released) {
            throw new JSException("Native DOM object has been released");
        }
    }

    public DispatchClient getDispatchClient() {
        return this.dispClient;
    }

    @Override
    public void lock() {
        if (this.aac == null) {
            this.lockThis = true;
        } else {
            this.aac.addJSObjectToLockedList(this);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof JSObject)) {
            return false;
        }
        JSObject jsOther = (JSObject)other;
        if (jsOther.handle != this.handle) {
            return false;
        }
        return this.dispClient.equals(this.handle, jsOther.dispClient);
    }
}

