/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.Base64Wrapper;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SystemUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ArgumentParsingUtil {
    private static final String encprop = "sun.jnu.encoding";
    private static String encoding = null;
    private static boolean isCharsetSupported = false;

    public static List<String> parseCommandLine(String string) {
        if (string == null || string.isEmpty()) {
            return new ArrayList<String>();
        }
        Pattern pattern = Pattern.compile("(?:(?:([\"'])(?:\\\\\\1|.)*?(?:\\1|$))|(?:\\\\[\"'\\s]|[^\\s]))++");
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            String string2 = string.substring(matcher.start(), matcher.end()).trim();
            if (string2.isEmpty()) continue;
            arrayList.add(ArgumentParsingUtil.unquoteIfNeeded(string2));
        }
        Trace.println(" --- parseCommandLine converted : " + string + "\ninto:\n" + arrayList, TraceLevel.SECURITY);
        return arrayList;
    }

    public static List<String> getSecureLaunchArgs(JREInfo jREInfo, List<String> list, JVMParameters jVMParameters, boolean bl, boolean bl2) {
        List<String> list2;
        List<String> list3;
        Object object;
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jREInfo == null) {
            throw new IllegalArgumentException("Invalid JRE info passed.");
        }
        String string2 = jREInfo.getJREPath();
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Invalid JRE path passed.");
        }
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Invalid argument list passed.");
        }
        String string3 = null;
        int n = 0;
        Iterator<String> iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            String string4 = iterator.next();
            if (string4.charAt(0) == '-') {
                if (!string4.equals("-classpath") && !string4.equals("-cp") && !string4.equals("-jar") && !string4.equals("-m") && !string4.equals("--add-modules") && !string4.equals("--module-path") && !string4.equals("-p")) continue;
                if (!string4.equals("-m")) {
                    if (!iterator.hasNext()) continue;
                    iterator.next();
                    continue;
                }
                n = 1;
                continue;
            }
            string3 = string4;
            break;
        }
        if (string3 == null) {
            Trace.println("Can't launch non-existent main class!");
            return null;
        }
        Trace.println("Main class is: " + string3, TraceLevel.SECURITY);
        if (!(string3.equals("sun.plugin2.main.WebStart") || string3.equals("jdk.plugin/sun.plugin2.main.WebStart") || string3.equals("sun.plugin2.main.client.PluginMain") || string3.equals("jdk.plugin/sun.plugin2.main.client.PluginMain"))) {
            Trace.println("Cannot use secure launcher with main class: " + string3);
            return null;
        }
        int n2 = list.indexOf(string3);
        List<String> list4 = list.subList(1, n2 - n);
        List<String> list5 = list.subList(n2 + 1, list.size());
        ArrayList<String> arrayList2 = null;
        if (bl) {
            arrayList2 = new ArrayList<String>();
        }
        if (bl2 && (string = jREInfo.getVmArgs()) != null && !string.isEmpty()) {
            object = ArgumentParsingUtil.parseCommandLine(string);
            list3 = new ArrayList<String>();
            ArgumentParsingUtil.getExcludedListForJCPArgs(list4, list3, arrayList2, (List<String>)object);
            list4 = list3;
        }
        string = ArgumentParsingUtil.encodeArgumentList(list4);
        object = ArgumentParsingUtil.encodeArgumentList(list5);
        arrayList.add(list.get(0));
        arrayList.add("-secure");
        if (!jREInfo.isModularJRE()) {
            arrayList.add("-legacy");
        }
        if (string3.equals("sun.plugin2.main.WebStart") || string3.equals("jdk.plugin/sun.plugin2.main.WebStart")) {
            arrayList.add("-javaws");
        } else {
            arrayList.add("-plugin");
        }
        arrayList.add("-jre");
        arrayList.add(string2);
        arrayList.add("-vma");
        arrayList.add(string);
        arrayList.add("-ma");
        arrayList.add((String)object);
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            Trace.println("Adding extra vm args from JCP: " + arrayList2, TraceLevel.BASIC);
            arrayList.add("-ta");
            arrayList.add(ArgumentParsingUtil.encodeArgumentList(arrayList2));
        }
        if (jVMParameters != null && !(list2 = ArgumentParsingUtil.getMergedList(list3 = jVMParameters.getCommandLineArguments(jREInfo, false), list4)).isEmpty()) {
            Trace.println("Adding vm args from HTML or JNLP: " + list2, TraceLevel.BASIC);
            arrayList.add("-ta");
            arrayList.add(ArgumentParsingUtil.encodeArgumentList(list2));
        }
        if (bl) {
            arrayList.add("-checkParent");
        }
        return arrayList;
    }

    private static List<String> getMergedList(List<String> list, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null && list2 != null) {
            for (String string : list) {
                if (!Config.isSecureVmArg(string)) {
                    arrayList.add(string);
                    continue;
                }
                if (list2.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private static void getExcludedListForJCPArgs(List<String> list, List<String> list2, List<String> list3, List<String> list4) {
        if (list != null && list2 != null && list4 != null) {
            for (String string : list) {
                if (list4.contains(string)) continue;
                list2.add(string);
            }
            if (list3 != null) {
                for (String string : list4) {
                    if (!Config.getBooleanProperty("deployment.relaunch.increment.debug.port") || !SystemUtils.isJdwpDtSocketServerDebugParam(string)) continue;
                    string = SystemUtils.convertDebugParamForRelaunch(string);
                    list3.add(string);
                    break;
                }
            }
        }
    }

    private static void initEncoding() {
        if (encoding == null) {
            try {
                encoding = System.getProperty(encprop);
                isCharsetSupported = Charset.isSupported(encoding);
                Trace.println("Using " + encoding + " to encode arguments.", TraceLevel.BASIC);
            }
            catch (Exception exception) {
                Trace.ignoredException(exception);
                Trace.println("Using system default encoding to encode arguments.", TraceLevel.BASIC);
            }
        }
    }

    public static String encodeArgumentList(List<String> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (String string : list) {
            try {
                byte[] byArray = isCharsetSupported ? string.getBytes(encoding) : string.getBytes();
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                byteArrayOutputStream.write(0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Trace.println("Internal error while encoding argument list.", TraceLevel.DEFAULT);
                return "";
            }
        }
        return Base64Wrapper.encodeToStringWithoutLineBreaks(byteArrayOutputStream.toByteArray());
    }

    public static List<String> decodeArgumentList(String string) {
        byte[] byArray;
        if (string == null || string.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            byArray = Base64Wrapper.decodeFromString(string);
        }
        catch (IOException iOException) {
            Trace.println("Internal error while decoding argument list.", TraceLevel.DEFAULT);
            return null;
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0 && i != byArray.length - 1) continue;
            if (i > n) {
                try {
                    String string2 = isCharsetSupported ? new String(byArray, n, i - n, encoding) : new String(byArray, n, i - n);
                    arrayList.add(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Trace.println("Bad characters encountered while decoding command line argument.", TraceLevel.DEFAULT);
                    return null;
                }
            }
            n = i + 1;
        }
        return arrayList;
    }

    public static String serializeArgumentListForDebugging(List<String> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(" \"");
            stringBuilder.append(iterator.next());
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    public static String unquoteIfNeeded(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.codePointCount(0, string.length());
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            int n3 = string.codePointAt(i);
            if (n3 == 34 || n3 == 39) {
                if (i > 0 && string.codePointAt(i - 1) == 92) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    stringBuilder.appendCodePoint(n3);
                    continue;
                }
                if (n2 != -1) {
                    if (n3 == n2) {
                        n2 = -1;
                        continue;
                    }
                    stringBuilder.appendCodePoint(n3);
                    continue;
                }
                n2 = n3;
                continue;
            }
            stringBuilder.appendCodePoint(n3);
        }
        return stringBuilder.toString();
    }

    static {
        ArgumentParsingUtil.initEncoding();
    }
}

