/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.URLClassPathControl;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;

class TrustDeciderDialog {
    private static final String RISK_MESSAGE = TrustDeciderDialog.getString("security.dialog.unverified.signed.sub.new");
    private static final String MORE_CANCEL_MESSAGE = TrustDeciderDialog.getString("sandbox.security.info.cancel");
    private static final String MORE_RUN_MESSAGE = TrustDeciderDialog.getString("security.dialog.signed.moreinfo.generic");
    private static final String MORE_TRUSTED_MESSAGE = TrustDeciderDialog.getString("sandbox.security.info.trusted");

    TrustDeciderDialog() {
    }

    public static int showDialog(Certificate[] certificateArray, URL uRL, int n, int n2, boolean bl, int n3, Date date, AppInfo appInfo, boolean bl2) throws CertificateException {
        return TrustDeciderDialog.showDialog(certificateArray, uRL, n, n2, bl, n3, date, appInfo, bl2, null, false);
    }

    public static int showDialog(Certificate[] certificateArray, URL uRL, int n, int n2, boolean bl, int n3, Date date, AppInfo appInfo, boolean bl2, String string) throws CertificateException {
        return TrustDeciderDialog.showDialog(certificateArray, uRL, n, n2, bl, n3, date, appInfo, bl2, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showDialog(Certificate[] certificateArray, URL uRL, int n, int n2, boolean bl, int n3, Date date, AppInfo appInfo, boolean bl2, String string, boolean bl3) throws CertificateException {
        try {
            URLClassPathControl.disable();
            if (certificateArray[n] instanceof X509Certificate && certificateArray[n2 - 1] instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificateArray[n];
                X509Certificate x509Certificate2 = (X509Certificate)certificateArray[n2 - 1];
                ArrayList<String> arrayList = CertUtils.getServername(x509Certificate);
                boolean bl4 = string != null && !CertUtils.checkWildcardDomainList(string, arrayList);
                Principal principal = x509Certificate.getSubjectDN();
                Principal principal2 = x509Certificate2.getIssuerDN();
                String string2 = principal.getName();
                String string3 = TrustDeciderDialog.extractSubjectName(string2);
                String string4 = TrustDeciderDialog.extractIssuerName(principal2.getName());
                boolean bl5 = x509Certificate2.getIssuerX500Principal().equals(x509Certificate2.getSubjectX500Principal());
                int n4 = TrustDeciderDialog.doShowDialog(certificateArray, uRL, n, n2, bl, n3, date, appInfo, bl2, string, string4, string3, bl4, bl3, bl5);
                return n4;
            }
            int n5 = -1;
            return n5;
        }
        finally {
            URLClassPathControl.enable();
        }
    }

    private static String extractSubjectName(String string) {
        String string2 = TrustDeciderDialog.extractField(string, "CN=");
        if (string2 == null) {
            String string3 = TrustDeciderDialog.extractField(string, "O=");
            String string4 = TrustDeciderDialog.extractField(string, "OU=");
            if (string3 != null || string4 != null) {
                string2 = ResourceManager.getString("security.dialog.certShowOOUName", string3 == null ? "" : string3, string4 == null ? "" : string4);
            }
        }
        if (string2 == null) {
            string2 = TrustDeciderDialog.getString("security.dialog.unknown.subject");
        }
        return string2;
    }

    private static String extractIssuerName(String string) {
        String string2 = TrustDeciderDialog.extractField(string, "O=");
        if (string2 == null) {
            string2 = TrustDeciderDialog.getString("security.dialog.unknown.issuer");
        }
        return string2;
    }

    static String extractField(String string, String string2) {
        String string3 = null;
        int n = string.indexOf(string2);
        if (n >= 0) {
            int n2 = 0;
            try {
                n2 = string.charAt(n += string2.length()) == '\"' ? string.indexOf(34, ++n) : string.indexOf(44, n);
                string3 = n2 < 0 ? string.substring(n) : string.substring(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Trace.ignored(indexOutOfBoundsException);
            }
        }
        return string3;
    }

    protected static int doShowDialog(Certificate[] certificateArray, URL uRL, int n, int n2, boolean bl, int n3, Date date, AppInfo appInfo, boolean bl2, String string, String string2, String string3, boolean bl3, boolean bl4, boolean bl5) throws CertificateException {
        int n4;
        ArrayList<String> arrayList;
        int n5 = -1;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        boolean bl6 = false;
        String string4 = null;
        String string5 = null;
        boolean bl7 = false;
        String string6 = bl2 ? "security.dialog.https.buttonContinue" : "security.dialog.signed.buttonContinue";
        String string7 = bl2 ? TrustDeciderDialog.getString("security.dialog.https.buttonCancel") : TrustDeciderDialog.getString("security.dialog.signed.buttonCancel");
        boolean bl8 = false;
        boolean bl9 = false;
        if (uRL != null) {
            appInfo.setFrom(uRL);
        }
        if (!(bl || bl3 || n3 != 0 || bl4)) {
            String string8 = string5 = bl2 ? TrustDeciderDialog.getString("security.dialog.verified.valid.https.caption") : TrustDeciderDialog.getString("security.dialog.signed.caption");
            if (bl2) {
                arrayList3.add(TrustDeciderDialog.getString("security.dialog.verified.valid.https.sub"));
            }
            if (appInfo.isMultiHost()) {
                if (DeployManifestChecker.verifyApplicationLibraryAllowableCodebase(uRL, appInfo)) {
                    bl8 = true;
                    bl9 = true;
                } else if (appInfo.isJNLPSourceUnknown()) {
                    bl8 = true;
                }
            } else {
                bl8 = true;
            }
            if (!bl2) {
                arrayList3.add(TrustDeciderDialog.getString("sandbox.security.info.trusted.state"));
            }
        } else {
            if (bl) {
                bl6 = true;
                if (bl2) {
                    string4 = TrustDeciderDialog.getString("security.dialog.unverified.https.caption");
                    arrayList2.add(TrustDeciderDialog.getString("security.dialog.unverified.https.generic"));
                    bl7 = true;
                    if (bl5) {
                        arrayList2.add(TrustDeciderDialog.getString("security.dialog.selfsigned.https.sub"));
                    } else {
                        arrayList2.add(TrustDeciderDialog.getString("security.dialog.unverified.https.sub"));
                    }
                } else {
                    string4 = TrustDeciderDialog.getString("security.dialog.signed.caption");
                    arrayList2.add(RISK_MESSAGE);
                    arrayList = TrustDeciderDialog.getString("security.dialog.notverified.subject");
                    arrayList2.add(TrustDeciderDialog.getString("security.info.publisher.unknown").replaceAll((String)((Object)arrayList), ((String)((Object)arrayList)).toUpperCase()));
                    arrayList2.add(TrustDeciderDialog.getString("security.dialog.unverified.signed.publisher"));
                }
            } else if (!bl3) {
                if (bl2) {
                    string4 = TrustDeciderDialog.getString("security.dialog.unverified.https.caption");
                } else {
                    string4 = TrustDeciderDialog.getString("security.dialog.signed.caption");
                    arrayList3.add(TrustDeciderDialog.getString("security.dialog.verified.signed.publisher"));
                }
            }
            switch (n3) {
                case -1: {
                    if (bl2) {
                        if (!bl7) {
                            arrayList2.add(TrustDeciderDialog.getString("security.dialog.unverified.https.generic"));
                            bl7 = true;
                        }
                        arrayList2.add(TrustDeciderDialog.getString("security.dialog.expired.https.time"));
                        break;
                    }
                    if (arrayList2.isEmpty()) {
                        bl6 = true;
                        arrayList2.add(TrustDeciderDialog.combineMessage(RISK_MESSAGE, TrustDeciderDialog.getString("sandbox.security.dialog.expired.signed.label")));
                        arrayList3.clear();
                        if (!bl4) {
                            if (appInfo.isMultiHost()) {
                                if (DeployManifestChecker.verifyApplicationLibraryAllowableCodebase(uRL, appInfo)) {
                                    bl8 = true;
                                    bl9 = true;
                                }
                            } else {
                                bl8 = true;
                            }
                        }
                    }
                    if (bl) {
                        arrayList2.add(TrustDeciderDialog.getString("sandbox.security.dialog.expired.signed.label"));
                        break;
                    }
                    arrayList2.add(TrustDeciderDialog.getString("sandbox.security.info.expired.state"));
                    break;
                }
                case 1: {
                    if (bl2) {
                        if (!bl7) {
                            arrayList2.add(TrustDeciderDialog.getString("security.dialog.unverified.https.generic"));
                            bl7 = true;
                        }
                        arrayList2.add(TrustDeciderDialog.getString("security.dialog.notyetvalid.https.time"));
                        break;
                    }
                    if (arrayList2.isEmpty() && !bl) {
                        bl6 = true;
                        arrayList2.add(TrustDeciderDialog.combineMessage(RISK_MESSAGE, TrustDeciderDialog.getString("security.dialog.notyet.signed.sub")));
                        arrayList3.clear();
                    }
                    arrayList2.add(TrustDeciderDialog.getString("security.dialog.notyetvalid.signed.time"));
                    break;
                }
                default: {
                    if (bl2 || bl) break;
                    arrayList3.add(TrustDeciderDialog.getString("sandbox.security.info.trusted.state"));
                }
            }
            if (bl4) {
                bl6 = true;
                if (!bl2 && arrayList2.isEmpty()) {
                    arrayList2.add(TrustDeciderDialog.combineMessage(RISK_MESSAGE, TrustDeciderDialog.getString("sandbox.security.info.selfsigned.revocation.unknown")));
                }
                arrayList2.add(TrustDeciderDialog.getString("sandbox.security.info.revocation.unsure.state"));
                arrayList3.clear();
            }
        }
        if (bl3) {
            if (string4 == null) {
                string4 = ResourceManager.getString("security.dialog.unverified.https.caption");
            }
            if (arrayList2.isEmpty()) {
                arrayList2.add(TrustDeciderDialog.getString("security.dialog.unverified.https.generic"));
            }
            arrayList2.add(ResourceManager.getString("security.dialog.hostname.mismatch.moreinfo", string, string3));
        }
        if (!bl2) {
            arrayList = arrayList3;
            int n6 = 0;
            if (!arrayList2.isEmpty()) {
                n6 = 1;
                arrayList = arrayList2;
            }
            arrayList.add(n6++, MORE_RUN_MESSAGE);
            arrayList.add(n6++, MORE_CANCEL_MESSAGE);
            if (!bl) {
                arrayList.add(n6++, MORE_TRUSTED_MESSAGE);
            }
        } else if (string != null) {
            appInfo.setTitle(string);
        } else {
            appInfo.setTitle(string3);
        }
        arrayList = string4 != null ? string4 : string5;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string9 = null;
        if (!arrayList2.isEmpty()) {
            stringArray = new String[arrayList2.size()];
            for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                stringArray[n4] = ((String)arrayList2.get(n4)).toString();
            }
        }
        if (!arrayList3.isEmpty()) {
            stringArray2 = new String[arrayList3.size()];
            for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                stringArray2[n4] = ((String)arrayList3.get(n4)).toString();
            }
        }
        if (arrayList2.isEmpty() && arrayList3.isEmpty()) {
            throw new CertificateException(TrustDeciderDialog.getString("security.dialog.exception.message"));
        }
        if (Platform.get().isNativeSandbox()) {
            bl8 = false;
        }
        if (!Trace.isAutomationEnabled()) {
            if (bl) {
                string3 = TrustDeciderDialog.getString("security.dialog.notverified.subject").toUpperCase();
            }
            string9 = stringArray == null ? TrustDeciderDialog.getString("security.dialog.valid.caption") : TrustDeciderDialog.getString("security.dialog.caption");
            DeployManifestChecker.printWarningsIfRequired(uRL, appInfo);
            n5 = ToolkitStore.getUI().showSecurityDialog(bl9 ? AppInfo.createSingleHostAppInfo(appInfo) : appInfo, string9, (String)((Object)arrayList), string3, uRL, bl8, false, string6, string7, stringArray, stringArray2, true, certificateArray, n, n2, bl6, bl2, bl);
        } else {
            Trace.msgSecurityPrintln("trustdecider.automation.trustcert");
            n5 = 0;
        }
        return n5;
    }

    private static String combineMessage(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("\n\n");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static String getString(String string) {
        return ResourceManager.getString(string);
    }
}

