/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Waiter;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileOpenServiceNSBImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;

public final class FileOpenServiceImpl
implements FileOpenService {
    static FileOpenService _sharedInstance = null;
    static FileSaveServiceImpl _fileSaveServiceImpl;
    private final ApiDialog _apiDialog;
    private static final AccessControlContext ACC_FILE_INSTANCE;
    private static final AccessControlContext ACC_DIALOG_INSTANCE;

    private FileOpenServiceImpl(FileSaveServiceImpl fssi) {
        _fileSaveServiceImpl = fssi;
        this._apiDialog = new ApiDialog();
    }

    public static synchronized FileOpenService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = Platform.get().isNativeSandbox() ? new FileOpenServiceNSBImpl(new FileOpenServiceImpl(new FileSaveServiceImpl())) : new FileOpenServiceImpl((FileSaveServiceImpl)FileSaveServiceImpl.getInstance());
        }
        return _sharedInstance;
    }

    public FileContents openFileDialog(final String pathHint, final String[] extensions) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Waiter.WaiterTask task = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (FileContents)DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] f;
                        String initDir = pathHint;
                        if (initDir == null) {
                            initDir = _fileSaveServiceImpl.getLastPath();
                        }
                        if ((f = ToolkitStore.getUI().showFileChooser(initDir, extensions, 8, false, null))[0] != null) {
                            try {
                                _fileSaveServiceImpl.setLastPath(f[0].getPath());
                                return new FileContentsImpl(f[0], FileSaveServiceImpl.computeMaxLength(f[0].length()));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (FileContents)Waiter.runAndWait((Waiter.WaiterTask)task);
        }
        catch (Exception ex) {
            Trace.ignored((Throwable)ex);
            return null;
        }
    }

    String openFileDialogNSB(final String pathHint, final String[] extensions) throws IOException {
        Waiter.WaiterTask task = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (String)DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] f;
                        String initDir = pathHint;
                        if (initDir == null) {
                            initDir = _fileSaveServiceImpl.getLastPath();
                        }
                        if ((f = ToolkitStore.getUI().showFileChooser(initDir, extensions, 8, false, null))[0] != null) {
                            _fileSaveServiceImpl.setLastPath(f[0].getPath());
                            return f[0].getAbsolutePath();
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (String)Waiter.runAndWait((Waiter.WaiterTask)task);
        }
        catch (Exception ex) {
            Trace.ignored((Throwable)ex);
            return null;
        }
    }

    public FileContents[] openMultiFileDialog(final String pathHint, final String[] extensions) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Waiter.WaiterTask task = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (FileContents[])DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] fs;
                        String initDir = pathHint;
                        if (initDir == null) {
                            initDir = _fileSaveServiceImpl.getLastPath();
                        }
                        if ((fs = ToolkitStore.getUI().showFileChooser(initDir, extensions, 8, true, null)) != null && fs.length > 0) {
                            FileContents[] fcontents = new FileContents[fs.length];
                            for (int i = 0; i < fs.length; ++i) {
                                try {
                                    fcontents[i] = new FileContentsImpl(fs[i], FileSaveServiceImpl.computeMaxLength(fs[i].length()));
                                    _fileSaveServiceImpl.setLastPath(fs[i].getPath());
                                    continue;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return fcontents;
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (FileContents[])Waiter.runAndWait((Waiter.WaiterTask)task);
        }
        catch (Exception ex) {
            Trace.ignored((Throwable)ex);
            return null;
        }
    }

    String[] openMultiFileDialogNSB(final String pathHint, final String[] extentions) throws IOException {
        Waiter.WaiterTask task = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (String[])DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] fs;
                        String initDir = pathHint;
                        if (initDir == null) {
                            initDir = _fileSaveServiceImpl.getLastPath();
                        }
                        if ((fs = ToolkitStore.getUI().showFileChooser(initDir, extentions, 8, true, null)) != null && fs.length > 0) {
                            String[] strings = new String[fs.length];
                            for (int i = 0; i < fs.length; ++i) {
                                strings[i] = fs[i].getAbsolutePath();
                                _fileSaveServiceImpl.setLastPath(fs[i].getPath());
                            }
                            return strings;
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (String[])Waiter.runAndWait((Waiter.WaiterTask)task);
        }
        catch (Exception ex) {
            Trace.ignored((Throwable)ex);
            return null;
        }
    }

    synchronized boolean askUser() {
        String key;
        if (CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        final LocalApplicationProperties lap = JNLPUtils.getLocalApplicationProperties();
        if (lap != null && (key = lap.get("jnlp.api.always.FileOpenService.open")) != null) {
            return true;
        }
        ApiDialog.DialogResult result = this._apiDialog.askUser(ResourceManager.getString((String)"api.file.open.title"), ResourceManager.getString((String)"api.file.open.message"), ResourceManager.getString((String)"api.file.open.always"));
        if (result == ApiDialog.DialogResult.ALWAYS) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    lap.put("jnlp.api.always.FileOpenService.open", "skip");
                    try {
                        lap.store();
                    }
                    catch (Throwable e) {
                        Trace.ignored((Throwable)e);
                    }
                    return null;
                }
            }, ACC_FILE_INSTANCE);
        }
        return result == ApiDialog.DialogResult.OK || result == ApiDialog.DialogResult.ALWAYS;
    }

    static {
        ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                Permissions perms = new Permissions();
                FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
                ((PermissionCollection)perms).add(perm);
                return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
            }
        });
        ACC_DIALOG_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                Permissions perms = new Permissions();
                ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read,write"));
                ((PermissionCollection)perms).add(new RuntimePermission("setContextClassLoader"));
                ((PermissionCollection)perms).add(new RuntimePermission("accessClassInPackage.com.apple.*"));
                return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
            }
        });
    }
}

