/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.ImageLoader;
import com.sun.deploy.ui.ImageLoaderCallback;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.LaunchErrorDialog;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;

class SplashGenerator
extends Thread
implements ImageLoaderCallback {
    private File _index;
    private File _dir;
    private final String _key;
    private final String _key2;
    private final LaunchDesc _ld;
    private Properties _props = new Properties();

    public SplashGenerator(LaunchDesc ld) {
        this._ld = ld;
        this._dir = new File(Config.getSplashDir());
        this._key = this._ld.getSplashCanonicalHome();
        this._key2 = System.getProperty("jnlpx.origFilenameArg");
        String indexFile = Config.getSplashIndex();
        this._index = new File(indexFile);
        Config.setSplashCache();
        Config.get().storeIfNeeded();
        if (this._index.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this._index);
                if (fis != null) {
                    this._props.load(fis);
                    fis.close();
                }
            }
            catch (IOException ioe) {
                Trace.ignoredException((Exception)ioe);
            }
        }
    }

    public boolean needsCustomSplash() {
        return this._key != null && !this._props.containsKey(this._key) || this._key2 != null && !this._props.containsKey(this._key2);
    }

    public void remove() {
        this.addSplashToCacheIndex(this._key, null);
        this.addSplashToCacheIndex(this._key2, null);
    }

    @Override
    public void run() {
        IconDesc id;
        InformationDesc info = this._ld.getInformation();
        IconDesc[] icons = info.getIcons();
        if (!this._dir.getParentFile().canWrite() || this._dir.exists() && !this._dir.canWrite() || this._index.exists() && !this._index.canWrite()) {
            return;
        }
        try {
            this._dir.mkdirs();
        }
        catch (Throwable e) {
            this.splashError(e);
        }
        if (!Platform.get().isNativeSandbox()) {
            try {
                this._index.createNewFile();
            }
            catch (Throwable e) {
                this.splashError(e);
            }
        }
        if ((id = info.getIconLocation(48, 4)) == null) {
            return;
        }
        ImageLoader.getInstance().loadImage(id.getLocation(), id.getVersion(), (ImageLoaderCallback)this);
    }

    public void imageAvailable(URL url, String version, Image image, File file) {
    }

    public void finalImageAvailable(URL url, String version, Image image, File file) {
        try {
            this.create(image, file);
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                this.splashError(t);
            }
            Trace.ignored((Throwable)t);
        }
    }

    public void create(Image image, File cachedIconFile) {
        InformationDesc info = this._ld.getInformation();
        int imageHeight = image.getHeight(null);
        int imageWidth = image.getWidth(null);
        if (cachedIconFile != null) {
            try {
                String path = cachedIconFile.getCanonicalPath();
                this.addSplashToCacheIndex(this._key, path);
                this.addSplashToCacheIndex(this._key2, path);
            }
            catch (Throwable t) {
                Trace.ignored((Throwable)t);
            }
        }
    }

    private void addSplashToCacheIndex(String key, String value) {
        if (key == null) {
            return;
        }
        if (value != null) {
            this._props.setProperty(key, value);
        } else if (this._props.containsKey(key)) {
            this._props.remove(key);
        }
        File[] files = this._dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(this._index)) continue;
            try {
                String path = files[i].getCanonicalPath();
                if (this._props.containsValue(path)) continue;
                files[i].delete();
                continue;
            }
            catch (IOException ioe) {
                this.splashError(ioe);
            }
        }
        try {
            OutputStream os = Platform.get().getNativeSandboxBroker().getOutputStream(this._index, true);
            this._props.store(os, "");
            os.flush();
            os.close();
        }
        catch (IOException ioe) {
            this.splashError(ioe);
        }
    }

    private void splashError(Throwable e) {
        LaunchErrorDialog.show(null, e, false);
        throw new Error(e.toString());
    }
}

