/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.security.CachedCertificatesHelper;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.GeneralUtil;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.xml.XMLEncoding;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import com.sun.javaws.Globals;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtDownloadDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JavaFXAppDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.LibraryDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.javaws.jnl.UpdateDesc;
import com.sun.javaws.jnl.XMLUtils;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.xml.sax.SAXParseException;

public class XMLFormat {
    static Rectangle screen = null;

    public static XMLNode parseBits(byte[] bits) throws JNLParseException {
        return XMLFormat.parse(XMLFormat.decode(bits));
    }

    private static String decode(byte[] bits) throws JNLParseException {
        try {
            return XMLEncoding.decodeXML((byte[])bits);
        }
        catch (Exception e) {
            throw new JNLParseException(null, e, "exception determining encoding of jnlp file", 0);
        }
    }

    private static XMLNode parse(String source) throws JNLParseException {
        try {
            return new XMLParser(source).parse();
        }
        catch (SAXParseException spe) {
            throw new JNLParseException(source, spe, "exception parsing jnlp file", spe.getLineNumber());
        }
        catch (Exception e) {
            throw new JNLParseException(source, e, "exception parsing jnlp file", 0);
        }
    }

    public static LaunchDesc parse(byte[] bits, URL thisCodebase, URL documentbaseBrowser, URL originalRequestHref) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        URL documentBase;
        String source = XMLFormat.decode(bits).trim();
        XMLNode root = XMLFormat.parse(source);
        InformationDesc info = null;
        ResourcesDesc resources = null;
        UpdateDesc update = null;
        ApplicationDesc application = null;
        AppletDesc applet = null;
        JavaFXAppDesc fxapp = null;
        LibraryDesc libraryDef = null;
        InstallerDesc installerDef = null;
        String internalCommand = null;
        if (root == null || root.getName() == null) {
            throw new JNLParseException(source, null, null, 0);
        }
        if (root.getName().equals("player") || root.getName().equals("viewer")) {
            String cpTab = XMLUtils.getAttribute(root, null, "tab");
            return LaunchDescFactory.buildInternalLaunchDesc(root, cpTab);
        }
        if (!root.getName().equals("jnlp")) {
            throw new MissingFieldException(source, "<jnlp>");
        }
        String specVersion = XMLUtils.getAttribute(root, "", "spec", "1.0+");
        String version = XMLUtils.getAttribute(root, "", "version");
        URL codebase = URLUtil.asPathURL((URL)XMLUtils.getAttributeURL(source, thisCodebase, root, "", "codebase"));
        if (codebase == null && thisCodebase != null) {
            codebase = thisCodebase;
        }
        if ((documentBase = XMLUtils.getAttributeURL(source, codebase, root, "<applet-desc>", "documentbase")) == null) {
            documentBase = XMLUtils.getAttributeURL(source, codebase, root, "<applet-desc>", "documentBase");
        }
        if (documentbaseBrowser != null) {
            documentBase = documentbaseBrowser;
        }
        URL href = XMLUtils.getAttributeURL(source, codebase, root, "", "href");
        int security = 0;
        CachedCertificatesHelper[] certs = null;
        if (XMLUtils.isElementPath(root, "<security><all-permissions>")) {
            security = 1;
            certs = XMLFormat.buildCachedCertificates(root);
        } else if (XMLUtils.isElementPath(root, "<security><j2ee-application-client-permissions>")) {
            security = 2;
            certs = XMLFormat.buildCachedCertificates(root);
        }
        if (XMLUtils.isElementPath(root, "<javafx-desc>")) {
            fxapp = XMLFormat.buildFXAppDesc(source, root, "<javafx-desc>");
        }
        int type = 0;
        if (XMLUtils.isElementPath(root, "<application-desc>")) {
            type = 1;
            application = XMLFormat.buildApplicationDesc(source, root);
            if ("JavaFX".equalsIgnoreCase(application.getType())) {
                fxapp = new JavaFXAppDesc(application.getMainClass(), application.getProgressClass(), application.getArguments(), application.getParameters());
            }
        } else if (XMLUtils.isElementPath(root, "<component-desc>")) {
            type = 3;
            libraryDef = XMLFormat.buildLibraryDesc(source, root);
        } else if (XMLUtils.isElementPath(root, "<installer-desc>")) {
            if (!Cache.isCacheEnabled()) {
                throw new BadFieldException(source, "<installer-desc>", "");
            }
            type = 4;
            installerDef = XMLFormat.buildInstallerDesc(source, codebase, root);
        } else if (XMLUtils.isElementPath(root, "<applet-desc>")) {
            type = 2;
            applet = XMLFormat.buildAppletDesc(source, codebase, documentBase, root);
        } else if (fxapp != null) {
            type = 6;
        } else {
            throw new MissingFieldException(source, "<jnlp>(<application-desc>|<applet-desc>|<installer-desc>|<component-desc>)");
        }
        update = XMLFormat.getUpdateDesc(root);
        info = XMLFormat.buildInformationDesc(source, codebase, root);
        resources = XMLFormat.buildResourcesDesc(source, codebase, root, false);
        URL hrefUsed = type == 3 ? originalRequestHref : href;
        LaunchDesc launchDesc = new LaunchDesc(specVersion, codebase, hrefUsed, version, info, security, certs, update, resources, type, application, applet, fxapp, libraryDef, installerDef, internalCommand, root, source);
        XMLFormat.setSourceURL(launchDesc, originalRequestHref);
        if (Trace.isEnabled((TraceLevel)TraceLevel.TEMP)) {
            Trace.println((String)("returning LaunchDesc from XMLFormat.parse():\n" + launchDesc), (TraceLevel)TraceLevel.TEMP);
        }
        return launchDesc;
    }

    private static InformationDesc combineInformationDesc(InformationDesc id1, InformationDesc id2) {
        if (id1 == null) {
            return id2;
        }
        if (id2 == null) {
            return id1;
        }
        String t1 = id1.getTitle();
        String title = t1 != null && t1.length() > 0 ? t1 : id2.getTitle();
        String v1 = id1.getVendor();
        String vendor = v1 != null && v1.length() > 0 ? v1 : id2.getVendor();
        URL home = id1.getHome() != null ? id1.getHome() : id2.getHome();
        String[] descriptions = new String[4];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = id1.getDescription(i) != null ? id1.getDescription(i) : id2.getDescription(i);
        }
        ArrayList<IconDesc> iconList = new ArrayList<IconDesc>();
        if (id2.getIcons() != null) {
            iconList.addAll(Arrays.asList(id2.getIcons()));
        }
        if (id1.getIcons() != null) {
            iconList.addAll(Arrays.asList(id1.getIcons()));
        }
        IconDesc[] icons = new IconDesc[iconList.size()];
        icons = iconList.toArray(icons);
        boolean offline = id1.supportsOfflineOperation() || id2.supportsOfflineOperation();
        ShortcutDesc hints = id1.getShortcut() != null ? id1.getShortcut() : id2.getShortcut();
        AssociationDesc[] asd = (AssociationDesc[])XMLFormat.addArrays(id1.getAssociations(), id2.getAssociations());
        RContentDesc[] rcd = (RContentDesc[])XMLFormat.addArrays(id1.getRelatedContent(), id2.getRelatedContent());
        return new InformationDesc(title, vendor, home, descriptions, icons, hints, rcd, asd, offline);
    }

    private static InformationDesc buildInformationDesc(final String source, final URL codebase, XMLNode root) throws MissingFieldException, BadFieldException {
        final ArrayList list = new ArrayList();
        XMLUtils.visitElements(root, "<information>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode e) throws BadFieldException, MissingFieldException {
                String[] os = GeneralUtil.getStringList((String)XMLUtils.getAttribute(e, "", "os", null));
                String[] arch = GeneralUtil.getStringList((String)XMLUtils.getAttribute(e, "", "arch", null));
                String[] locale = GeneralUtil.getStringList((String)XMLUtils.getAttribute(e, "", "locale", null));
                if (GeneralUtil.prefixMatchStringList((String[])os, (String)Config.getOSFullName()) && GeneralUtil.prefixMatchArch((String[])arch) && XMLFormat.matchDefaultLocale(locale)) {
                    String title = XMLUtils.getElementContents(e, "<title>");
                    String vendor = XMLUtils.getElementContents(e, "<vendor>");
                    URL home = XMLUtils.getAttributeURL(source, codebase, e, "<homepage>", "href");
                    String[] descriptions = new String[4];
                    descriptions[0] = XMLUtils.getElementContentsWithAttribute(e, "<description>", "kind", "", null);
                    descriptions[2] = XMLUtils.getElementContentsWithAttribute(e, "<description>", "kind", "one-line", null);
                    descriptions[1] = XMLUtils.getElementContentsWithAttribute(e, "<description>", "kind", "short", null);
                    descriptions[3] = XMLUtils.getElementContentsWithAttribute(e, "<description>", "kind", "tooltip", null);
                    IconDesc[] icons = XMLFormat.getIconDescs(source, codebase, e);
                    ShortcutDesc shortcuts = XMLFormat.getShortcutDesc(e);
                    RContentDesc[] relatedContents = XMLFormat.getRContentDescs(source, codebase, e);
                    AssociationDesc[] associations = XMLFormat.getAssociationDesc(source, codebase, e);
                    list.add(new InformationDesc(title, vendor, home, descriptions, icons, shortcuts, relatedContents, associations, XMLUtils.isElementPath(e, "<offline-allowed>")));
                }
            }
        });
        InformationDesc normId = new InformationDesc(null, null, null, null, null, null, null, null, false);
        for (InformationDesc id : list) {
            normId = XMLFormat.combineInformationDesc(id, normId);
        }
        return normId;
    }

    private static Object[] addArrays(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < a1.length) {
            list.add(a1[i++]);
        }
        i = 0;
        while (i < a2.length) {
            list.add(a2[i++]);
        }
        return list.toArray(a1);
    }

    public static boolean matchDefaultLocale(String[] localeStr) {
        return GeneralUtil.matchLocale((String[])localeStr, (Locale)Globals.getDefaultLocale());
    }

    static ResourcesDesc buildResourcesDesc(final String source, final URL codebase, XMLNode root, final boolean ignoreJres) throws MissingFieldException, BadFieldException {
        final ResourcesDesc rdesc = new ResourcesDesc();
        XMLUtils.visitElements(root, "<resources>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode e) throws MissingFieldException, BadFieldException {
                String[] os = GeneralUtil.getStringList((String)XMLUtils.getAttribute(e, "", "os", null));
                final String arch = XMLUtils.getAttribute(e, "", "arch", null);
                String[] locale = GeneralUtil.getStringList((String)XMLUtils.getAttribute(e, "", "locale", null));
                if (GeneralUtil.prefixMatchStringList((String[])os, (String)Config.getOSFullName()) && XMLFormat.matchDefaultLocale(locale)) {
                    XMLUtils.visitChildrenElements(e, new XMLUtils.ElementVisitor(){

                        @Override
                        public void visitElement(XMLNode e2) throws MissingFieldException, BadFieldException {
                            XMLFormat.handleResourceElement(source, codebase, e2, rdesc, ignoreJres, arch);
                        }
                    });
                }
            }
        });
        if (!rdesc.isEmpty()) {
            boolean pack200Enabled = rdesc.isPack200Enabled();
            boolean versionEnabled = rdesc.isVersionEnabled();
            if (pack200Enabled || versionEnabled) {
                JARDesc[] jds;
                for (JARDesc jd : jds = rdesc.getLocalJarDescs()) {
                    if (pack200Enabled) {
                        jd.setPack200Enabled();
                    }
                    if (!versionEnabled) continue;
                    jd.setVersionEnabled();
                }
            }
        }
        return rdesc.isEmpty() ? null : rdesc;
    }

    private static IconDesc[] getIconDescs(final String source, final URL codebase, XMLNode e) throws MissingFieldException, BadFieldException {
        final ArrayList answer = new ArrayList();
        XMLUtils.visitElements(e, "<icon>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode icon) throws MissingFieldException, BadFieldException {
                String kindStr = XMLUtils.getAttribute(icon, "", "kind", "");
                URL href = XMLUtils.getRequiredURL(source, codebase, icon, "", "href");
                String version = XMLUtils.getAttribute(icon, "", "version", null);
                int height = XMLUtils.getIntAttribute(source, icon, "", "height", 0);
                int width = XMLUtils.getIntAttribute(source, icon, "", "width", 0);
                int depth = XMLUtils.getIntAttribute(source, icon, "", "depth", 0);
                int kind = 0;
                if (kindStr.equals("selected")) {
                    kind = 1;
                } else if (kindStr.equals("disabled")) {
                    kind = 2;
                } else if (kindStr.equals("rollover")) {
                    kind = 3;
                } else if (kindStr.equals("splash")) {
                    kind = 4;
                } else if (kindStr.equals("shortcut")) {
                    kind = 5;
                }
                answer.add(new IconDesc(href, version, height, width, depth, kind));
            }
        });
        return answer.toArray(new IconDesc[answer.size()]);
    }

    private static ShortcutDesc getShortcutDesc(XMLNode e) throws MissingFieldException, BadFieldException {
        final ArrayList shortcuts = new ArrayList();
        XMLUtils.visitElements(e, "<shortcut>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode shortcutNode) throws MissingFieldException, BadFieldException {
                String online = XMLUtils.getAttribute(shortcutNode, "", "online", "true");
                boolean onlineHinted = online.equalsIgnoreCase("true");
                String install = XMLUtils.getAttribute(shortcutNode, "", "install", "false");
                boolean installHinted = install.equalsIgnoreCase("true");
                boolean desktopHinted = XMLUtils.isElementPath(shortcutNode, "<desktop>");
                boolean menuHinted = XMLUtils.isElementPath(shortcutNode, "<menu>");
                String submenuHinted = XMLUtils.getAttribute(shortcutNode, "<menu>", "submenu");
                shortcuts.add(new ShortcutDesc(onlineHinted, installHinted, desktopHinted, menuHinted, submenuHinted));
            }
        });
        if (shortcuts.size() > 0) {
            return (ShortcutDesc)shortcuts.get(0);
        }
        return null;
    }

    private static CachedCertificatesHelper[] buildCachedCertificates(XMLNode e) throws MissingFieldException, BadFieldException {
        final ArrayList certs = new ArrayList();
        XMLUtils.visitElements(e, "<security><details>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode node) throws MissingFieldException, BadFieldException {
                String s;
                String v = XMLUtils.getAttribute(node, "", "signedjnlp");
                boolean signedJNLP = "true".equalsIgnoreCase(v);
                String d = XMLUtils.getAttribute(node, "<certificate-path>", "timestamp");
                Date tm = d == null ? null : new Date(Long.parseLong(d));
                CachedCertificatesHelper embedded = CachedCertificatesHelper.create((Date)tm, (String)(s = XMLUtils.getElementContents(node, "<certificate-path>")), (boolean)signedJNLP);
                if (embedded != null) {
                    certs.add(embedded);
                }
            }
        });
        if (certs.size() > 0) {
            return certs.toArray(new CachedCertificatesHelper[0]);
        }
        return null;
    }

    private static UpdateDesc getUpdateDesc(XMLNode e) throws MissingFieldException, BadFieldException {
        final ArrayList updates = new ArrayList();
        XMLUtils.visitElements(e, "<update>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode node) throws MissingFieldException, BadFieldException {
                String check = XMLUtils.getAttribute(node, "", "check", "timeout");
                String policy = XMLUtils.getAttribute(node, "", "policy", "always");
                updates.add(new UpdateDesc(check, policy));
            }
        });
        if (updates.size() > 0) {
            return (UpdateDesc)updates.get(0);
        }
        return new UpdateDesc("timeout", "always");
    }

    private static AssociationDesc[] getAssociationDesc(final String source, final URL codebase, XMLNode e) throws MissingFieldException, BadFieldException {
        final ArrayList answer = new ArrayList();
        XMLUtils.visitElements(e, "<association>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode node) throws MissingFieldException, BadFieldException {
                String extensions = XMLUtils.getAttribute(node, "", "extensions");
                String mimeType = XMLUtils.getAttribute(node, "", "mime-type");
                String description = XMLUtils.getElementContents(node, "<description>");
                URL icon = XMLUtils.getAttributeURL(source, codebase, node, "<icon>", "href");
                if (extensions == null && mimeType == null) {
                    throw new MissingFieldException(source, "<association>(<extensions><mime-type>)");
                }
                if (extensions == null) {
                    throw new MissingFieldException(source, "<association><extensions>");
                }
                if (mimeType == null) {
                    throw new MissingFieldException(source, "<association><mime-type>");
                }
                if ("gnome".equals(System.getProperty("sun.desktop"))) {
                    extensions = extensions.toLowerCase();
                    mimeType = mimeType.toLowerCase();
                }
                answer.add(new AssociationDesc(extensions, mimeType, description, icon));
            }
        });
        return answer.toArray(new AssociationDesc[answer.size()]);
    }

    private static RContentDesc[] getRContentDescs(final String source, final URL codebase, XMLNode e) throws MissingFieldException, BadFieldException {
        final ArrayList answer = new ArrayList();
        XMLUtils.visitElements(e, "<related-content>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode node) throws MissingFieldException, BadFieldException {
                URL href = XMLUtils.getRequiredURL(source, codebase, node, "", "href");
                String title = XMLUtils.getElementContents(node, "<title>");
                String description = XMLUtils.getElementContents(node, "<description>");
                URL icon = XMLUtils.getAttributeURL(source, codebase, node, "<icon>", "href");
                answer.add(new RContentDesc(href, title, description, icon));
            }
        });
        return answer.toArray(new RContentDesc[answer.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleResourceElement(String source, URL codebase, XMLNode e, ResourcesDesc rdesc, boolean ignoreJres, String arch) throws MissingFieldException, BadFieldException {
        String tag = e.getName();
        boolean matchArch = GeneralUtil.prefixMatchArch((String[])GeneralUtil.getStringList((String)arch));
        if (matchArch && (tag.equals("jar") || tag.equals("nativelib"))) {
            URL href = XMLUtils.getRequiredURL(source, codebase, e, "", "href");
            String vd = XMLUtils.getAttribute(e, "", "version", null);
            String kindStr = XMLUtils.getAttribute(e, "", "download");
            String mainStr = XMLUtils.getAttribute(e, "", "main");
            String part = XMLUtils.getAttribute(e, "", "part");
            int size = XMLUtils.getIntAttribute(source, e, "", "size", 0);
            boolean isNativeLib = tag.equals("nativelib");
            if (!Cache.isCacheEnabled() && isNativeLib) {
                throw new BadFieldException(source, "nativelib", href.toString());
            }
            boolean isLazy = "lazy".equalsIgnoreCase(kindStr);
            boolean isProgress = "progress".equalsIgnoreCase(kindStr);
            boolean isMain = "true".equalsIgnoreCase(mainStr);
            JARDesc jd = null;
            if (Environment.isImportMode() && Environment.getImportModeCodebaseOverride() != null) {
                String jarHref = XMLUtils.getAttribute(e, "", "href");
                if (href.toString().endsWith("/")) {
                    File file = null;
                    try {
                        File[] files;
                        URI fileURI = new URI(Environment.getImportModeCodebaseOverride().replace("\\", "/") + jarHref);
                        file = new File(fileURI);
                        if (file == null || !file.isDirectory()) return;
                        for (File file1 : files = file.listFiles()) {
                            try {
                                URL newHref = new URL(href.toString() + file1.getName());
                                jd = new JARDesc(newHref, vd, isLazy, isMain, isNativeLib, part, size, rdesc, isProgress);
                                rdesc.addResource(jd);
                            }
                            catch (MalformedURLException mue) {
                                Trace.ignoredException((Exception)mue);
                            }
                        }
                        return;
                    }
                    catch (URISyntaxException use) {
                        Trace.ignoredException((Exception)use);
                        return;
                    }
                } else {
                    try {
                        URL importCodebase = new URL(Environment.getImportModeCodebaseOverride());
                        URL newHref = new URL(importCodebase, jarHref);
                        jd = new JARDesc(newHref, vd, isLazy, isMain, isNativeLib, part, size, rdesc, isProgress);
                        rdesc.addResource(jd);
                        return;
                    }
                    catch (MalformedURLException mue) {
                        Trace.ignoredException((Exception)mue);
                    }
                }
                return;
            } else {
                jd = new JARDesc(href, vd, isLazy, isMain, isNativeLib, part, size, rdesc, isProgress);
                rdesc.addResource(jd);
            }
            return;
        }
        if (matchArch && tag.equals("property")) {
            String name = XMLUtils.getRequiredAttribute(source, e, "", "name");
            String value = XMLUtils.getRequiredAttributeEmptyOK(source, e, "", "value");
            if (name.equals("jnlp.versionEnabled") && value.equalsIgnoreCase("true")) {
                rdesc.setVersionEnabled();
                return;
            }
            if (name.equals("jnlp.packEnabled") && value.equalsIgnoreCase("true")) {
                rdesc.setPack200Enabled();
                return;
            }
            if (name.equals("jnlp.concurrentDownloads")) {
                if (value == null) return;
                int n = 0;
                try {
                    n = Integer.parseInt(value.trim());
                }
                catch (NumberFormatException mainStr) {
                    // empty catch block
                }
                rdesc.setConcurrentDownloads(n);
                return;
            }
            rdesc.addResource(new PropertyDesc(name, value));
            return;
        }
        if (matchArch && tag.equals("package")) {
            String name = XMLUtils.getRequiredAttribute(source, e, "", "name");
            String part = XMLUtils.getRequiredAttribute(source, e, "", "part");
            String recurs = XMLUtils.getAttribute(e, "", "recursive", "false");
            boolean isRecursive = "true".equals(recurs);
            rdesc.addResource(new PackageDesc(name, part, isRecursive));
            return;
        } else if (matchArch && tag.equals("extension")) {
            String name = XMLUtils.getAttribute(e, "", "name");
            URL href = XMLUtils.getRequiredURL(source, codebase, e, "", "href");
            String vd = XMLUtils.getAttribute(e, "", "version", null);
            ExtDownloadDesc[] eds = XMLFormat.getExtDownloadDescs(source, e);
            rdesc.addResource(new ExtensionDesc(name, href, vd, eds));
            return;
        } else if ((tag.equals("java") || tag.equals("j2se")) && !ignoreJres && JREInfo.archMatchStringList((String[])GeneralUtil.getStringList((String)arch))) {
            String version = XMLUtils.getRequiredAttribute(source, e, "", "version");
            URL href = XMLUtils.getAttributeURL(source, codebase, e, "", "href");
            String minheapstr = XMLUtils.getAttribute(e, "", "initial-heap-size");
            String maxheapstr = XMLUtils.getAttribute(e, "", "max-heap-size");
            String vmargs = XMLUtils.getAttribute(e, "", "java-vm-args");
            long minheap = -1L;
            long maxheap = -1L;
            minheap = GeneralUtil.heapValToLong((String)minheapstr);
            maxheap = GeneralUtil.heapValToLong((String)maxheapstr);
            ResourcesDesc cbs = XMLFormat.buildResourcesDesc(source, codebase, e, true);
            JREDesc jreDesc = new JREDesc(version, minheap, maxheap, vmargs, href, cbs, arch);
            rdesc.addResource(jreDesc);
            return;
        } else {
            if (!tag.equals("javafx-runtime")) return;
            String version = XMLUtils.getRequiredAttribute(source, e, "", "version");
            URL href = XMLUtils.getAttributeURL(source, codebase, e, "", "href");
            rdesc.addResource(new JavaFXRuntimeDesc(version, href));
        }
    }

    private static ExtDownloadDesc[] getExtDownloadDescs(final String source, XMLNode root) throws BadFieldException, MissingFieldException {
        final ArrayList al = new ArrayList();
        XMLUtils.visitElements(root, "<ext-download>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode e) throws MissingFieldException, BadFieldException {
                String extPart = XMLUtils.getRequiredAttribute(source, e, "", "ext-part");
                String part = XMLUtils.getAttribute(e, "", "part");
                String download = XMLUtils.getAttribute(e, "", "download", "eager");
                boolean isLazy = "lazy".equals(download);
                al.add(new ExtDownloadDesc(extPart, part, isLazy));
            }
        });
        ExtDownloadDesc[] eds = new ExtDownloadDesc[al.size()];
        return al.toArray(eds);
    }

    private static ApplicationDesc buildApplicationDesc(final String source, XMLNode root) throws MissingFieldException, BadFieldException {
        String appType;
        String mainclass = XMLUtils.getClassName(source, root, "<application-desc>", "main-class", false);
        String progressclass = XMLUtils.getClassName(source, root, "<application-desc>", "progress-class", false);
        if (progressclass == null) {
            progressclass = XMLUtils.getClassName(source, root, "<application-desc>", "preloader-class", false);
        }
        if (!"Java".equalsIgnoreCase(appType = XMLUtils.getAttribute(root, "<application-desc>", "type", "Java")) && !"JavaFx".equalsIgnoreCase(appType)) {
            throw new BadFieldException(source, XMLUtils.getPathString(root) + "<application-desc>type", appType);
        }
        final ArrayList al1 = new ArrayList();
        XMLUtils.visitElements(root, "<application-desc><argument>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode e) throws MissingFieldException, BadFieldException {
                String arg = XMLUtils.getElementContents(e, "", null);
                if (arg == null) {
                    throw new BadFieldException(source, XMLUtils.getPathString(e), "");
                }
                al1.add(arg);
            }
        });
        String[] args1 = new String[al1.size()];
        args1 = al1.toArray(args1);
        final Properties params = new Properties();
        XMLUtils.visitElements(root, "<application-desc><param>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode e) throws MissingFieldException, BadFieldException {
                String pn = XMLUtils.getRequiredAttribute(source, e, "", "name");
                String pv = XMLUtils.getRequiredAttributeEmptyOK(source, e, "", "value");
                params.setProperty(pn, pv);
            }
        });
        return new ApplicationDesc(mainclass, progressclass, args1, appType, params);
    }

    private static JavaFXAppDesc buildFXAppDesc(final String source, XMLNode root, String element) throws MissingFieldException, BadFieldException {
        String mainclass = XMLUtils.getClassName(source, root, element, "main-class", true);
        String preloaderclass = XMLUtils.getClassName(source, root, element, "progress-class", false);
        if (preloaderclass == null) {
            preloaderclass = XMLUtils.getClassName(source, root, "<javafx-desc>", "preloader-class", false);
        }
        final ArrayList al1 = new ArrayList();
        XMLUtils.visitElements(root, "<javafx-desc><argument>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode e) throws MissingFieldException, BadFieldException {
                String arg = XMLUtils.getElementContents(e, "", null);
                if (arg == null) {
                    throw new BadFieldException(source, XMLUtils.getPathString(e), "");
                }
                al1.add(arg);
            }
        });
        String[] args1 = null;
        if (!al1.isEmpty()) {
            args1 = new String[al1.size()];
            args1 = al1.toArray(args1);
        }
        final Properties params = new Properties();
        XMLUtils.visitElements(root, "<javafx-desc><param>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode e) throws MissingFieldException, BadFieldException {
                String pn = XMLUtils.getRequiredAttribute(source, e, "", "name");
                String pv = XMLUtils.getRequiredAttributeEmptyOK(source, e, "", "value");
                params.setProperty(pn, pv);
            }
        });
        return new JavaFXAppDesc(mainclass, preloaderclass, args1, params);
    }

    private static LibraryDesc buildLibraryDesc(String source, XMLNode root) throws MissingFieldException, BadFieldException {
        String progressclass = XMLUtils.getClassName(source, root, "<component-desc>", "progress-class", false);
        if (progressclass == null) {
            progressclass = XMLUtils.getClassName(source, root, "<application-desc>", "preloader-class", false);
        }
        return new LibraryDesc(progressclass);
    }

    private static InstallerDesc buildInstallerDesc(String source, URL codebase, XMLNode root) throws MissingFieldException, BadFieldException {
        String mainclass = XMLUtils.getClassName(source, root, "<installer-desc>", "main-class", false);
        return new InstallerDesc(mainclass);
    }

    private static AppletDesc buildAppletDesc(final String source, URL codebase, URL documentBase, XMLNode root) throws MissingFieldException, BadFieldException {
        String appletclass = XMLUtils.getClassName(source, root, "<applet-desc>", "main-class", true);
        String progressclass = XMLUtils.getClassName(source, root, "<applet-desc>", "progress-class", false);
        if (progressclass == null) {
            progressclass = XMLUtils.getClassName(source, root, "<application-desc>", "preloader-class", false);
        }
        String name = XMLUtils.getRequiredAttribute(source, root, "<applet-desc>", "name");
        String widthStr = XMLUtils.getRequiredAttribute(source, root, "<applet-desc>", "width");
        String heightStr = XMLUtils.getRequiredAttribute(source, root, "<applet-desc>", "width");
        int width = 0;
        int height = 0;
        try {
            width = widthStr.endsWith("%") ? SystemUtils.parsePercent((String)widthStr, (int)XMLFormat.getScreenWidth()) : Integer.parseInt(widthStr);
        }
        catch (Exception e) {
            throw new BadFieldException(widthStr, XMLUtils.getPathString(root) + "<applet-desc> width", widthStr);
        }
        try {
            height = heightStr.endsWith("%") ? SystemUtils.parsePercent((String)heightStr, (int)XMLFormat.getScreenHeight()) : Integer.parseInt(heightStr);
        }
        catch (Exception e) {
            throw new BadFieldException(widthStr, XMLUtils.getPathString(root) + "<applet-desc> height", heightStr);
        }
        if (width <= 0) {
            throw new BadFieldException(source, XMLUtils.getPathString(root) + "<applet-desc>width", Integer.toString(width));
        }
        if (height <= 0) {
            throw new BadFieldException(source, XMLUtils.getPathString(root) + "<applet-desc>height", Integer.toString(height));
        }
        final Properties params = new Properties();
        XMLUtils.visitElements(root, "<applet-desc><param>", new XMLUtils.ElementVisitor(){

            @Override
            public void visitElement(XMLNode e) throws MissingFieldException, BadFieldException {
                String pn = XMLUtils.getRequiredAttribute(source, e, "", "name");
                String pv = XMLUtils.getRequiredAttributeEmptyOK(source, e, "", "value");
                params.setProperty(pn, pv);
            }
        });
        return new AppletDesc(name, appletclass, documentBase, width, height, params, progressclass);
    }

    public static boolean isBlacklisted(XMLNode node) {
        if (node == null) {
            return false;
        }
        if (node.getName() != null) {
            if (node.getName().equals("java") || node.getName().equals("j2se")) {
                String value = node.getAttribute("java-vm-args");
                if (value != null && value.contains("*")) {
                    Trace.println((String)("Blacklisted java-vm-args: " + value), (TraceLevel)TraceLevel.SECURITY);
                    return true;
                }
            } else if (node.getName().equals("property")) {
                String name = node.getAttribute("name");
                String value = node.getAttribute("value");
                if (name != null && name.contains("*")) {
                    Trace.println((String)("Blacklisted property name: name=" + name + " value=" + value), (TraceLevel)TraceLevel.SECURITY);
                    return true;
                }
                if (!Config.isSecurePropertyKey((String)name) && value != null && value.contains("*")) {
                    Trace.println((String)("Blacklisted property value: name=" + name + " value=" + value), (TraceLevel)TraceLevel.SECURITY);
                    return true;
                }
            }
        }
        if (XMLFormat.isBlacklisted(node.getNested())) {
            return true;
        }
        return XMLFormat.isBlacklisted(node.getNext());
    }

    private static void setSourceURL(LaunchDesc ld, URL url) {
        URL cb;
        File file = null;
        if (url != null) {
            if (!ld.isApplicationDescriptor()) {
                ld.setSourceURL(url);
            } else if ("file".equalsIgnoreCase(url.getProtocol())) {
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    file = new File(url.getPath());
                }
            } else {
                ld.setSourceURL(url);
            }
        }
        if (file != null && !Cache.isFileWithinCache(file) && (cb = ld.getCodebase()) != null && "file".equals(cb.getProtocol())) {
            ld.setSourceURL(url);
        }
    }

    private static Rectangle getScreen() {
        if (screen == null) {
            try {
                screen = UIFactory.getMouseScreenBounds();
            }
            catch (Exception e) {
                screen = new Rectangle(1280, 1024);
            }
        }
        return screen;
    }

    private static int getScreenWidth() {
        return (int)XMLFormat.getScreen().getWidth();
    }

    private static int getScreenHeight() {
        return (int)XMLFormat.getScreen().getHeight();
    }
}

