/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.javaws.Globals;
import com.sun.javaws.Launcher;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.javaws.ui.UpdateDialog;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;

public class LDUpdater {
    private LaunchDesc _ld = null;
    private boolean _updateAvailable;
    private boolean _updateDownloaded;
    private boolean _updateChecked;
    private boolean _checkAborted;
    private boolean _checkFaulted;
    private LocalApplicationProperties _lap = null;
    private volatile Thread backgroundUpdateThread = null;
    private Exception _exception = null;
    private int _numTasks = 0;
    private int _numTasksMax = 0;
    private boolean _checkDone;
    private boolean _disableUpdatePerPolicy = false;
    private RapidUpdateCheckerQueue queue = null;
    private static final String APPCONTEXT_LD_KEY = "deploy-mainlaunchdescinappcontext";
    private static int sequenceNumber = 0;

    public LDUpdater(LaunchDesc ld) {
        this._ld = ld;
        this.setMainLaunchDescInAppContext();
    }

    public boolean isCheckAborted() {
        return this._checkAborted;
    }

    public boolean isUpdateAvailable() throws Exception {
        boolean checkIcon = Environment.isJavaWebStart();
        if (this._ld.isHttps()) {
            return this.isUpdateAvailable(checkIcon, true, false);
        }
        return this.isUpdateAvailable(checkIcon, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUpdateAvailable(boolean checkIcon, boolean checkLazy, boolean rapidCheck) throws Exception {
        LDUpdater lDUpdater = this;
        synchronized (lDUpdater) {
            if (this._updateChecked) {
                return this._updateAvailable;
            }
        }
        try {
            if (this._ld.isApplicationDescriptor()) {
                this.startUpdateCheck(checkIcon, checkLazy, rapidCheck);
            } else {
                this._updateAvailable = this.updateCheck(checkIcon, checkLazy, rapidCheck);
            }
            lDUpdater = this;
            synchronized (lDUpdater) {
                this._updateChecked = true;
                this._updateDownloaded = !this._updateAvailable;
            }
            if (this._ld.isInstaller() && this._updateAvailable && ResourceProvider.get().isBackgroundUpdateRequest()) {
                this.setForceUpdateCheck();
            }
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
            throw e;
        }
        return this._updateAvailable;
    }

    public boolean isUpdateDownloaded() {
        return this._updateDownloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadUpdate(boolean includeLazy) throws Exception {
        if (this._updateAvailable) {
            this.download(includeLazy);
        }
        LDUpdater lDUpdater = this;
        synchronized (lDUpdater) {
            this._updateAvailable = false;
            this._updateDownloaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUpdateCheck(final boolean checkIcon, final boolean checkLazy, final boolean rapidCheck) throws Exception {
        int updateCheckType;
        if (this._lap == null) {
            this._lap = Cache.getLocalApplicationProperties((URL)this._ld.getCanonicalHome());
        }
        if ((updateCheckType = this._ld.getUpdate().getCheck()) == 2) {
            return;
        }
        int timeout = Config.getIntProperty((String)"deployment.javaws.update.timeout");
        final boolean[] results = new boolean[4];
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean available = false;
                boolean completed = false;
                boolean faulted = false;
                boolean aborted = false;
                try {
                    if (LDUpdater.this.updateCheck(checkIcon, checkLazy, rapidCheck)) {
                        available = true;
                        LDUpdater.this.setForceUpdateCheck();
                    }
                    completed = true;
                }
                catch (FailedDownloadingResourceException fdre) {
                    Throwable thr;
                    if (LDUpdater.this._ld.isHttps() && (thr = fdre.getWrappedException()) != null && thr instanceof SSLHandshakeException) {
                        aborted = true;
                    }
                    Trace.ignored((Throwable)fdre);
                    faulted = LDUpdater.this.checkException(fdre);
                }
                catch (Exception e) {
                    Trace.ignored((Throwable)e);
                    faulted = LDUpdater.this.checkException(e);
                }
                boolean[] blArray = results;
                synchronized (results) {
                    results[0] = available;
                    results[1] = completed;
                    results[2] = faulted;
                    results[3] = aborted;
                    results.notifyAll();
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return;
                }
            }
        }, "" + this._ld.getLocation()).start();
        boolean[] blArray = results;
        synchronized (results) {
            while (!(results[1] || results[2] || results[3])) {
                try {
                    results.wait(timeout);
                }
                catch (InterruptedException e) {
                    Trace.ignored((Throwable)e);
                }
                if (updateCheckType != 1 || this._ld.isHttps()) continue;
            }
            this._checkFaulted = results[2];
            this._checkAborted = results[3];
            this._updateAvailable = results[0];
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (this._checkFaulted) {
                throw this._exception;
            }
            return;
        }
    }

    public synchronized boolean isBackgroundUpdateRunning() {
        return null != this.backgroundUpdateThread;
    }

    public void startBackgroundUpdateOpt() {
        if (!Cache.isCacheEnabled() || DeployOfflineManager.isForcedOffline()) {
            return;
        }
        if (!this._ld.getUpdate().isBackgroundCheck()) {
            return;
        }
        if (null != this.backgroundUpdateThread) {
            return;
        }
        this.startBackgroundUpdate();
    }

    public void storeBackgroundListInAppContext() {
        if (!Cache.isCacheEnabled() || DeployOfflineManager.isForcedOffline()) {
            return;
        }
        if (!this._ld.getUpdate().isBackgroundCheck()) {
            return;
        }
        if (null != this.backgroundUpdateThread) {
            return;
        }
        ResourceProvider.get().storeAppContextBackgroundList(this.buildBackgroundDownloadList());
    }

    public boolean needUpdatePerPolicy(PreloaderDelegate dw) throws ExitException {
        boolean forceUpdate = false;
        switch (this._ld.getUpdate().getPolicy()) {
            default: {
                forceUpdate = true;
                break;
            }
            case 1: {
                forceUpdate = UpdateDialog.showUpdateDialog(this._ld, dw);
                if (forceUpdate) break;
                Trace.println((String)"User chose not to update", (TraceLevel)TraceLevel.CACHE);
                this._disableUpdatePerPolicy = true;
                break;
            }
            case 2: {
                forceUpdate = UpdateDialog.showUpdateDialog(this._ld, dw);
                if (forceUpdate) break;
                Trace.println((String)"Exiting after user chose not to update", (TraceLevel)TraceLevel.BASIC);
                throw new ExitException(new LaunchDescException(this._ld, "User cancelled mandatory update - aborted", null), 3);
            }
        }
        if (!forceUpdate && this._lap.forceUpdateCheck()) {
            this.resetForceUpdateCheck();
        }
        return forceUpdate;
    }

    public void disableUpdatePerPolicyIfNeeded() {
        if (this._disableUpdatePerPolicy) {
            ResourceProvider.get().disableUpdatePerPolicy();
        }
    }

    public boolean needUpdatePerPolicy() throws ExitException {
        return this.needUpdatePerPolicy(null);
    }

    private synchronized void startBackgroundUpdate() {
        this.startBackgroundUpdate(5000L);
    }

    protected synchronized void startBackgroundUpdate(final long delayMillis) {
        if (null != this.backgroundUpdateThread) {
            return;
        }
        Trace.println((String)"LDUpdater: started background update check", (TraceLevel)TraceLevel.NETWORK);
        final ArrayList<String> backgroundList = this.buildBackgroundDownloadList();
        ResourceProvider.get().storeAppContextBackgroundList(backgroundList);
        this.backgroundUpdateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ResourceProvider.get().setBackgroundUpdateRequest(true);
                    try {
                        Thread.sleep(delayMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    boolean downloadError = false;
                    if (LDUpdater.this.updateCheck(false, true, false)) {
                        try {
                            LDUpdater.this.download(true);
                        }
                        catch (Exception e) {
                            downloadError = true;
                            Trace.println((String)"LDUpdater: exception in background update download, set force update check to true", (TraceLevel)TraceLevel.NETWORK);
                            Trace.ignoredException((Exception)e);
                            LDUpdater.this.setForceUpdateCheck();
                        }
                    }
                    if (!downloadError) {
                        LDUpdater.this.resetForceUpdateCheck();
                    }
                }
                catch (Exception e) {
                    Trace.ignoredException((Exception)e);
                }
                finally {
                    LDUpdater.this.backgroundUpdateEnd(backgroundList);
                }
            }
        });
        this.backgroundUpdateThread.setName("Background Update Thread");
        this.backgroundUpdateThread.setPriority(1);
        this.backgroundUpdateThread.setDaemon(true);
        this.backgroundUpdateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backgroundUpdateEnd(List<String> backgroundList) {
        ResourceProvider.get().clearAppContextBackgroundList(backgroundList);
        LDUpdater lDUpdater = this;
        synchronized (lDUpdater) {
            this._updateAvailable = false;
            this._updateDownloaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCheck(boolean checkIcon, boolean checkLazy, boolean rapidCheck) throws Exception {
        IconDesc[] iconDescArray;
        JARDesc[] jars;
        ResourcesDesc rd;
        if (rapidCheck && this.queue == null) {
            this.queue = this.getQueue();
            if (this.queue == null) {
                rapidCheck = false;
            }
        }
        if (rapidCheck) {
            Object jars2;
            ResourcesDesc rd2;
            URL homeUrl = this._ld.getLocation();
            if (homeUrl != null) {
                this.incrementTaskNum();
                this.queue.enqueue(new RapidUpdateChecker(homeUrl, 0));
            }
            if ((rd2 = this._ld.getResources()) != null) {
                IconDesc[] iconDescArray2;
                for (JARDesc jar : jars2 = rd2.getLocalJarDescs()) {
                    if (!checkLazy && jar.isLazyDownload()) continue;
                    this.incrementTaskNum();
                    this.queue.enqueue(new RapidUpdateChecker(jar, 1));
                }
                if (checkIcon && (iconDescArray2 = this._ld.getInformation().getIcons()) != null) {
                    for (IconDesc icon : iconDescArray2) {
                        this.incrementTaskNum();
                        this.queue.enqueue(new RapidUpdateChecker(icon, 2));
                    }
                }
                ArrayList<ExtensionDesc> arrayList = new ArrayList<ExtensionDesc>();
                this.getAllExtensions(rd2, arrayList);
                for (ExtensionDesc list1 : arrayList) {
                    LaunchDesc extensionLD = list1.getExtensionDesc();
                    this.incrementTaskNum();
                    new Thread((Runnable)new RapidUpdateChecker(extensionLD, 3), "Rapid Update Checker- " + LDUpdater.nextSequenceNumber()).start();
                }
            }
            jars2 = this;
            synchronized (jars2) {
                while (!this._checkDone && !this._updateAvailable) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignored((Throwable)interruptedException);
                        break;
                    }
                }
            }
            this.stopQueue();
            if (!this._updateAvailable && this._exception != null) {
                throw this._exception;
            }
            return this._updateAvailable;
        }
        URL homeUrl = this._ld.getLocation();
        if (homeUrl != null) {
            try {
                if (ResourceProvider.get().isUpdateAvailable(homeUrl, null)) {
                    return true;
                }
            }
            catch (IOException ioe) {
                throw new FailedDownloadingResourceException(homeUrl, null, ioe);
            }
        }
        if ((rd = this._ld.getResources()) == null) {
            return false;
        }
        for (JARDesc jar : jars = rd.getLocalJarDescs()) {
            if (!checkLazy && jar.isLazyDownload() || !jar.getUpdater().isUpdateAvailable()) continue;
            return true;
        }
        if (checkIcon && (iconDescArray = this._ld.getInformation().getIcons()) != null) {
            for (IconDesc icon : iconDescArray) {
                URL location = icon.getLocation();
                String version = icon.getVersion();
                try {
                    if (!ResourceProvider.get().isUpdateAvailable(location, version)) continue;
                    Globals.setIconImageUpdated(true);
                }
                catch (IOException ioe) {
                    throw new FailedDownloadingResourceException(location, null, ioe);
                }
            }
        }
        ArrayList<ExtensionDesc> arrayList = new ArrayList<ExtensionDesc>();
        this.getAllExtensions(rd, arrayList);
        for (ExtensionDesc list1 : arrayList) {
            LaunchDesc extensionLD = list1.getExtensionDesc();
            try {
                if (!extensionLD.getUpdater().isUpdateAvailable(checkIcon, checkLazy, rapidCheck)) continue;
                return true;
            }
            catch (NullPointerException npe) {
                Trace.ignored((Throwable)npe);
            }
        }
        return false;
    }

    private void getAllExtensions(ResourcesDesc rd, final ArrayList<ExtensionDesc> list) {
        rd.visit(new ResourceVisitor(){

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                list.add(ed);
            }
        });
    }

    private void download(boolean includeLazy) throws Exception, JNLPException {
        int current = ResourceProvider.get().incrementInternalUse();
        try {
            this._download(includeLazy);
        }
        finally {
            ResourceProvider.get().decrementInternalUse(current);
        }
    }

    private void _download(boolean includeLazy) throws Exception, JNLPException {
        ExtensionDesc[] extensions;
        ResourcesDesc rd;
        URL location = this._ld.getRealLocation();
        boolean jnlpUpdate = ResourceProvider.get().isUpdateAvailable(location, null);
        if (jnlpUpdate) {
            LocalApplicationProperties lap;
            Resource r = ResourceProvider.get().downloadUpdate(location, null);
            File newJnlpFile = r.getDataFile();
            if (!this._ld.hasIdenticalContent(newJnlpFile)) {
                this._ld = LaunchDescFactory.buildDescriptor(newJnlpFile, this._ld.getCodebase(), location, location);
            }
            if ((lap = Cache.getLocalApplicationProperties((URL)location)) != null) {
                Launcher.notifyLocalInstallHandler(this._ld, lap, true, true, null);
            }
        }
        if ((rd = this._ld.getResources()) == null) {
            return;
        }
        JARDesc[] jardescs = rd.getLocalJarDescs();
        ArrayList<JARDesc> jars = new ArrayList<JARDesc>();
        if (includeLazy) {
            jars.addAll(Arrays.asList(jardescs));
        } else {
            for (JARDesc jardesc : jardescs) {
                if (jardesc.isLazyDownload()) continue;
                jars.add(jardesc);
            }
        }
        ArrayList<Resource> newDownloads = new ArrayList<Resource>();
        for (JARDesc jar : jars) {
            if (!jar.getUpdater().isUpdateAvailable()) continue;
            if (jar.isLazyDownload()) {
                ResourceProvider.get().markRetired(ResourceProvider.get().getCachedResource(jar.getLocation(), jar.getVersion()), true);
                continue;
            }
            Resource r = jar.getUpdater().downloadUpdate();
            if (r == null) continue;
            newDownloads.add(r);
        }
        ResourceProvider.get().markReady(newDownloads.toArray(new Resource[newDownloads.size()]));
        IconDesc id = this._ld.getInformation().getIconLocation(48, 0);
        if (id != null) {
            try {
                ResourceProvider.get().getResource(id.getLocation(), id.getVersion());
                Trace.println((String)("Downloaded " + id.getLocation()), (TraceLevel)TraceLevel.NETWORK);
            }
            catch (Exception e) {
                Trace.ignored((Throwable)e);
            }
        }
        for (ExtensionDesc extension : extensions = rd.getExtensionDescs()) {
            LaunchDesc extensionLD = extension.getExtensionDesc();
            URL extLocation = extensionLD.getLocation();
            try {
                if (!extensionLD.getUpdater().isUpdateAvailable(false, includeLazy, false)) continue;
                extensionLD.getUpdater().downloadUpdate(includeLazy);
            }
            catch (NullPointerException npe) {
                Trace.ignored((Throwable)npe);
            }
            catch (IOException ioe) {
                throw new FailedDownloadingResourceException(extLocation, null, ioe);
            }
        }
    }

    private void setForceUpdateCheck() {
        if (this._lap != null && !this._lap.forceUpdateCheck()) {
            this._lap.setForceUpdateCheck(true);
            try {
                this._lap.store();
            }
            catch (IOException ioe) {
                Trace.ignoredException((Exception)ioe);
            }
        }
    }

    private void resetForceUpdateCheck() {
        if (this._lap != null && this._lap.forceUpdateCheck()) {
            this._lap.setForceUpdateCheck(false);
            try {
                this._lap.store();
            }
            catch (IOException ioe) {
                Trace.ignoredException((Exception)ioe);
            }
        }
    }

    private ArrayList<String> buildBackgroundDownloadList() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ResourcesDesc rd;
            URL homeUrl = this._ld.getLocation();
            if (homeUrl != null) {
                list.add(homeUrl.toString());
            }
            if ((rd = this._ld.getResources()) != null) {
                IconDesc[] icons;
                ExtensionDesc[] extensions;
                for (ExtensionDesc extension : extensions = rd.getExtensionDescs()) {
                    URL extensionUrl = extension.getLocation();
                    if (extensionUrl == null) continue;
                    list.add(extensionUrl.toString());
                }
                JARDesc[] jars = rd.getEagerOrAllJarDescs(true);
                if (jars != null) {
                    for (JARDesc jar : jars) {
                        URL location = jar.getLocation();
                        if (location == null) continue;
                        list.add(location.toString());
                    }
                }
                if ((icons = this._ld.getInformation().getIcons()) != null) {
                    for (IconDesc icon : icons) {
                        URL location = icon.getLocation();
                        if (location == null) continue;
                        list.add(location.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextSequenceNumber() {
        Class<LDUpdater> clazz = LDUpdater.class;
        synchronized (LDUpdater.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ++sequenceNumber;
        }
    }

    private LDUpdater getMainLDUpdater() {
        if (this._ld.isApplicationDescriptor()) {
            return this._ld.getUpdater();
        }
        LaunchDesc mainLd = this.getMainLaunchDescFromAppContext();
        if (null != mainLd) {
            return mainLd.getUpdater();
        }
        return null;
    }

    private RapidUpdateCheckerQueue getQueue() {
        if (!this._ld.isApplicationDescriptor()) {
            LDUpdater updater = this.getMainLDUpdater();
            if (updater != null) {
                return updater.getQueue();
            }
            return null;
        }
        if (this.queue == null) {
            int n = this.getNumTasksMax();
            this.queue = new RapidUpdateCheckerQueue(n);
            new Thread((Runnable)this.queue, "Rapid Update Checker Queue").start();
        }
        return this.queue;
    }

    private void stopQueue() {
        if (!this._ld.isApplicationDescriptor()) {
            return;
        }
        if (this.queue != null) {
            this.queue.stop();
        }
    }

    private int getNumTasksMax() {
        if (this._numTasksMax != 0) {
            return this._numTasksMax;
        }
        if (this._ld.isApplicationDescriptor()) {
            this._numTasksMax = this._ld.getResources().getConcurrentDownloads();
            return this._numTasksMax;
        }
        LaunchDesc mainAppLd = this.getMainLaunchDescFromAppContext();
        if (mainAppLd != null) {
            return mainAppLd.getUpdater().getNumTasksMax();
        }
        return 4;
    }

    private void setMainLaunchDescInAppContext() {
        if (this._ld.isApplicationDescriptor()) {
            ToolkitStore.get().getAppContext().put((Object)APPCONTEXT_LD_KEY, (Object)this._ld);
        }
    }

    private LaunchDesc getMainLaunchDescFromAppContext() {
        Object o = ToolkitStore.get().getAppContext().get((Object)APPCONTEXT_LD_KEY);
        if (null != o) {
            return (LaunchDesc)o;
        }
        return null;
    }

    private synchronized void incrementTaskNum() {
        ++this._numTasks;
    }

    private synchronized void notifyUpdate(boolean update) {
        if (update) {
            this._updateAvailable = true;
            this.notifyAll();
        } else if (--this._numTasks == 0) {
            this._checkDone = true;
            this.notifyAll();
        }
    }

    private synchronized void notifyException(Exception e) {
        if (this._ld != null && this._ld.getInformation().supportsOfflineOperation()) {
            Trace.ignoredException((Exception)e);
            return;
        }
        if (this._exception == null) {
            this._exception = e;
        }
    }

    private boolean checkException(Exception exception) {
        Throwable t;
        return this._ld.getUpdate().getCheck() != 1 || !this._ld.getInformation().supportsOfflineOperation() || !(exception instanceof JNLPException) || !((t = ((JNLPException)exception).getWrappedException()) instanceof IOException);
    }

    private class RapidUpdateChecker
    implements Runnable {
        private static final int HOME_URL = 0;
        private static final int JAR_DESC = 1;
        private static final int ICON_DESC = 2;
        private static final int EXT_LD = 3;
        private Object target;
        private int type;
        private boolean update = false;

        private RapidUpdateChecker(Object target, int type) {
            this.target = target;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                switch (this.type) {
                    case 0: {
                        URL homeUrl = (URL)this.target;
                        Trace.println((String)("LDUpdater: update check for " + homeUrl), (TraceLevel)TraceLevel.NETWORK);
                        try {
                            this.update = ResourceProvider.get().isUpdateAvailable(homeUrl, null);
                            return;
                        }
                        catch (IOException ioe) {
                            throw new FailedDownloadingResourceException(homeUrl, null, ioe);
                        }
                    }
                    case 1: {
                        JARDesc jar = (JARDesc)this.target;
                        Trace.println((String)("LDUpdater: update check for " + jar.getLocation()), (TraceLevel)TraceLevel.NETWORK);
                        this.update = jar.getUpdater().isUpdateAvailable();
                        return;
                    }
                    case 2: {
                        IconDesc icon = (IconDesc)this.target;
                        URL location = icon.getLocation();
                        String version = icon.getVersion();
                        try {
                            if (!ResourceProvider.get().isUpdateAvailable(location, version)) return;
                            Globals.setIconImageUpdated(true);
                            return;
                        }
                        catch (IOException ioe) {
                            throw new FailedDownloadingResourceException(location, null, ioe);
                        }
                    }
                    case 3: {
                        LaunchDesc ext = (LaunchDesc)this.target;
                        Trace.println((String)("LDUpdater: update check for " + ext.getLocation()), (TraceLevel)TraceLevel.NETWORK);
                        this.update = ext.getUpdater().isUpdateAvailable();
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                LDUpdater.this.notifyException(e);
                return;
            }
            finally {
                LDUpdater.this.notifyUpdate(this.update);
                LDUpdater.this.queue.decreaseNumTasks();
            }
        }
    }

    private class RapidUpdateCheckerQueue
    implements Runnable {
        private static final String RAPID_CHECK_THREAD_NAME = "Rapid Update Checker- ";
        private volatile boolean shouldStop;
        private final Object lock = new Object();
        private LinkedList<Runnable> workQueue = new LinkedList();
        private int nThreads = 0;
        private int nThreadsMax;

        private RapidUpdateCheckerQueue(int max) {
            this.nThreadsMax = max;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueue(Runnable task) {
            Object object = this.lock;
            synchronized (object) {
                this.workQueue.add(task);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            this.shouldStop = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.shouldStop) {
                    Object object = this.lock;
                    synchronized (object) {
                        while (!this.shouldStop && this.workQueue.isEmpty()) {
                            try {
                                this.lock.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    while (!this.shouldStop && !this.workQueue.isEmpty()) {
                        Runnable task = null;
                        Object object2 = this.lock;
                        synchronized (object2) {
                            task = this.workQueue.removeFirst();
                        }
                        object2 = this;
                        synchronized (object2) {
                            while (this.nThreads >= this.nThreadsMax) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            ++this.nThreads;
                        }
                        new Thread(task, RAPID_CHECK_THREAD_NAME + LDUpdater.nextSequenceNumber()).start();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private synchronized void decreaseNumTasks() {
            --this.nThreads;
            this.notifyAll();
        }
    }
}

