/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Waiter;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;

public final class FileOpenServiceNSBImpl
implements FileOpenService {
    private final FileOpenServiceImpl service;
    private static final AccessControlContext ACC_DIALOG_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new FilePermission("<<ALL FILES>>", "read,write"));
            ((PermissionCollection)permissions).add(new RuntimePermission("setContextClassLoader"));
            ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.apple.*"));
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }
    });

    public FileOpenServiceNSBImpl(FileOpenServiceImpl fileOpenServiceImpl) {
        this.service = fileOpenServiceImpl;
    }

    @Override
    public FileContents openFileDialog(final String string, final String[] stringArray) throws IOException {
        if (!this.service.askUser()) {
            return null;
        }
        Waiter.WaiterTask waiterTask = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (FileContents)DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        String string = Platform.get().getNativeSandboxBroker().openFileDialog(string, stringArray);
                        if (string == null) {
                            return null;
                        }
                        File file = new File(string);
                        if (file != null) {
                            try {
                                FileOpenServiceImpl._fileSaveServiceImpl.setLastPath(file.getPath());
                                return new FileContentsImpl(file, FileSaveServiceImpl.computeMaxLength(file.length()));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (FileContents)Waiter.runAndWait((Waiter.WaiterTask)waiterTask);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return null;
        }
    }

    @Override
    public FileContents[] openMultiFileDialog(final String string, final String[] stringArray) throws IOException {
        if (!this.service.askUser()) {
            return null;
        }
        Waiter.WaiterTask waiterTask = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (FileContents[])DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        String[] stringArray = Platform.get().getNativeSandboxBroker().openMultiFileDialog(string, stringArray);
                        if (stringArray == null) {
                            return null;
                        }
                        if (stringArray != null && stringArray.length > 0) {
                            FileContents[] fileContentsArray = new FileContents[stringArray.length];
                            for (int i = 0; i < stringArray.length; ++i) {
                                try {
                                    File file = new File(stringArray[i]);
                                    fileContentsArray[i] = new FileContentsImpl(file, FileSaveServiceImpl.computeMaxLength(file.length()));
                                    continue;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return fileContentsArray;
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (FileContents[])Waiter.runAndWait((Waiter.WaiterTask)waiterTask);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return null;
        }
    }
}

