/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.jnlp.CacheEntryResourceSpec;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import javax.jnlp.DownloadService2;

public class DownloadService2Impl
implements DownloadService2 {
    private static DownloadService2Impl instance;
    private static final AccessControlContext ACC_FILE_INSTANCE;

    public static synchronized DownloadService2 getInstance() {
        if (instance == null) {
            instance = new DownloadService2Impl();
        }
        return instance;
    }

    private DownloadService2Impl() {
    }

    public DownloadService2.ResourceSpec[] getCachedResources(final DownloadService2.ResourceSpec spec) {
        this.validateResourceSpec(spec);
        final ArrayList matchingResources = new ArrayList();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                DownloadService2Impl.this.getCachedResourcesImpl(spec, matchingResources);
                return null;
            }
        }, ACC_FILE_INSTANCE);
        return matchingResources.toArray(new DownloadService2.ResourceSpec[matchingResources.size()]);
    }

    private void getCachedResourcesImpl(DownloadService2.ResourceSpec spec, ArrayList<DownloadService2.ResourceSpec> matchingResources) {
        File[] idxFiles;
        for (File idxFile : idxFiles = Cache.getCacheEntries((boolean)false)) {
            CacheEntry ce = Cache.getCacheEntryFromFile((File)idxFile);
            if (!this.matches(ce, spec)) continue;
            matchingResources.add(new CacheEntryResourceSpec(ce));
        }
    }

    private boolean matches(CacheEntry ce, DownloadService2.ResourceSpec spec) {
        if (ce == null || ce.getURL() == null || ce.getURL().trim().length() == 0) {
            return false;
        }
        boolean matches = false;
        String urlSpec = spec.getUrl();
        if (urlSpec != null) {
            String versionSpec = spec.getVersion();
            String ceVersion = ce.getVersion();
            int typeSpec = spec.getType();
            boolean typeMatches = typeSpec == 0 || typeSpec == DownloadService2Impl.getResourceType(ce);
            boolean versionMatches = versionSpec == null && ceVersion == null || versionSpec != null && ceVersion != null && ceVersion.matches(versionSpec);
            matches = ce.getURL().matches(urlSpec) && versionMatches && typeMatches;
        }
        return matches;
    }

    static int getResourceType(CacheEntry ce) {
        String url = ce.getURL();
        String fixedUrl = DownloadService2Impl.getLowerNameExtension(url);
        int type = 0;
        if (ce.isJNLPFile()) {
            try {
                URL ceUrl = new URL(url);
                LaunchDesc ld = LaunchDescFactory.buildDescriptor(ce.getDataFile(), URLUtil.getBase((URL)ceUrl), null, ceUrl);
                if (ld.isApplication()) {
                    type = 1;
                } else if (ld.isApplet()) {
                    type = 2;
                } else if (ld.isInstaller() || ld.isLibrary()) {
                    type = 3;
                }
            }
            catch (Exception exception) {}
        } else if (ce.isJarFile()) {
            type = 4;
        } else if (fixedUrl.endsWith("png") || fixedUrl.endsWith("gif") || fixedUrl.endsWith("jpeg") || fixedUrl.endsWith("jpg") || fixedUrl.endsWith("ico")) {
            type = 5;
        } else if (fixedUrl.endsWith("class")) {
            type = 6;
        }
        return type;
    }

    private static String getLowerNameExtension(String url) {
        if (url.indexOf(63) != -1) {
            url = url.substring(0, url.indexOf(63));
        }
        while (url.charAt(url.length() - 1) == '/') {
            url = url.substring(0, url.length() - 1);
        }
        url = url.toLowerCase();
        return url;
    }

    public DownloadService2.ResourceSpec[] getUpdateAvailableResources(DownloadService2.ResourceSpec spec) {
        this.validateResourceSpec(spec);
        DownloadService2.ResourceSpec[] inCache = this.getCachedResources(spec);
        ArrayList<DownloadService2.ResourceSpec> updateAvailable = new ArrayList<DownloadService2.ResourceSpec>();
        for (DownloadService2.ResourceSpec inCacheSpec : inCache) {
            URL url;
            try {
                url = new URL(inCacheSpec.getUrl());
            }
            catch (MalformedURLException ex) {
                InternalError err = new InternalError(ex);
                throw err;
            }
            try {
                if (inCacheSpec.getVersion() == null) {
                    if (!ResourceProvider.get().isUpdateAvailable(url, null)) continue;
                    updateAvailable.add(inCacheSpec);
                    continue;
                }
                String versionAvailable = DownloadEngine.getAvailableVersion((URL)url, (String)"0+", (boolean)false, null);
                if (ResourceProvider.get().isCached(url, versionAvailable)) continue;
                updateAvailable.add(inCacheSpec);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        DownloadService2.ResourceSpec[] array = new DownloadService2.ResourceSpec[updateAvailable.size()];
        for (int i = 0; i < updateAvailable.size(); ++i) {
            array[i] = (DownloadService2.ResourceSpec)updateAvailable.get(i);
        }
        return array;
    }

    private void validateResourceSpec(DownloadService2.ResourceSpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException("ResourceSpec is null");
        }
        String url = spec.getUrl();
        int type = spec.getType();
        if (url == null) {
            throw new IllegalArgumentException("ResourceSpec has null url");
        }
        if (url.isEmpty()) {
            throw new IllegalArgumentException("ResourceSpec has empty url");
        }
        if (type < 0 || type > 6) {
            throw new IllegalArgumentException("ResourceSpec has invalue type");
        }
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

