/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.net.URLPermission;
import java.security.Permission;
import java.util.HashSet;
import sun.plugin2.applet.SecurityManagerHelper;

public class FXAppletSecurityManager
extends SecurityManager {
    private final AppContext mainAppContext;
    private final SecurityManager fxSM = new SecurityManager();
    private final HashSet<String> restrictedPackages = new HashSet();

    public FXAppletSecurityManager() {
        SecurityManagerHelper.resetHelper(this.restrictedPackages);
        this.mainAppContext = ToolkitStore.get().getAppContext();
    }

    @Override
    public void checkConnect(String string, int n) {
        SecurityManagerHelper.checkConnectHelper(this.fxSM, string, n, null, false, this.getClassContext());
    }

    @Override
    public void checkConnect(String string, int n, Object object) {
        SecurityManagerHelper.checkConnectHelper(this.fxSM, string, n, object, true, this.getClassContext());
    }

    @Override
    public void checkPermission(Permission permission) {
        if (Config.isJavaVersionAtLeast18() && permission instanceof URLPermission) {
            SecurityManagerHelper.checkURLPermissionHelper(this.fxSM, permission, null, false, this.getClassContext());
            return;
        }
        super.checkPermission(permission);
        SecurityManagerHelper.checkPermissionHelper(permission);
    }

    @Override
    public void checkPermission(Permission permission, Object object) {
        if (Config.isJavaVersionAtLeast18() && permission instanceof URLPermission) {
            SecurityManagerHelper.checkURLPermissionHelper(this.fxSM, permission, object, true, this.getClassContext());
            return;
        }
        super.checkPermission(permission, object);
    }

    @Override
    public void checkAccess(Thread thread) {
        SecurityManagerHelper.checkAccessHelper(thread, this.fxSM, this.currentClassLoaderSafe(), this.getClassContext());
    }

    @Override
    public void checkAccess(ThreadGroup threadGroup) {
        SecurityManagerHelper.checkAccessHelper(threadGroup, this.fxSM, this.currentClassLoaderSafe(), this.getClassContext());
    }

    @Override
    public void checkPackageAccess(String string) {
        SecurityManagerHelper.checkPackageAccessHelper(this.fxSM, string, this.restrictedPackages);
    }

    @Override
    public void checkPrintJobAccess() {
        SecurityManagerHelper.checkPrintJobAccessHelper(this.fxSM);
    }

    @Override
    public void checkSecurityAccess(String string) {
        SecurityManagerHelper.checkSecurityAccessHelper(this.fxSM, string);
    }

    public AppContext getAppContext() {
        return SecurityManagerHelper.getAppContextHelper(this.currentClassLoaderSafe(), this.getClassContext());
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return SecurityManagerHelper.getThreadGroupHelper(this.fxSM, this.currentClassLoaderSafe(), this.getClassContext());
    }

    public boolean checkTopLevelWindow(Object object) {
        if (object == null) {
            throw new NullPointerException("window can't be null");
        }
        return super.checkTopLevelWindow(object);
    }

    private ClassLoader currentClassLoaderSafe() {
        return Thread.currentThread().getContextClassLoader();
    }
}

