/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import sun.plugin2.message.AppletMessage;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Serializer;

public class GetAuthenticationMessage
extends AppletMessage {
    public static final int ID = 43;
    private String protocol;
    private String host;
    private int port;
    private String scheme;
    private String realm;
    private String requestURL;
    private boolean proxyAuthentication;

    public GetAuthenticationMessage(Conversation c) {
        super(43, c);
    }

    public GetAuthenticationMessage(Conversation c, int appletID, String protocol, String host, int port, String scheme, String realm, URL requestURL, boolean proxyAuthentication) {
        super(43, c, appletID);
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.scheme = scheme;
        this.realm = realm;
        this.requestURL = requestURL.toExternalForm();
        this.proxyAuthentication = proxyAuthentication;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getRealm() {
        return this.realm;
    }

    public URL getRequestURL() {
        try {
            return new URL(this.requestURL);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getProxyAuthentication() {
        return this.proxyAuthentication;
    }

    @Override
    public void writeFields(Serializer ser) throws IOException {
        super.writeFields(ser);
        ser.writeUTF(this.protocol);
        ser.writeUTF(this.host);
        ser.writeInt(this.port);
        ser.writeUTF(this.scheme);
        ser.writeUTF(this.realm);
        ser.writeUTF(this.requestURL);
        ser.writeBoolean(this.proxyAuthentication);
    }

    @Override
    public void readFields(Serializer ser) throws IOException {
        super.readFields(ser);
        this.protocol = ser.readUTF();
        this.host = ser.readUTF();
        this.port = ser.readInt();
        this.scheme = ser.readUTF();
        this.realm = ser.readUTF();
        this.requestURL = ser.readUTF();
        this.proxyAuthentication = ser.readBoolean();
    }
}

