/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.util.SystemUtils;
import sun.plugin2.applet.Applet2ThreadGroup;
import sun.plugin2.applet.Plugin2Manager;

public class JVMHealthData {
    public static final long HEALTHY_AVAILABLE_HEAP_SIZE = 0x2000000L;
    public static final int MAX_APPLET_THREAD_COUNT = Config.getMaxAppletThreadCount();
    private static final boolean DEBUG = Config.getDebug();
    private static final boolean NO_HEARTBEAT;
    private long maxHeapSize = -1L;
    private long heapSize = -1L;
    private long freeHeapSize = -1L;
    private int appletThreadCount = -1;
    private long launchMicroSeconds = -1L;

    public JVMHealthData() {
    }

    public JVMHealthData(long max, long total, long free, int threadCount) {
        this.maxHeapSize = max;
        this.heapSize = total;
        this.freeHeapSize = free;
        this.appletThreadCount = threadCount;
    }

    public static JVMHealthData getCurrent() {
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        int threadCount = Applet2ThreadGroup.getAppletThreadCount();
        JVMHealthData ret = new JVMHealthData(max, total, free, threadCount);
        long jvmLaunch = Plugin2Manager.getJVMLaunchTime();
        if (jvmLaunch <= 0L) {
            jvmLaunch = SystemUtils.microTime();
        }
        ret.setLaunchMicroSeconds(jvmLaunch);
        return ret;
    }

    public JVMHealthData clone() {
        JVMHealthData ret = new JVMHealthData(this.maxHeapSize, this.heapSize, this.freeHeapSize, this.appletThreadCount);
        ret.setLaunchMicroSeconds(this.launchMicroSeconds);
        return ret;
    }

    public long getFreeHeapSize() {
        return this.freeHeapSize;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public long getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public long getUsedHeapSize() {
        if (!this.validateMemoryData()) {
            return -1L;
        }
        return this.heapSize - this.freeHeapSize;
    }

    public long getAvailableHeapSize() {
        if (!this.validateMemoryData()) {
            return -1L;
        }
        return this.maxHeapSize - this.getUsedHeapSize();
    }

    public int getAppletThreadCount() {
        return this.appletThreadCount;
    }

    private boolean validateMemoryData() {
        return this.maxHeapSize >= 0L && this.heapSize >= 0L && this.freeHeapSize >= 0L;
    }

    public synchronized void updateFrom(JVMHealthData health) {
        this.maxHeapSize = health.getMaxHeapSize();
        this.heapSize = health.getHeapSize();
        this.freeHeapSize = health.getFreeHeapSize();
        this.appletThreadCount = health.getAppletThreadCount();
    }

    public synchronized boolean isHealthy() {
        if (NO_HEARTBEAT) {
            return true;
        }
        if (!this.beenLaunched()) {
            return false;
        }
        if (this.getMaxHeapSize() < 0L && this.currentAgeSeconds() < 5L) {
            return true;
        }
        return this.getMaxHeapSize() > 0L && this.getAvailableHeapSize() >= 0x2000000L && this.getAppletThreadCount() < MAX_APPLET_THREAD_COUNT;
    }

    public void setLaunchMicroSeconds(long launchMicrosecs) {
        this.launchMicroSeconds = launchMicrosecs;
    }

    private boolean beenLaunched() {
        return this.launchMicroSeconds > 0L;
    }

    public long currentAgeSeconds() {
        if (this.launchMicroSeconds == 0L) {
            return 0L;
        }
        return (SystemUtils.microTime() - this.launchMicroSeconds) / 1000000L;
    }

    public String toString() {
        return new StringBuffer().append("{ healthy: ").append(this.isHealthy()).append(", ageSeconds: ").append(this.currentAgeSeconds()).append(", availableHeapKB: ").append(this.getAvailableHeapSize() / 1024L).append(", appletThreads: ").append(this.getAppletThreadCount()).append(" }").toString();
    }

    static {
        boolean bl = NO_HEARTBEAT = Environment.getenv((String)"JPI_PLUGIN2_NO_HEARTBEAT") != null;
        if (DEBUG && NO_HEARTBEAT) {
            System.out.println("JPI_PLUGIN2_NO_HEARTBEAT is set, all health data are assumed normal.");
        }
    }
}

