/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet.viewer;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.Window;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SystemUtils;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.text.html.parser.ParserDelegator;
import sun.plugin2.applet.Applet2Environment;
import sun.plugin2.applet.Applet2Listener;
import sun.plugin2.applet.Applet2Manager;
import sun.plugin2.applet.Plugin2ConsoleController;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.applet.context.NoopExecutionContext;
import sun.plugin2.applet.viewer.util.AppletTagParser;

public class Applet2Viewer {
    private static final boolean DEBUG = Config.getDebug();

    public static void main(String[] args) throws Exception {
        int height;
        int width;
        URL url;
        InputStream stream;
        if (args.length != 1) {
            System.out.println("Usage: Applet2Viewer [url to HTML page containing <applet> tag]");
            System.out.println("Views the first applet on the specified HTML page.");
            System.exit(1);
        }
        if ((stream = (url = new URL(args[0])).openStream()) == null) {
            throw new RuntimeException("Error opening URL " + url);
        }
        AppletTagParser finder = new AppletTagParser();
        new ParserDelegator().parse(new InputStreamReader(stream), finder, true);
        stream.close();
        if (!finder.foundApplet()) {
            System.out.println("No applet found on web page");
            System.exit(1);
        }
        AppletParameters params = finder.getParameters();
        Rectangle screen = UIFactory.getMouseScreenBounds();
        try {
            width = SystemUtils.parsePercent((String)((String)params.get((Object)"width")), (int)((int)screen.getWidth()));
        }
        catch (Exception e) {
            width = 512;
        }
        try {
            height = SystemUtils.parsePercent((String)((String)params.get((Object)"height")), (int)((int)screen.getHeight()));
        }
        catch (Exception e) {
            height = 512;
        }
        final int fw = width;
        final int fh = height;
        JVMParameters jvmParams = new JVMParameters();
        JREInfo homeJre = JREInfo.getHomeJRE();
        if (homeJre != null && !homeJre.isModularJRE()) {
            jvmParams.parseBootClassPath(JVMParameters.getPlugInDependentJars());
        }
        jvmParams.setDefault(true);
        JVMParameters.setRunningJVMParameters((JVMParameters)jvmParams);
        System.out.println("Initializing Applet2Environment");
        Applet2Environment.initialize(null, false, false, new Plugin2ConsoleController(null, null), null, null);
        final Applet2Manager manager = new Applet2Manager(null, null, false);
        manager.setAppletExecutionContext(new NoopExecutionContext(params, url.toExternalForm()));
        System.out.println("Starting applet with parameters:");
        for (String key : params.keySet()) {
            String val = (String)params.get((Object)key);
            System.out.println("  " + key + " = " + val);
        }
        AppContext appContext = manager.getAppletAppContext();
        appContext.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    manager.initialize();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Error while initializing manager: " + e + ", bail out");
                    return;
                }
                Window w = ToolkitStore.getWindowFactory().createWindow();
                final Frame f = (Frame)w.getWindowObject();
                f.setTitle("Applet2Viewer");
                f.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                f.setLayout(new BorderLayout());
                manager.setAppletParent(w);
                manager.addAppletListener(new Applet2Listener(){

                    @Override
                    public boolean appletSSVValidation(Plugin2Manager hostingManager) {
                        if (DEBUG) {
                            System.out.println("Applet2Viewer.appletSSVValidation");
                        }
                        return false;
                    }

                    @Override
                    public boolean isAppletRelaunchSupported() {
                        return false;
                    }

                    @Override
                    public void appletJRERelaunch(Plugin2Manager hostingManager, String javaVersion, String jvmArgs) {
                        if (DEBUG) {
                            System.out.println("Applet2Viewer.appletJRERelaunch:");
                            System.out.println("\tjava_version   : " + javaVersion);
                            System.out.println("\tjava_arguments : " + jvmArgs);
                            Exception e = new Exception("Applet2Viewer.appletJRERelaunch: " + javaVersion + " ; " + jvmArgs);
                            e.printStackTrace(System.out);
                        }
                    }

                    @Override
                    public void appletLoaded(Plugin2Manager hostingManager) {
                    }

                    @Override
                    public void appletReady(Plugin2Manager hostingManager) {
                        Canvas c = new Canvas();
                        c.setSize(fw, fh);
                        f.add((Component)c, "Center");
                        f.pack();
                        f.setVisible(true);
                        f.remove(c);
                    }

                    @Override
                    public void appletErrorOccurred(Plugin2Manager hostingManager) {
                    }

                    @Override
                    public String getBestJREVersion(Plugin2Manager hostingManager, String javaVersionStr, String jfxVersionStr) {
                        return null;
                    }
                });
                manager.start();
            }
        });
    }
}

