/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class JarCacheUtil {
    public static final String FileVersionRegEx = "\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}";
    private static final AccessControlContext ACC_FILE_INSTANCE;

    public static HashMap<String, String> getJarsWithVersion(String string, String string2, String string3) {
        String string4;
        String string5;
        StringTokenizer stringTokenizer;
        StringTokenizer stringTokenizer2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null && string2 != null) {
            int n;
            stringTokenizer2 = new StringTokenizer(string, ",", false);
            int n2 = stringTokenizer2.countTokens();
            if (n2 != (n = (stringTokenizer = new StringTokenizer(string2, ",", false)).countTokens()) && Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)ResourceManager.getString((String)"cache.version_attrib_error"), (TraceLevel)TraceLevel.BASIC);
            }
            while (stringTokenizer2.hasMoreTokens() && stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken().trim();
                string4 = stringTokenizer.nextToken().trim();
                hashMap.put(string5, string4);
            }
        }
        if (string3 != null) {
            stringTokenizer2 = new StringTokenizer(string3, ",", false);
            block1: while (stringTokenizer2.hasMoreTokens()) {
                String string6 = stringTokenizer2.nextToken().trim();
                stringTokenizer = new StringTokenizer(string6, ";", false);
                string5 = stringTokenizer.nextToken().trim();
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken().trim();
                    if (!Pattern.matches(FileVersionRegEx, string4)) continue;
                    hashMap.put(string5, string4);
                    continue block1;
                }
            }
        }
        return hashMap;
    }

    public static synchronized void preload(URL uRL, Map<String, String> map) throws IOException {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            URL uRL2 = new URL(uRL, string);
            if (!URLUtil.checkTargetURL((URL)uRL, (URL)uRL2)) {
                throw new SecurityException("Permission denied: " + uRL2);
            }
            URL uRL3 = null;
            uRL3 = string2 != null ? new URL("jar:" + uRL2.toString() + "?version-id=" + string2 + "!/") : new URL("jar:" + uRL2.toString() + "!/");
            JarURLConnection jarURLConnection = (JarURLConnection)uRL3.openConnection();
            jarURLConnection.getContentLength();
        }
    }

    public static JarFile cloneJarFile(final JarFile jarFile) throws IOException {
        if (jarFile == null) {
            return jarFile;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws Exception {
                    if (jarFile instanceof JarFile && jarFile instanceof ResourceObject) {
                        return (JarFile)((ResourceObject)jarFile).clone();
                    }
                    String string = jarFile.getName();
                    if (new File(string).exists()) {
                        return JarUtil.createJarFile((File)new File(jarFile.getName()), (boolean)true);
                    }
                    return jarFile;
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getCause().getMessage());
        }
    }

    static {
        Permissions permissions = new Permissions();
        ((PermissionCollection)permissions).add(new FilePermission("<<ALL FILES>>", "read,write,delete"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessDeclaredMembers"));
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }
}

