#!/usr/bin/pythonw
# -*- coding: UTF-8 -*-
  
from xml.dom.minidom import parse, parseString
import xml.dom.minidom
import zipfile,re,os,math
 
def AND(*fns):
    def combine(input):
        for fn in fns:
            if bool(fn(input)) == False:
                return False
        return True
    return combine
 
def OR(*fns):
    def combine(input):
        for fn in fns:
            if bool(fn(input)) == True:
                return True
        return False
    return combine
 
def NOT(fn):
    def combine(input):
        if bool(fn(input)) == True:
            return False
        else:
            return True
    return combine
 
def hasProperty(property):
    def hasPro(node):
        return node.getAttribute(property) or re.search(property,node.getAttribute("properties") + "," + node.getAttribute("name") + "," + node.getAttribute("application") + "," + node.getAttribute("class"))
    return hasPro
 
def getAttribute(attr):
    def getAttr(node):
        return node.getAttribute(attr)
    return getAttr
 
def decodeResourceRules(string):
    return filter(lambda x:x!=None, map(decodeResource,string.split(",")))
 
def decodeResource(string):
    reg1 = r"^(\w+)$"
    reg2 = r"^(\w+)-(\d+)$"
    reg3 = r"^(\w+)-(\d+)\|(\d+)$"
    reg4 = r"^(\w+)-(\d+)-([\d\.]+)$"
    found = re.match(reg1,string)
    if found != None:
        return {"name":found.group(1),"value":1.0,"type":"value"}
    found = re.match(reg2,string)
    if found != None:
        return {"name":found.group(1),"value":float(found.group(2)),"type":"value"}
    found = re.match(reg3,string)
    if found != None:
        return {"name":found.group(1),"value":[float(found.group(2)),float(found.group(3))],"type":"range"}
    found = re.match(reg4,string)
    if found != None:
        return {"name":found.group(1),"value":[float(found.group(2)),float(found.group(3))],"type":"chance"}
 
def encodeResourceRules(arr):
    return ','.join(map(encodeResource,arr))
 
def encodeResource(obj):
    name = obj["name"]
    type = obj["type"]
    value = obj["value"]
    if type == "value":
        if value > 1:
            return "%s-%d" % (name,value)
        return name
    if type == "range":
        return "%s-%d|%d" % (name,value[0],value[1])
    if type == "chance":
        if value[1] < 5:
            return "%s-%d-%s" % (name,value[0],trim(value[1]))
        elif value[1] < 100:
            return "%s-%d-%d" % (name,value[0],value[1])
        else:
            return encodeResource({"name":name,"type":"value","value":value[0] * value[1] / 100}) + ',' + encodeResource({"name":name,"type":type,"value":[value[0], value[1] % 100]})
    return ""
 
def generate(string):
    if string == None or string == "":
        return lambda x:True
    condition = decodeResource(string)
    def compare(arr):
        for rule in arr:
            if rule["name"] == condition["name"] and rule["type"]==condition["type"]:
                if rule["type"] == "value" and rule["value"] >= condition["value"]:
                    return True
                if rule["type"] == "range" and rule["value"][0] <= condition["value"][0] and rule["value"][1] >= condition["value"][1]:
                    return True
                if rule["type"] == "chance" and rule["value"][0] == condition["value"][0] and rule["value"][1] == condition["value"][1]:
                    return True
        return False
    return compare
 
def search(rule):
    def match(resource):
        for (k,v) in rule.items():
            if resource[k] != v:
                return False
        return True
    return match
 
def modifyRule(resources,rule):
    if isinstance(rule[0],list):
        for name in rule[0]:
            modifyRule(resources,[name,rule[1],rule[2],rule[3]])
        return
    name = rule[0]
    type = rule[1]
    value = rule[2]
    condition = generate(rule[3])
    if condition(resources) == True:
        hasResource = filter(search({"name":name}),resources)
        if len(hasResource) > 0:
            for resource in hasResource:
                #print resource
                if type == "value":
                    if resource["type"] == "value":
                        resource["value"] = resource["value"] + value
                    elif resource["type"] == "range":
                        resource["value"] = map(lambda x:x+value,resource["value"])
                    else:
                        resources.append({"name":name,"value":value,"type":type})
                elif type == "range":
                    if resource["type"] == "value":
                        resource["type"] = "range"
                        val = resource["value"]
                        resource["value"] = map(lambda x:x+val,value)
                    elif resource["type"] == "range":
                        resource["value"] = map(lambda x, y:x+y,resource["value"],value)
                    else:
                        resources.append({"name":name,"value":value,"type":type})
                else:
                    if resource["type"] == "value":
                        resource["value"] += resource["value"]*value[0]*value[1]/100
                    elif resource["type"] == "range":
                        resource["value"] = map(lambda x:x+x*value[0]*value[1]/100,resource["value"])
                    else:
                        if resource["value"][0] == value[0]:
                            resource["value"][1] = resource["value"][1] + value[1]
                        else:
                            resources.append({"name":name,"value":value,"type":type})
                #print resource
        elif rule[3] != None:
            resources.append({"name":name,"value":value,"type":type})
 
def trim(num):
    s = '%.2f'%num
    arr = s.split('.')
    length = len(arr)
    l = arr[0]
    if length == 1:
        return l
    else:
        r = arr[1]
        r = re.sub(r'0+$','',r)
        if r == "":
            return l
        else:
            return "%s.%s"%(l,r)
 
def createPropertyModify(nodes):
    def modifyProperty(key,fn):
        needChange = filter(hasProperty('key'),nodes)
        for node in needChange:
            property = node.getAttribute('properties')
            reg = r'%s([\d\.]+)'%key
            node.getAttribute('properties',re.sub(reg,lambda x:'%s%s'%(key,trim(fn(float(x.group(1))))),property))
    return modifyProperty
 
def createAttributeModify(nodes):
    def modifyAttribute(attr,fn):
        for node in nodes:
            number = node.getAttribute(attr)
            if number != "":
                node.setAttribute(attr,fn(number))
    return modifyAttribute
 
def translateByDict(dom,dict):
    locals = dom.childNodes[0]
    hashTable = {}
    for node in locals.childNodes:
        if node.nodeType == 1: #ELEMENT_NODE
            if len(node.childNodes) == 1:
                hashTable[node.tagName] = node.childNodes[0]
            else:
                textNode = dom.createTextNode("")
                node.appendChild(textNode)
                hashTable[node.tagName] = textNode
    #for (k,v) in hashTable.items():
    #    print (k,v.data)
    for pair in dict:
        name = pair[0]
        text = pair[1]
        if name in hashTable:
            node = hashTable[name]
            node.data = text
 
 
def parseSkillTree(string):
    arr = string.split('\n')
    tree = []
    for line in arr:
        groups = []
        row = line.split(';')[:-1]
        groups = map(lambda x:{},row)
        index = 0
        for item in row:
            obj = groups[index]
            if re.match(r'^<',item):
                groups[index-1]["next"] = True
                item = item[1:]
            if re.match(r'>$',item):
                groups[index+1]["prev"] = True
                item = item[:-1]
            skills = item.split(',')
            obj["name"] = skills.pop(0)
            obj["skills"] = skills
            index += 1
        tree.append(groups)
    return tree
 
def stringifySkillTree(array):
    def encodeLine(arr):
        strArr = map(lambda obj:obj["name"]+','+','.join(obj["skills"]),arr)
        for x in range(len(arr)):
            if "next" in arr[x]:
                strArr[x+1] = '<'+strArr[x+1]
            if "prev" in arr[x]:
                strArr[x-1] = strArr[x-1]+'>'
        return ';'.join(strArr)+';'
    return '\n'.join(map(encodeLine,array))
 
class Editor(object):
    def __init__(self):
        self.bak = "main.zip"
        self.use = "main.pak"
        self.cache = {}
        self.modifyRules = [
            [['dirt','sand','stone','coal','iron','silver','gold','mithril','wood','sulfur','leaves','wheat','resin','web','wool'],"chance",[1,35],None],
            [['portal_krs_blue','portal_krs_red','portal_krs_dblue','portal_krs_green','portal_krs_violet','water','brains','root','seed','mucus','quartz','pink_crystal','grey_mushroom','pink_mushroom','needle_crystal','snow','ice','eye'],"chance",[1,15],None],
            #['tesla_tower',"range",[1,50],'dirt'],
            ['money',"chance",[1,5],'dirt'],
            ['money',"chance",[5,1],'dirt'],
            [['root','seed'],"chance",[1,5],'dirt'],
            ['money',"chance",[1,1],'dirt'],
            [['stone','sand'],"chance",[1,5],'dirt'],
            ['sand',"chance",[1,50],'sand'],
            ['dirt',"chance",[1,5],'sand'],
            ['quartz',"chance",[1,5],'sand'],
            [['pink_crystal','needle_crystal','portal_krs_blue','portal_krs_red','portal_krs_dblue','portal_krs_green','portal_krs_violet'],"chance",[1,2],'sand'],
            [['quartz','sand'],"chance",[1,5],'stone'],
            [['dirt','stone'],"chance",[1,15],'coal'],
            ['coal',"chance",[1,75],'coal'],
            ['sulfur',"chance",[1,25],'coal'],
            ['iron',"chance",[1,15],'sulfur'],
            ['stone',"chance",[1,25],'iron'],
            ['iron',"chance",[1,75],'iron'],
            ['silver',"chance",[1,50],'silver'],
            ['gold',"chance",[1,5],'silver'],
            ['mithril',"chance",[1,1],'silver'],
            ['money',"chance",[1,2],'gold'],
            ['silver',"chance",[1,10],'gold'],
            ['mithril',"chance",[1,3],'gold'],
            ['gold',"chance",[1,30],'gold'],
            ['money',"chance",[1,10],'gold'],
            ['silver',"chance",[1,50],'mithril'],
            ['gold',"chance",[1,15],'mithril'],
            ['money',"chance",[1,15],'mithril'],
            ['water',"chance",[1,15],'ice'],
            ['ice',"chance",[1,15],'snow']
        ]
        self.createCache()
         
    def createCache(self):
        if not os.path.exists(self.bak):
            open(self.bak,"wb").write(open(self.use,"rb").read())
        zf = zipfile.ZipFile(self.bak,"r")
        for name in zf.namelist():
            self.cache[name] = zf.read(name)
 
    def readFile(self,name):
        return self.cache[name]
 
    def writeFile(self,filename,data):
        self.cache[filename] = data
 
    def close(self):
        zf = zipfile.ZipFile(self.use,"w")
        for (k,v) in self.cache.items():
            zf.writestr(k,v)
        zf.close()
 
    def editItemXML(self):
        filename = "data/items.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        nodes = dom.getElementsByTagName("item")
        modifyProperty = createPropertyModify(nodes)
        modifyAttribute = createAttributeModify(nodes)
        #修改光线范围
        modifyAttribute("light",lambda x: '%d'%(int(x)*2))
        #修改治愈效果
        modifyProperty('healt=',lambda x:x*2)
        #修改速度
        modifyProperty('speed=',lambda x:int(x*1.5))
        #修改伤害
        modifyProperty('healt=-',lambda x:x*5)
        #修改高度上限
        modifyProperty('max_height=',lambda x:int(x*3))
        #修改魔法消耗
        modifyProperty('use_mana=',lambda x:int(x*0.5))
        #修改效果范围
        modifyProperty('radius=',lambda x:x+1)
        #修改效果时间
        modifyProperty('time=',lambda x:int(x*1.5))
        #修改衰退比例
        modifyProperty('lost=',lambda x:x*1.25)
        self.writeFile(filename,dom.toxml('UTF-8'))
 
    def editCreatureXML(self):
        filename = "data/creatures.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        nodes = dom.getElementsByTagName("creature")
        def setParams(name,object):
            paramsNode = filter(lambda node:node.getAttribute("name")==name,nodes)[0].getElementsByTagName('params')[0]
            def setParam(key,val):
                params = paramsNode.getElementsByTagName(key)
                if len(params) > 0:
                    params[0].setAttribute("value",val)
                else:
                    newParam = dom.createElement(key)
                    newParam.setAttribute("value",val)
                    paramsNode.appendChild(newParam)
            for (k,v) in object.items():
                setParam(k,v)
            return
 
        def setResources(names,rule):
            for node in nodes:
                name = node.getAttribute("name")
                if name in names:
                    paramNode = node.getElementsByTagName('params')[0]
                    resourceNode = paramNode.getElementsByTagName('resources')
                    if len(resourceNode) > 0:
                        node = resourceNode[0]
                        old = node.getAttribute("value")
                        resources = decodeResourceRules(old)
                        modifyRule(resources,rule)
                        mod = encodeResourceRules(resources)
                        if mod != old:
                            node.setAttribute("value",mod)
 
        #修改矮人属性
        setParams('worker',{
            "capacity":"8",
            "attack":"0.6",
            "walk_speed":"150",
            "climbs_speed":"100",
            "climbs_ladder_speed":"120",
            "base_armor": "0.3",
            "water_die_time":"360",
            "shot_time":"1.1"
        })
        setParams('worker_female',{
            "capacity":"8",
            "attack":"0.5",
            "walk_speed":"175",
            "climbs_speed":"120",
            "climbs_ladder_speed":"150",
            "base_armor": "0.25",
            "water_die_time":"360",
            "shot_time":"1.1"
        })
        creatures = map(lambda x:x.getAttribute("name"),nodes)
 
        setResources(creatures,[["fish","egg","wool","skin","web","brains","needle","chitin","fat","meat","rope","eye","thread","cabels","mucus","money","fabric","root","feather","garland","bone"],"chance",[1,100],None])#+100%资源
        setResources(creatures,[["quartz","coal","mithril","gold","silver","iron","grey_mushroom","pink_mushroom","pink_crystal","needle_crystal"],"chance",[1,50],None])#+50%矿物
        setResources(creatures,[['chopper_iron', 'axe_steel', 'silver_axe', 'mithril_axe', 'pick_iron', 'pick_cave_goblin', 'pick_steel', 'pick_silver', 'pick_mithril', 'rusty_sceleton_saber', 'rusty_mummy_saber', 'cave_goblin_saber', 'sword_iron', 'cave_goblin_saber1', 'cave_goblin_saber2', 'sword_silver', 'godeus_sword_th', 'sword_mithril', 'club', 'rusty_sceleton_mace', 'rusty_sceleton_heavy_mace', 'club_iron', 'beatle_poisonous_club', 'club_mithril', 'funny_sceleton_club', 'bow_wooden', 'frostling_bow', 'bow_long', 'elven_bow', 'bow_heavy', 'wooden_staff', 'mstaff', 'mstaff_mithril', 'shaman_staff', 'frostling_spear', 'goblin_spear', 'cave_goblin_spear', 'elven_spear', 'zombie_spear', 'zombie_spear_02', 'knight_sword', 'sword_dao', 'pistol', 'rifle', 'heavy_rifle', 'ammo', 'ammo_steel', 'ammo_fire', 'bow_arrow', 'bow_arrow_fire', 'bow_arrow_poison', 'bow_arrow_silver', 'spawn_cube_zombie_armorbreaker', 'helm_wood', 'helm_leather', 'helm_hitin', 'helm_steel', 'helm_silver', 'helm_elven', 'helm_gold', 'helm_mithril', 'santa_hat', 'rusty_sceleton_helmet', 'jason_mask', 'jason_mask_adv', 'shaman_cloak', 'knight_helmet', 'demon_hunter', 'witch_hat', 'witch2_hat', 'funny_sceleton_helmet', 'angel_nimbus', 'bat_hat', 'demon_horns', 'pirat_hat', 'pumpkin_hat', 'scream_mask', 'dragon_warrior_helmet', 'leather_boots', 'boots_hitin', 'iron_boots', 'silver_boots', 'gold_boots', 'elven_boots', 'mithril_boots', 'knight_boots', 'funny_sceleton_shoes', 'dragon_warrior_boots', 'wood_armor', 'shirt_skin', 'hitin_armor', 'steel_chain_armor', 'silver_armor', 'gold_armor', 'elven_armor', 'mithril_armor', 'santa_armor', 'knight_armor', 'funny_sceleton_cuirass', 'dragon_warrior_cuirass', 'wood_shield', 'iron_shield', 'gold_shield', 'funny_sceleton_shield', 'undead_amulet1', 'undead_amulet2', 'undead_amulet3'],"chance",[1,25],None])#+25%装备
             
        self.writeFile(filename,dom.toxml('UTF-8'))
 
    def editResourceXML(self):
        filename = "data/craft_resources.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        resources = dom.getElementsByTagName("resource")
        modifyProperty = createPropertyModify(resources)
        #修改售价和数目
        for resource in resources:
            cost = resource.getAttribute("shop_cost")
            count = resource.getAttribute("shop_count")
            if cost == "" or count == "":
                continue
            cost = float(cost)
            count = float(count)
            if cost <= 2:
                count = count * 5
            elif count > 1:
                count = count * 2
                cost = math.ceil(cost/2.5)
            else:
                cost = math.ceil(cost/5)
            #print (resource.getAttribute("name"),cost,count)
            resource.setAttribute("shop_count",'%d'%count)
            resource.setAttribute("shop_cost",'%d'%cost)
        #修改制作时间
        modifyProperty('craft_time=x',lambda x:x*0.2)
        #修改速度
        modifyProperty('speed=x',lambda x:x*1.5)
        #修改建造速度
        modifyProperty('build=x',lambda x:math.pow(1.25,x))
        #修改攻击
        modifyProperty('attack=x',lambda x:x*1.5)
        #修改距离
        modifyProperty('distance=',lambda x:x*1.5)
        #修改精度
        modifyProperty('accuracy=',lambda x:x+0.2)
        #修改重量
        modifyProperty('heavy=',lambda x:x*0.5)
        #修改魔法时间
        modifyProperty('time=',lambda x:x*10)
        #修改舒适度
        modifyProperty('comfort=',lambda x:x*2)
        #修改治愈效果
        modifyProperty('healt=',lambda x:x*2)
        #修改饱食效果
        modifyProperty('satiety=',lambda x:x*2)
        #修改减速效果
        modifyProperty('slowdown=',lambda x:x*0.5)
        #修改护甲效果
        modifyProperty('armor=',lambda x:x*1.5)
        #修改背包容量
        modifyProperty('capacity=',lambda x:x*2)
        #修改事件数目
        modifyProperty('ne_event',lambda x:x+1)
        self.writeFile(filename,dom.toxml('UTF-8'))
 
    def editBlockXML(self):
        filename = "data/blocks.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        blocks = dom.getElementsByTagName("block")
        modifyProperty = createPropertyModify(blocks)
        modifyAttribute = createAttributeModify(blocks)
        #修改采集时间
        modifyAttribute("extract",lambda x:'%d'%round(float(x)/2))
        #修改资源数量
        for node in blocks:
            resource = node.getAttribute('resource')
            if resource != "":
                resources = decodeResourceRules(resource)
                for rule in self.modifyRules:
                    modifyRule(resources,rule)
                mod = encodeResourceRules(resources)
                if mod != resource:
                    node.setAttribute('resource',mod)
 
        #修改光强
        modifyProperty('light=',lambda x:x*2)
        #修改治疗效果
        modifyProperty('healt=x',lambda x:x*2)
        #修改效率
        modifyProperty('efficiency=x',lambda x:x*5)
        #修改最大高度
        modifyProperty('max_height=',lambda x:int(x*3))
        #保存
        self.writeFile(filename,dom.toxml('UTF-8'))
        #print string
 
    def editRecipeXML(self,mult=1,news=None):
        filename = "data/recipes.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        nodes = dom.getElementsByTagName("recipe")
        for node in nodes:
            produce = node.getAttribute("produce")
            parsed = produce.split('=')
            if len(parsed) == 2:
                produce = '%s=%d'%(parsed[0],int(parsed[1])*mult)#两倍产率
            else:
                produce = '%s=%d'%(parsed[0],mult)
            node.setAttribute("produce",produce)
        self.writeFile(filename,dom.toxml('UTF-8'))

    def addRecipe(self,config):
        filename = "data/recipes.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        recipes = dom.getElementsByTagName("root")[0]
        def stringify(array):
            if isinstance(array,str):
                return array
            if isinstance(array,list):
                index = 0
                items = []
                for item in array:
                    index += 1
                    if item != None:
                        items.append('%s-%d'%(item,index))
                return ','.join(items)
            if isinstance(array,dict):
                items = []
                for(k,v) in dict.items():
                    if re.match(r'^[1-9]$',k):
                        items.append('%s-%s'%(v,k))
                return ','.join(items)

        recipe = dom.createElement("recipe")
        recipe.setAttribute("name",config["name"])
        recipe.setAttribute("produce",'%s'%config["name"])
        recipe.setAttribute("ingredients",stringify(config["ingredients"]))
        recipe.setAttribute("group",config["group"])
        recipe.setAttribute("craft_need","")
        if "count" in config and config["count"] > 1:
            recipe.setAttribute("produce",'%s=%d'%(config["name"],config["count"]))
        if "require" in config:
            recipe.setAttribute("require", config["require"])
        if "craft_need" in config:
            recipe.setAttribute("craft_need", config["craft_need"])
        recipes.appendChild(recipe)
        self.writeFile(filename,dom.toxml('UTF-8'))
 
    def editWaveXML(self):
        filename = "data/wave.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        ratioNode = dom.getElementsByTagName('ratios')[0]
        table = []
        ratios = ratioNode.childNodes
        length = len(ratios)
        for x in range(length):
            node = ratios[length-x-1]
            if node.nodeType == 1:
                setting = {}
                for pair in node.attributes.items():
                    setting[pair[0]] = pair[1]
                    table.append(setting)
            ratioNode.removeChild(node)
        table.reverse()
 
        def setRatios(table):
            for setting in table:
                ratio = dom.createElement('ratio')
                for (k,v) in setting.items():
                    ratio.setAttribute(k,v)
                    ratioNode.appendChild(ratio)
 
 
        creatures = parseString(self.readFile("data/creatures.xml")).getElementsByTagName("creature")
        beastiary = parseString(self.readFile("data/beastiary.xml")).getElementsByTagName("beast")
        monsters = filter(lambda node:re.match(r'^(very)?danger$',node.getAttribute("hostility")) ,beastiary)
        for monster in monsters:
            name = monster.getAttribute("creature")
            healt = 1
            attack = 1
            params = filter(lambda node:node.getAttribute("name")==name,creatures)[0]
            node = params.getElementsByTagName("healt")
            if len(node) == 1:
                healt = float(node[0].getAttribute("value"))
            node = params.getElementsByTagName("attack")
            if len(node) == 1:
                attack = float(node[0].getAttribute("value"))
            percent = 20/(math.sqrt(healt)*math.pow(1.2,attack-0.4))
            percent = round(percent*10)/10
            count = math.ceil(1/math.log(1.5+attack*healt))
            #print (name,percent,count)
            table.append({"monster":name, "value":trim(percent),"count":'%d'%count})
        setRatios(table)
        self.writeFile(filename,dom.toxml('UTF-8'))
 
    def editWorldXML(self,params={}):
        filename = "data/world.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        nodes = dom.getElementsByTagName("param")
        cache = {}
        for node in nodes:
            cache[node.getAttribute("name")] = node
        def setParams(dict):
            for (k,v) in dict.items():
                if cache[k] != None:
                    cache[k].setAttribute("value",v)
        setParams(params)
        self.writeFile(filename,dom.toxml('UTF-8'))
 
    def editSkillTree(self):
        filename = "data/default_techtree.csv"
        string = self.readFile(filename)
        tree = parseSkillTree(string)
 
    def translateLocalXML(self):
        filename = "Lang/Chinese/data/local.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        tranDict = [
            ('UndergroudPlanet', u'地下世界'),
            ('NotYet', u'尚未。'),
            ('MsgTooDeep', u'不能在水面下挖掘！'),
            ('SizeLarge', u'大型'),
            ('ZombiesCantSpawn', u'僵尸找不到刷新位置。'),
            ('GoHome', u'回家'),
            ('WarGame', u'找到对手 %1，正在传送至群落…'),
            ('hlumbering', u'伐木'),
            ('RateLater', u'Maybe later'),
            ('SpeechNoFood', u'哪里有食物？我饿死了！'),
            ('hcomfort', u'舒适值'),
            ('SpellAlreadyAvailable', u'魔法已解锁。'),
            ('Smithy', u'熔炉'),
            ('MRemoveConstruction', u'拆除建筑'),
            ('MReplaceBack', u'更换后部 %1'),
            ('MBuild', u'建造 %1'),
            ('PetHouseHint', u'人口：%1/%2，新来 %3'),
            ('NeedKitchen', u'需要厨房'),
            ('ComfortNone', u'不'),
            ('BiomPlanet', u'群落'),
            ('hdurability', u'耐久值'),
            ('tmp_disconnected', u'玩家%1已断开连接。'),
            ('Training', u'训练中'),
            ('SpeechNoHouse', u'我们的房子在哪里？'),
            ('NoTreePlace', u'位置不足！请找个空地更多的地方。'),
            ('CraftAndBuildItem', u'根据科技树的进度来制作并安置物品'),
            ('YouDefeat', u'战败了！正在回营…'),
            ('AttackEnemy', u'攻击敌人'),
            ('MaxImps', u'小精灵人数达到上限！'),
            ('GoStore', u'去仓库'),
            ('DwarfsSoFew', u'矮人人数不足，不能玩多人游戏（需要 %1 个矮人）'),
            ('MReplace', u'更换 %1'),
            ('RateTitle', u'如果你喜欢这个游戏，请给它五星级的评分！'),
            ('MRemoveBack', u'拆除后部 %1'),
            ('ComfortGood', u'良好'),
            ('HumLow', u'稀有'),
            ('MTrainingWorker', u'训练'),
            ('MEnterShop', u'进入商店'),
            ('SizeSmall', u'小型'),
            ('PositionDefined', u'%1 位置已定义'),
            ('CraftAndEquipItemTitle', u'装备 %1'),
            ('NoFarmSpace', u'捕获             (农场空间不够)'),
            ('MReplaceFront', u'更换前部 %1'),
            ('NormalModeEnabled', u'允许矮人离开庇护所'),
            ('TooFar', u'离探索地区太远。'),
            ('NeedMillstone', u'需要磨石'),
            ('MExtinguishFire', u'扑灭'),
            ('TempHot', u'热'),
            ('Compaign', u'战役'),
            ('TopoHills', u'丘陵'),
            ('InviteFriend', u'邀请好友'),
            ('Nightmare', u'噩梦'),
            ('UpgradeNeed', u'需要主传送门改良'),
            ('SpeechNoDivingHelm', u'没有潜水帽'),
            ('FTPCraft', u'Скамейка для крафта'),
            ('Waiting', u'等待'),
            ('Easy', u'简单'),
            ('AlreadyToCut', u'已剪'),
            ('MToFree', u'释放'),
            ('MConstruction', u'建筑'),
            ('TopoPlain', u'平原'),
            ('UseMagicItem', u'根据科技树的进度来制作魔法'),
            ('server_kick', u'你已被从服务器踢开！'),
            ('CustomSlot', u'%1. 自定义 [%2:%3]'),
            ('RateOk', u'Ok!'),
            ('MsgBuildBedOutHouse', u'矮人只能睡在庇护所的床上'),
            ('Digs', u'挖掘'),
            ('TechSandbox', u'沙盒'),
            ('TempCold', u'冷'),
            ('BlackFlaffiesLeft', u'剩余 %1 只黑色毛球怪'),
            ('ZombiesLeft', u'剩余 %1 只僵尸'),
            ('Millstone', u'磨坊'),
            ('ReturnToHome', u'回营'),
            ('Kitchen', u'厨房'),
            ('NeedSmithy', u'需要熔炉'),
            ('PortalNotFoundYet', u'尚未找到传送门'),
            ('HumNormal', u'平均'),
            ('SpeechNoTable', u'我们需要一张餐桌。'),
            ('MUse', u'使用'),
            ('MsgBuildUnableHere', u'不能在这建造 %1'),
            ('OpenedTechTree', u'全部可用'),
            ('ComfortMod', u'一般'),
            ('TotemHint', u'舒适值 %1'),
            ('ComfortPoor', u'不好'),
            ('GoResources', u'到仓库提取资源'),
            ('MBuildBlocks', u'建造方块'),
            ('MCatch', u'捕获'),
            ('SpeechNoTool', u'我需要合适的工具'),
            ('ZombiesSpawned', u'刷新了 %1 个僵尸'),
            ('hdamage', u'伤害值'),
            ('MsgBuildBackWallOnly', u'这个物品只能挂在后壁上'),
            ('MsgBuildNoResources', u'仓库内资源不足。'),
            ('Hard', u'困难'),
            ('TempNormal', u'正常'),
            ('Totem', u'图腾'),
            ('CraftFoodTitle', u'打造 %1'),
            ('RateNo', u'Never'),
            ('GamePermanentDeath', u'永久死亡'),
            ('CantFindPosition', u'%1 找不到刷新位置'),
            ('NoMagicPyramide', u'金字塔的能量遏制了你的魔法！'),
            ('LadderDesc', u'梯子能提高运动速度，且防止坠落。'),
            ('Disconnect', u'正在退出多人环节…'),
            ('CraftItem', u'根据科技树的进度来制作物品'),
            ('ExploreTechnology', u'完成这种技术的学习你必须制作物品。'),
            ('TechTree', u'科技树'),
            ('AddPlayer', u'%1 加入游戏'),
            ('DoEscape', u'逃跑'),
            ('Level2Name', u'干旱风大陆'),
            ('CollectResources', u'搜集资源'),
            ('VeryHard', u'非常困难'),
            ('server_pass_incorrect', u'无效密码！'),
            ('Empty', u'空的'),
            ('MReplaceFrontBlocks', u'更换前部方块'),
            ('NotReadyCollect', u'搜集准备不充分'),
            ('CraftAndEquipItem', u'根据科技树的进度来打造装备并武装你的矮人'),
            ('Normal', u'正常'),
            ('MKill', u'屠宰'),
            ('CalculatePath', u'寻找路径'),
            ('HintWeapon', u'在这放置武器。'),
            ('WaitingElevator', u'等待升降机'),
            ('CraftItemTitle', u'打造 %1'),
            ('DoBuild', u'建筑'),
            ('ClaimSend', u'投诉已经发出。'),
            ('HumHigh', u'频繁'),
            ('FriendGame', u'找到盟友 %1，正在传送至群落…'),
            ('NewTreeRemains', u'新的树木生成还需要 %1 秒'),
            ('TechCraftTree', u'秘笈树'),
            ('Level1Name', u'新希望大陆'),
            ('DesertPlanet', u'沙漠'),
            ('SpeechNoBed', u'我的床在哪儿？'),
            ('VeryEasy', u'非常简单'),
            ('SpeechNoEmpyTreiningDevice', u'全部在使用中'),
            ('NeedWorkshop', u'需要作坊'),
            ('MGatherWater', u'取水'),
            ('NoMagic', u'魔法能量遏制了你的咒语！'),
            ('DwarfsSoFew2', u'矮人数量不足以进入异界（需要总数的1%）'),
            ('SpeechPathNotFound', u'我不知道如何过去'),
            ('MSelectWorker', u'选择矮人'),
            ('CraftFood', u'根据科技树的进度制作食物'),
            ('server_full', u'连接错误，服务器已满。'),
            ('Workbench', u'工作台'),
            ('MDig', u'挖掘'),
            ('SpeechNoValidHouse', u'庇护所的边界受到了侵犯'),
            ('ComfortAvg', u'平均'),
            ('SiegeModeEnabled', u'矮人不准离开庇护所'),
            ('NoFishTackle', u'仓库没有钓鱼竿'),
            ('ComfortEx', u'优秀'),
            ('BeetlesPlanet', u'甲虫生活的群落'),
            ('MToCut', u'收割'),
            ('LockedByLevel', u'将在 %1 级开放'),
            ('Workshop', u'作坊'),
            ('DoWorking', u'挖掘'),
            ('NoMana', u'魔法值不足以施放这个魔法！'),
            ('RateText', u'您的评论将有助于我们改进游戏并加快更新。谢谢！'),
            ('NeedLab', u'需要实验室'),
            ('server_lost', u'已从服务器断开连接。'),
            ('GrowthTreeRemains', u'树木生长还需要：: %1 秒'),
            ('Level4Name', u'危险洞穴大陆'),
            ('server_ban', u'连接错误！你在此服务器上已被禁！'),
            ('Custom', u'自定义'),
            ('DoorDesc', u'完成一所房子需要木门，它能阻止怪物进入。'),
            ('MRemove', u'拆除 %1'),
            ('CantDo', u'无法完成'),
            ('GoSleep', u'睡觉'),
            ('SingleBiom', u'进入没有对手的群落…'),
            ('CompaignSlot', u'%1. 战役 [%2:%3]'),
            ('tmp_connected', u'玩家%1已加入。'),
            ('MFishing', u'钓鱼'),
            ('Lab', u'实验室'),
            ('NeedWorkbench', u'需要工作台'),
            ('SizeMedium', u'中型'),
            ('NoToCutTool', u'没有剪刀'),
            ('MCut', u'砍伐'),
            ('Lifting', u'在升降机内'),
            ('MediumPlanet', u'森林世界'),
            ('LevelPortalHint', u'传送门：%2 的部件中已经收集了 %1 件'),
            ('TopoMountain', u'山脉'),
            ('OpponentDeath', u'对手已被打败！'),
            ('harmor', u'盔甲'),
            ('SpeechNoBattleSkill', u'没有战斗技能'),
            ('SpeechICantEat', u'%1？！这个我再也吃不下了！'),
            ('UnableDisassemble', u'该物品无法拆开'),
            ('HintTool2', u'放置伐木工具。'),
            ('GameNormal', u'正常'),
            ('MRemoveFront', u'拆除前部 %1'),
            ('HintTool1', u'放置挖掘工具。'),
            ('hfeeding', u'喂养'),
            ('WindowDesc', u'提高房屋舒适值。'),
            ('SpeechNoCompatibleWeapon', u'没有合适的武器'),
            ('MReplaceBackBlocks', u'更换后部方块'),
            ('hmining', u'采矿'),
            ('YouWin', u'胜利了！正在回营…'),
            ('SpeechNoTrainingPlace', u'没有地方训练！'),
            ('LockedByOtherTech', u'学习完前面的科技后开放'),
            ('CraftAndBuildItemTitle', u'建造 %1'),
            ('ExploreTechnologyTitle', u'新技术：%1'),
            ('UseMagicItemTitle', u'铸造 %1'),
            ('DoNothing', u'什么都不做'),
            ('Sleep', u'熟睡'),
            ('Fishing', u'钓鱼'),
            ('IcePlanet', u'冰封世界'),
            ('NeedToBuildDevice', u'要制作这个物品，你需要建造一个 %1。'),
            ('Level3Name', u'冬季天堂大陆')
        ]
        translateByDict(dom,tranDict)
        self.writeFile(filename,dom.toxml('UTF-8'))
 
    def translateResourceXML(self):
        filename = "Lang/Chinese/data/local/craft_resources.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        tranDict = [
            ('PumpkinD', u'两眼炯炯有神的南瓜不祥地出现在万圣节前夕。您可以把它们当作灯光。'),
            ('SteeldoorT', u'钢门'),
            ('ReddiamondD', u'用于制造魔法物品和装备的宝石。'),
            ('TriggerMechT', u'扳机机构'),
            ('ACH_GREAT_DONATOR', u'三角旗主要供应商'),
            ('MushDryD', u'你可以把采摘的蘑菇晒干食用。'),
            ('MushSoupD', u'一种美味的蘑菇汤。'),
            ('LeatherskinT', u'皮革'),
            ('Block5portalT', u'第五个传送门部件'),
            ('PumpkinT', u'南瓜'),
            ('SteeldoorD', u'所有材质当中最坚固的门。'),
            ('ReddiamondT', u'红水晶'),
            ('MushSoupT', u'蘑菇汤'),
            ('WarriorTrainingSimpleT', u'训练假人'),
            ('StonecollumnT', u'黑柱'),
            ('ElvenArmorT', u'精灵盔甲'),
            ('MixedgreenssaladD', u'如果食物选择有限，但所有人都饿了，你可以用新鲜绿色蔬菜烹制一种简单的沙拉。'),
            ('CoinT', u'金币'),
            ('BasiliskHouseT', u'青蛙人之屋'),
            ('ElvenArmorD', u'寒冰群落精灵的盔甲。'),
            ('SilverAxeT', u'银斧'),
            ('MixedgreenssaladT', u'混合绿色沙拉'),
            ('CoinD', u'有时候你会捡到金币，用来在矮人商店购买稀少的必需物品。'),
            ('SilverSwordD', u'银剑比铁剑坚韧，伤害值也更高。'),
            ('BasiliskHouseD', u'这种房屋让你可以训练宠物，从而帮助矮人保卫他们的家园。'),
            ('DemonHunterT', u'恶魔猎人帽'),
            ('SandD', u'砂子用于建筑和制作玻璃。不过小心点，别让你的矮人陷入松软的砂堆给活活埋了。'),
            ('StoneT', u'石头'),
            ('StainedglasswithsplashesT', u'彩色镶嵌玻璃'),
            ('Block1portalT', u'第一个传送门部件'),
            ('SandT', u'砂子'),
            ('BarrelD', u'圆桶用来酿造和储存烈酒。'),
            ('StainedglasswithsplashesD', u'墙壁装饰物品。'),
            ('CabelsT', u'铁丝'),
            ('Block1portalD', u'用于建造世界之间传送门的部件。'),
            ('LuxurybedD', u'国王的床！不单单是睡觉的地方，还是照亮整个房屋的装饰品。'),
            ('BreadD', u'面包是用小麦做成的主食。'),
            ('LuxurybedT', u'龙床'),
            ('SpawnCubeSkeletonT', u'骷髅重生者'),
            ('SpawnCubeGargoylyT', u'石像鬼重生者'),
            ('BeatlePoisonousClubT', u'毒刺棒'),
            ('BreadT', u'面包'),
            ('DecorativemirrorT', u'装饰性镜子'),
            ('CookSkillT', u'烹饪手册'),
            ('IronhatchD', u'强化金属外门。'),
            ('SimplehatD', u'普通帽子可以遮阳挡雨，但是不能抵挡对头部的打击。'),
            ('LeatherbootsT', u'皮靴'),
            ('DecorativemirrorD', u'一面精致的带框镜子。用于室内装饰。'),
            ('WinterbootsD', u'不大好看的毡靴，不过比没有强。'),
            ('Backpack1T', u'背包'),
            ('CookSkillD', u'第 13 版进行了修订和扩充。此外，老版本里面错误的毒蘑菇和浆果已经删除。'),
            ('IronhatchT', u'铁制外门'),
            ('CatapultTowerT', u'机械化弩炮'),
            ('SilverSwordT', u'银剑'),
            ('FlashlightT', u'节日灯笼'),
            ('IcewallD', u'可在冬天临时搭建的墙壁。'),
            ('GobllinspearT', u'妖精之矛'),
            ('ElvenFlagT', u'精灵旗'),
            ('RailsD', u'你现在可以建一条铁路了。在两排积木上放上铁轨，然后再放上一个以上的货车车厢。'),
            ('MithrilD', u'这种无比坚固的稀有金属用于制造最好的武器和装备。'),
            ('WoodenbowT', u'木箭'),
            ('JasonMaskT', u'魔杰森的面具'),
            ('MushroomD', u'一种新的原料，可用来烹饪各种菜肴。'),
            ('RoundwindowT', u'圆窗'),
            ('DragonEggT', u'龙蛋'),
            ('GobllinspearD', u'短矛。'),
            ('ElvenFlagD', u'寒冰群落精灵的装饰物。'),
            ('RailsT', u'铁轨'),
            ('MithrilT', u'秘银矿'),
            ('WoodenbowD', u'木箭是最简单的远程武器。普通的木箭要多少有多少。'),
            ('JasonMaskD', u'这个面具甚至可以吓跑怪物。'),
            ('ChristmasWreathT', u'一个圣诞花环。'),
            ('RoundwindowD', u'小圆窗'),
            ('DragonEggD', u'一种极为稀少且难以得到的炼金原料。'),
            ('WoodenhatchT', u'木制外门'),
            ('LeathershirtD', u'比布衫更耐用，提供额外的保护。'),
            ('WebD', u'炼金药剂的一种原料。'),
            ('PinkMushroomD', u'炼金药剂的一种原料。'),
            ('HealthElixirT', u'生命药剂'),
            ('BoardsD', u'处理过的木材是上好的建材，广泛用于制作家具和其他装备。'),
            ('FeatherT', u'羽毛'),
            ('WoodenhatchD', u'木制外门是限制房屋入口通道最简单的方法。你可以打开和关闭一些外门来阻塞某些矮人使用的路径。'),
            ('LeathershirtT', u'皮制盔甲'),
            ('AxeSteelD', u'伐树的利器，也可以用作武器。'),
            ('WebT', u'网'),
            ('PinkMushroomT', u'粉蘑菇'),
            ('ACH_FINISH_FIRST_LEVEL', u'主权三角旗'),
            ('BoardsT', u'木板'),
            ('FeatherD', u'鸟类羽毛可用于制作箭矢。'),
            ('RustyskeletonsaberT', u'骷髅的佩剑'),
            ('ResinD', u'从松树提取的树脂用于制作各种灯。'),
            ('RustyskeletonsaberD', u'一把锈迹斑斑的古剑。'),
            ('ResinT', u'树脂'),
            ('WinterbootsT', u'冬靴'),
            ('GarlandT', u'花环'),
            ('KnightSwordT', u'黑暗领主之剑'),
            ('RustyskeletonmaceD', u'骷髅们不爱惜自己的武器，所以这支权杖已是锈迹斑斑。'),
            ('SantaHatD', u'圣诞老人的魔法帽。'),
            ('SilverarrowD', u'银箭是精灵族知识的产物，在战斗中非常有效。'),
            ('IronbootsT', u'铁靴'),
            ('SpawnCubeZombieArmorBreakerT', u'僵尸裂甲者重生者'),
            ('CripCatHouseT', u'老友之屋'),
            ('SantaHatT', u'圣诞老人的帽子'),
            ('EyeT', u'眼睛'),
            ('LeatherhelmetT', u'皮制头盔'),
            ('GargoyleySpawnerT', u'石化石像鬼'),
            ('EyeD', u'死亡怪物的眼睛。用于制作魔法药剂。'),
            ('HealthElixirD', u'在装备面板使用这种药剂治愈选定的矮人。'),
            ('LeatherchairT', u'皮椅'),
            ('LeatherhelmetD', u'一种简单的头盔，你可以用来在战斗中保护头部。'),
            ('GargoyleySpawnerD', u'石像鬼是暗夜生物，无法接受阳光，在阳光下，它们会变成石头。'),
            ('AxeSteelT', u'钢斧'),
            ('LeatherchairD', u'舒适的皮椅。'),
            ('HeavybowD', u'一种用于远程战斗的机械弓。一次可射三根箭矢。'),
            ('ConeT', u'球果'),
            ('StatueD', u'这座雕像是矮人族一个传奇英雄，是矿工的守护神。根据传说，他的灵魂仍然在废弃矿山游荡，帮助迷路的矮人找到回家的路。给所有矿工加持5点技能加成。'),
            ('SkillsRindT', u'技能戒指'),
            ('LockD', u'门或箱子的五金件。'),
            ('WoodenstaffT', u'木杖'),
            ('WoodenstepsT', u'Wooden Steps'),
            ('TransformelexirT', u'变形药剂'),
            ('SteelD', u'钢用于锻造坚固的武器和门。'),
            ('ACH_GREAT_EXPLORER', u'大探索者三角旗'),
            ('WallskinrugT', u'毛皮壁毯'),
            ('HeavybowT', u'重型弓'),
            ('ConeD', u'伐树矮人一发现球果和苹果就可以吃。'),
            ('RifleD', u'一种中等威力的枪支。'),
            ('LockT', u'锁'),
            ('WoodenstaffD', u'简单的法杖。'),
            ('WoodenstepsD', u'Although dwarves are good jumpers and climbers, they will be very happy if they could use steps.'),
            ('SteelT', u'钢'),
            ('WorkbenchT', u'工作台'),
            ('SwimmerSkillT', u'游泳手册'),
            ('StonechairD', u'地下树木用完了，所以有时候你得用石头来建造家具。'),
            ('FisherSkillD', u'提高钓鱼速度。'),
            ('BedD', u'矮人恢复体力的好地方。'),
            ('SilverarrowT', u'银箭'),
            ('SimplearrowT', u'普通箭矢'),
            ('SwimmerSkillD', u'提高你在水下屏气的时间。'),
            ('StonechairT', u'石椅'),
            ('FisherSkillT', u'钓鱼手册'),
            ('BedT', u'木床'),
            ('ACH_GIANT_WORM_KILER', u'蠕虫猎人三角旗'),
            ('SimplehatT', u'普通帽子'),
            ('SimplearrowD', u'伤害值低的简单箭矢。这样的箭矢矮人要多少有多少。其他厉害的箭矢用完了就用它们。'),
            ('RoofofleavesT', u'树叶屋顶'),
            ('MushSalatD', u'一种简单的沙拉，放有新鲜蔬菜和蘑菇。'),
            ('StoneloopholeT', u'石墙箭眼'),
            ('StonebridgeT', u'石桥'),
            ('CarpenterSkillD', u'提高木制物品制作速度。'),
            ('BookshelfT', u'书架'),
            ('RoofofleavesD', u'最简单的屋顶，用树叶做成的，可以为你遮蔽雨雪冰雹。'),
            ('MushSalatT', u'蘑菇沙拉'),
            ('FunnySceletonShoesT', u'趣怪骷髅鞋'),
            ('StoneloopholeD', u'城墙上的这种附加设备让矮人可以在墙后面进行攻击。'),
            ('StonebridgeD', u'一种耐用的石桥，做工简单。'),
            ('KnightArmorT', u'黑暗领主胸甲'),
            ('CarpenterSkillT', u'木匠手册'),
            ('GoldIngotT', u'金锭'),
            ('Block4portalT', u'第四个传送门部件'),
            ('BookshelfD', u'一件室内家具。'),
            ('WoodWallSetT', u'木制墙壁嵌板'),
            ('IronT', u'铁矿'),
            ('FrostlingspearD', u'短矛。'),
            ('EliteWallSetT', u'豪华墙壁嵌板'),
            ('BarrelT', u'圆桶'),
            ('StonestoveT', u'厨房石灶'),
            ('TinkersHatT', u'修补匠的帽子'),
            ('NailD', u'没有钉子任何复杂的木制建筑实际上都不可能完成。'),
            ('ScreamMaskT', u'尖叫面具'),
            ('IronD', u'用于制造武器、盔甲以及其他坚固物品的主要金属。'),
            ('FrostlingspearT', u'冰霜人之矛'),
            ('StonestoveD', u'普通石灶'),
            ('TinkersHatD', u'简陋的衣服，所有矮人一生下来就穿。'),
            ('BrickfenceD', u'减缓敌人前进速度的栅栏。'),
            ('WinebarrelT', u'酒桶'),
            ('HitinHelmetD', u'用甲壳质护层加固的头盔，它看上去不是很美观，但却使头盔更坚固。'),
            ('LightingstandT', u'灯座架'),
            ('BrickfenceT', u'砖块围墙'),
            ('HamD', u'肉可以通过猎杀野生动物获得。不过矮人不吃生肉，所以得煮熟。'),
            ('HunterSkillD', u'学会如何捕获食物当晚餐而不是成为别人的晚餐！学习它，提高狩猎效率。'),
            ('LightingstandD', u'装饰性灯笼。'),
            ('GrainT', u'麦粒'),
            ('FlagD', u'装饰性物品。也用来建造额外的仓库。 '),
            ('SoulKeepT', u'灵魂袋'),
            ('SieveT', u'筛网'),
            ('ClimbingCatsT', u'攀岩鞋'),
            ('MushDryT', u'干蘑菇'),
            ('GrainD', u'麦粒是从成熟的麦穗中提取而得。它可以加工成面粉或用来种植。'),
            ('FlagT', u'旗帜'),
            ('SoulKeepD', u'用于存放已故矮人的灵魂以备他们可能复活。'),
            ('SieveD', u'提高碾磨技能效率。'),
            ('KnightArmorD', u'多么棒的胸甲！希望坟墓的气息可以在某个时点排出来。'),
            ('ClimbingCatsD', u'提高攀岩技能效率。'),
            ('HitinArmorD', u'用甲壳质护层加固皮盔甲会怎样呢？盔甲会变得不太舒服但很结实。'),
            ('BiomePortalSingleT', u'打开进入异界的大门'),
            ('SteelwallT', u'钢墙'),
            ('SteeltrapT', u'铁夹'),
            ('CampfirewithpotD', u'用于烹饪热食的最简单工具。'),
            ('FountainT', u'喷泉'),
            ('ACH_GIFTED_RESEARCHER', u'三角旗军事研究员'),
            ('StoneD', u'一种常见的耐用建材。'),
            ('PlantinapotT', u'盆栽花'),
            ('PitcherD', u'一种存储液体的容器。'),
            ('IcespikesT', u'冰锥'),
            ('WarehouseT', u'仓库'),
            ('HitinArmorT', u'甲壳质盔甲'),
            ('BiomePortalSingleD', u'派矮人远征队去异界'),
            ('SteelwallD', u'矮人炼冶厂的坚固耐久的墙壁。'),
            ('SteeltrapD', u'取代普通的木夹。可以对动物和怪物造成更大的伤害。'),
            ('CampfirewithpotT', u'烹饪篝火'),
            ('FountainD', u'室外装饰性景点。'),
            ('PitcherT', u'大水罐'),
            ('IcespikesD', u'冰锥减缓怪物的进攻速度并对它们造成伤害。'),
            ('WitchHatD', u'适合可爱的女士们。提高佩戴者对魔法的掌握。'),
            ('CoconutD', u'椰子汁和果肉是恢复体力的好办法。'),
            ('WoodentableD', u'简单的桌子，放置矮人的食物。'),
            ('MageSkillT', u'法师手册'),
            ('DragonWarriorBootsT', u'龙战士靴子'),
            ('BedMultistoreyD', u'这些床可以堆叠，最多 4 层。'),
            ('RopeT', u'绳索'),
            ('Bed2T', u'舒适的床'),
            ('Woodtower2T', u'重型射击塔'),
            ('WitchHatT', u'美丽女巫帽'),
            ('CoconutT', u'椰子'),
            ('TriggerMechD', u'枪支的一部分。'),
            ('MageSkillD', u'教你如何将苍蝇变成大象。还有其他魔法。'),
            ('HunterSkillT', u'狩猎手册'),
            ('RopeD', u'绳索主要用于制造武器和工具。'),
            ('Bed2D', u'一张舒适的床，适合好好睡一宿。'),
            ('Woodtower2D', u'这个包覆着金属的射击塔会给怪物带来更多的麻烦。'),
            ('ElvenbowT', u'精灵弓'),
            ('DragonWarriorHelmetD', u'此头盔可提供良好的保护，并以其精美的工艺让敌人震惊。'),
            ('ShieldwithskullT', u'骷髅盾'),
            ('OrdinaryshirtT', u'普通衬衫'),
            ('MigicexplosionT', u'魔法爆炸'),
            ('SnowT', u'雪'),
            ('ElvenShieldD', u'寒冰群落精灵的盾牌。'),
            ('BedofleavesD', u'这种床不大舒适，不过做工简单。'),
            ('ElvenbowD', u'寒冰群落精灵的弓。'),
            ('RevivalElixirD', u'用于使已故矮人复活，可在物品栏页面把它用在灵魂身上。'),
            ('MigicexplosionD', u'摧毁附近的方块面积，对生物造成巨大伤害值。'),
            ('DragonWarriorHelmetT', u'龙战士头盔'),
            ('BedofleavesT', u'枯叶床'),
            ('CastthelightD', u'这种光可以短时间内照亮选定区域。'),
            ('EnchantedBerriesD', u'祖先的魔法可以创造奇迹！这些浆果不仅能充饥 — 还能使人恢复健康！'),
            ('WoodArmorD', u'最简单的盔甲，用废料做成。'),
            ('IronShieldItemT', u'钢铁盾牌'),
            ('PaintT', u'染料'),
            ('ZombiecageironT', u'铁笼'),
            ('SwordDaoD', u'一把会造成重创的重剑。'),
            ('CastthelightT', u'魔法之光'),
            ('AmmoFireT', u'燃烧弹'),
            ('EnchantedBerriesT', u'施了魔法的浆果'),
            ('WoodArmorT', u'木制盔甲'),
            ('PaintD', u'染料用于染各种面料。'),
            ('ZombiecageironD', u'一种非常结实的金属笼，可以装多个怪物，让它们上天无路，下地无门。'),
            ('ElvenbootsT', u'精灵靴'),
            ('ThreadD', u'线用于缝制面料产品。'),
            ('WoodentableT', u'木桌'),
            ('CabinetwithglassdoorsD', u'带有玻璃门的雕刻橱柜。'),
            ('BeatlePoisonousClubD', u'棒的外面包着甲虫的毒刺'),
            ('GingerbreadCookiesD', u'节日美食。'),
            ('BrainInJarD', u'节日装饰品的良好选择！'),
            ('HamT', u'肉'),
            ('SilverHelmetT', u'银头盔'),
            ('ElvenbootsD', u'寒冰群落精灵的靴子。'),
            ('ThreadT', u'线'),
            ('CabinetwithglassdoorsT', u'玻璃橱柜'),
            ('GingerbreadCookiesT', u'姜饼人'),
            ('BrainInJarT', u'罐装脑子'),
            ('OilD', u'从油桶汲取的油可用于燃烧来释放非常明亮的光。'),
            ('VenetianstuccoD', u'威尼斯灰泥，用于墙壁粉刷。'),
            ('EarthT', u'泥土'),
            ('MithrilHammerT', u'秘银锤'),
            ('MillT', u'磨坊'),
            ('WarehouseUpgradeD', u'使用特别咒语可以打开生物群落传送门和多人游戏传送门。'),
            ('WoodHelmetD', u'最简单的头盔，用废料做成。'),
            ('OilT', u'油'),
            ('VenetianstuccoT', u'威尼斯灰泥'),
            ('EarthD', u'如果手上没有建筑材料了，你可以使用土块建造墙壁和防护设施。'),
            ('MillD', u'磨石可将麦粒磨成面粉。'),
            ('WarehouseUpgradeT', u'改良传送门'),
            ('WoodHelmetT', u'木制头盔'),
            ('Backpack2T', u'结实的背包'),
            ('PistolT', u'手枪'),
            ('ZombiebrainT', u'僵尸脑袋'),
            ('LadderD', u'扶梯加快矮人的移动速度，防止他们从高空掉落。'),
            ('FlowerbedD', u'房子旁边的装饰性花朵。'),
            ('WoodenchairT', u'木椅'),
            ('AnimalTrapD', u'在动物的栖息地放置夹子，捕捉动物。'),
            ('HoneyT', u'Honey'),
            ('AmmoD', u'这种弹药威力小但数量不限。'),
            ('GarlandD', u'居家圣诞节装饰。'),
            ('PistolD', u'这种枪支近距离时非常有效，但火力不足。'),
            ('ZombiebrainD', u'受感染的僵尸脑袋是炼制炼金药水的好材料。'),
            ('LadderT', u'扶梯'),
            ('FlowerbedT', u'花床'),
            ('WoodenchairD', u'用于餐厅的普通椅子。'),
            ('AnimalTrapT', u'夹子'),
            ('AmmoT', u'普通弹药'),
            ('GoldD', u'一种珍贵金属，用于制造华丽的武器和门。'),
            ('MithrilArmorT', u'秘银盔甲'),
            ('FirearrowD', u'火焰箭造成大量伤害。要使矮人使用火焰箭代替普通箭矢，请在“装备”面板选中它们。'),
            ('WinebarrelD', u'装满陈年佳酿的圆桶让矮人兴奋不已。'),
            ('BedMultistoreyT', u'多层床'),
            ('GoldT', u'金矿'),
            ('MithrilArmorD', u'用这种最珍贵金属制造的奢华装备。'),
            ('FirearrowT', u'火焰箭'),
            ('GoldIngotD', u'一大块金属，准备用来加工制作物品。'),
            ('GargoylestatueD', u'用于装饰大门和城墙。'),
            ('SpawnCubeZombieT', u'僵尸重生者'),
            ('BewareD', u'安置一张标示牌，让你的矮人不要太靠近。比如，要是某个区域到处都是矮人难以对付的怪物，你可能就得这么做。'),
            ('FloatD', u'提高游泳技能效率。'),
            ('NeedlecrystalD', u'水晶是特定条件都满足的情况下地下可能形成的产物。'),
            ('CasttheportalD', u'开通一个通往仓库的传送门。矮人可以用它前往仓库或从仓库回来。'),
            ('FarmFenceT', u'农场栅栏'),
            ('CaveGobllinspearT', u'洞穴妖精矛'),
            ('UndeadAmuletT', u'僵尸戒指'),
            ('ZombiespearT', u'黑暗领主仆人的戟'),
            ('GargoylestatueT', u'石像鬼雕像'),
            ('RoundstainedglassD', u'圆形彩色玻璃窗'),
            ('BewareT', u'注意标示牌'),
            ('FloatT', u'漂浮'),
            ('NeedlecrystalT', u'针状水晶'),
            ('CasttheportalT', u'传送魔法'),
            ('FarmFenceD', u'安放一个个栅栏，直到出现一间农舍。'),
            ('CaveGobllinspearD', u'一种简单却很有效的投掷武器，能制作出更好的武器之前，用它很方便。'),
            ('ZombiespearD', u'一种简单又可靠的近战武器。'),
            ('ArcherGloveD', u'提高弓箭手技能效率。'),
            ('ShingledroofT', u'木瓦屋顶'),
            ('ArcherTrainingSimpleT', u'靶子'),
            ('HitinHelmetT', u'甲壳质头盔'),
            ('BunD', u'一种可口的小圆面包，做工简单。'),
            ('FTPCraftT', u'Workbench'),
            ('IronswordT', u'铁剑'),
            ('ElixiroffireballT', u'喷火药剂'),
            ('ArcherGloveT', u'弓箭手手套'),
            ('ShingledroofD', u'木瓦屋顶是用来装饰房屋的完美材料。'),
            ('ArcherTrainingSimpleD', u'弓箭手可以在这里提高他们的精确度。'),
            ('ACH_IMMORTAL', u'无敌三角旗'),
            ('BunT', u'包子'),
            ('SpireT', u'螺塔'),
            ('IronswordD', u'铁剑是基本的近身武器。它还可以让你猎杀危险动物。'),
            ('ElixiroffireballD', u'向矮人法师提供这种药剂，这样他们就可以用魔法杖施放火球。'),
            ('FunnySceletonShieldT', u'趣怪骷髅盾'),
            ('BiomePortalPvpD', u'可打开多人游戏群落传送门。'),
            ('LanternD', u'一种强光，用于照亮庇护所周围，并及时察觉任何逼近的危险。'),
            ('ElvenspearD', u'寒冰群落精灵的主要武器。'),
            ('WheatearsT', u'小麦'),
            ('SpawnCubeArcherT', u'骷髅射手重生者'),
            ('TablewithatableclothD', u'铺有桌布的精致桌子。'),
            ('FunnySceletonShieldD', u'用骨头制作的结实盾牌。'),
            ('BiomePortalPvpT', u'多人游戏'),
            ('LanternT', u'灯笼'),
            ('WheatearsD', u'可以种小麦生产麦粒。小麦需要定期浇水才能生长。'),
            ('IcewallT', u'冰墙'),
            ('TablewithatableclothT', u'铺桌布的桌子'),
            ('DivinghelmetD', u'使矮人能够不限时间在水下作业的潜水帽。'),
            ('ChitinRingT', u'加速圈'),
            ('StonecutterSkillD', u'研究它以提高石制物品制作速度。'),
            ('NewYearTreeT', u'圣诞树'),
            ('UndeadAmuletD', u'这个戒指会减少僵尸的伤害值。'),
            ('DivinghelmetT', u'潜水帽'),
            ('ChitinRingD', u'加速圈能让矮人的移动速度增加30%'),
            ('StonecutterSkillT', u'石匠手册'),
            ('MigiccollectresourcesD', u'这个魔法搜集小范围内的资源，并将他们送到仓库。'),
            ('CastthehornD', u'这个魔法让矮人在特定地点进行集结，例如集合进行攻击或防守。'),
            ('PoisonArrowT', u'毒箭'),
            ('WoodenbigchairD', u'用于厨房和客厅的结实大椅。'),
            ('SilverPickT', u'银镐'),
            ('ArcherSkillD', u'提高远程武器伤害值。'),
            ('WagonD', u'这种马车可以放在铁路上，让矮人可以快速下轨道。'),
            ('SteelLadderD', u'钢梯可极大地提高矮人的灵活性，让他们的房屋更舒适。'),
            ('MigiccollectresourcesT', u'魔法搜集'),
            ('SpireD', u'城堡塔楼的最高部分。'),
            ('PoisonArrowD', u'毒箭能毒杀敌人并且具有传递效果'),
            ('WoodenbigchairT', u'大椅'),
            ('SilverPickD', u'银镐是采矿的理想工具。'),
            ('ArcherSkillT', u'弓箭手手册'),
            ('SwordDaoT', u'龙战士之剑'),
            ('WagonT', u'马车'),
            ('SteelLadderT', u'钢梯'),
            ('SilverIngotD', u'一大块金属，准备用来加工制作物品。'),
            ('BrickwallT', u'砖墙'),
            ('RustyskeletonheavymaceT', u'骷髅权杖'),
            ('IceD', u'可以融化成饮用水。'),
            ('ServingSpoonD', u'提高烹饪技能效率。'),
            ('AquariumT', u'鱼缸'),
            ('BatonT', u'棍棒'),
            ('MithrilAxeT', u'秘银斧'),
            ('BrickwallD', u'厚砖城墙是抵御来犯敌人的最好屏障之一。'),
            ('RustyskeletonheavymaceD', u'有些士兵哪怕至死也是剑不离手。'),
            ('IceT', u'冰'),
            ('ServingSpoonT', u'勺子'),
            ('ChristmasWreathD', u'居家圣诞节装饰。'),
            ('AquariumD', u'鱼不仅可以放在煎锅里面油炸，也可以放在鱼缸里养着。它们既能够充饥，又能够悦目。'),
            ('ManaPylonT', u'魔法水晶'),
            ('BatonD', u'棍棒做工简单，能帮助矮人击退敌人，只要敌人不太难对付。'),
            ('BluediamondD', u'用于制造魔法物品和装备的宝石。'),
            ('HoodedhatT', u'兜帽'),
            ('NewYearTreeD', u'嗬嗬嗬！圣诞快乐！'),
            ('BluediamondT', u'蓝水晶'),
            ('PickCaveGoblinT', u'洞穴妖精镐'),
            ('MithrilPickT', u'秘银镐'),
            ('HoodedhatD', u'新矮人戴着这些兜帽正向你走来，希望你会给他们更耐用的兜帽。'),
            ('PaintingwithsightsT', u'风景画'),
            ('MithrilHelmetT', u'秘银头盔'),
            ('FlashlightD', u'感受节日的气氛吧，我的朋友！'),
            ('CasttheforestT', u'魔法森林'),
            ('SlimeT', u'粘液'),
            ('WoodentrapT', u'木夹'),
            ('SpawnCubeD', u'很久以前，这些土地上的主人使用重生方块让他们的地宫充满了各种怪兽。但年月太久，已经无人知晓他们的名字...'),
            ('PaintingwithsightsD', u'非常漂亮的自然风景。'),
            ('CasttheforestD', u'这个魔法让目标区域多棵树快速长成。'),
            ('SlimeD', u'这种物质是从蛞蝓体中提取而得，可用于制作特殊光亮和药水。'),
            ('FTPCraftD', u'It is used for crafting simple tools and items.'),
            ('WoodentrapD', u'用于捕猎动物和弱小怪物的简单夹子。将它放在动物和怪物可能出没的路上。'),
            ('DeserthatT', u'头巾'),
            ('NeedleD', u'针用于缝制面料。'),
            ('RegenRindT', u'生命戒指'),
            ('WalllampD', u'家里用的一种普通油灯。'),
            ('ManaExpanderD', u'该装置能提高最大魔法值 20 点。'),
            ('DeserthatD', u'穿越沙漠必不可少的物品。'),
            ('AmmoSteelD', u'可造成巨大伤害。'),
            ('NeedleT', u'针'),
            ('WalllampT', u'壁灯'),
            ('StaticPortalD', u'门通过使用法术力永久地打开门户。 切换闸门以节省法术力。'),
            ('CabelsD', u'它们可以用来编织可爱的花环。'),
            ('IronfenceT', u'铁栅栏'),
            ('MinnerSkillT', u'采矿手册'),
            ('KettleD', u'厨房内用于烹制热饭菜的必要物品。'),
            ('CatHouseT', u'猫头鹰之屋'),
            ('SkillsRindD', u'这个戒指会同时增加所有的技能。'),
            ('TransformelexirD', u'这种药剂可以将多个怪物变成蜗牛。'),
            ('KnightBootsD', u'走起路来一定很沉重。'),
            ('Relief2D', u'一种墙壁装饰。'),
            ('MeleeSkillT', u'战士手册'),
            ('FTPCraft2T', u'Workplace'),
            ('IronfenceD', u'减缓敌人前进速度的栅栏。'),
            ('MinnerSkillD', u'提高挖土采石的速度。'),
            ('ACH_HARDCORE_GAME', u'硬核玩家三角旗'),
            ('KettleT', u'锅'),
            ('RevivalElixirT', u'复活药水'),
            ('LeatherbootsD', u'矮人最常穿的鞋子。'),
            ('SawT', u'手锯'),
            ('Relief2T', u'扩展浮饰'),
            ('MeleeSkillD', u'提高近战中近身武器的伤害值。'),
            ('StaticPortalT', u'门户门'),
            ('SkullCookiesD', u'撒着糖粉的面包'),
            ('IcearrowelexirT', u'冰箭药剂'),
            ('SteelbatonD', u'如果你有这样一根棍棒，穿越野外森林的时候就不怕了。'),
            ('GoldarmorT', u'金盔甲'),
            ('RustymummysaberT', u'木乃伊的佩剑'),
            ('SkullCookiesT', u'头骨面包'),
            ('SteelbatonT', u'钢棒'),
            ('GoldarmorD', u'只有年长的矮人才能穿得起金盔甲。'),
            ('RustymummysaberD', u'一把锈迹斑斑的古剑。'),
            ('PotbellystoveD', u'一种用于烹饪的简易火炉。'),
            ('SteelChainArmorT', u'钢盔甲'),
            ('RegenRindD', u'这个戒指会逐渐恢复矮人的生命值。'),
            ('PiratHatT', u'海盗帽'),
            ('SteelpickaxeD', u'用于采矿的优质镐。'),
            ('AntiquecolumnT', u'古老的柱子'),
            ('CoalT', u'煤炭'),
            ('ManaExpanderT', u'魔法储存器'),
            ('PotbellystoveT', u'大肚皮厨房炉灶'),
            ('SteelChainArmorD', u'用普通金属锻造的优质盔甲。'),
            ('SteelpickaxeT', u'钢镐'),
            ('AntiquecolumnD', u'一根古老的柱子，是矮人在废弃的地牢里发现的。'),
            ('CoalD', u'火炉和矮人厨房的主要燃料。'),
            ('CrockD', u'一个好的砂锅可以在晚上放在床边。'),
            ('IronpickaxeD', u'用于采石的高级镐。'),
            ('StoneWallSetT', u'石制墙壁嵌板'),
            ('IronbootsD', u'保护双腿的金属盔甲。'),
            ('ElvenspearT', u'精灵戟'),
            ('CrockT', u'黏土砂锅'),
            ('IronpickaxeT', u'铁镐'),
            ('Block2portalT', u'第二个传送门部件'),
            ('RustyskeletonhelmetD', u'一个骷髅头上锈迹斑斑的头盔。'),
            ('GoldShieldItemT', u'黄金盾牌'),
            ('SilverbootsT', u'银靴'),
            ('WoodtowerD', u'最基本的防御塔。自动向怪物发射箭矢。'),
            ('PendulumclockT', u'摆钟'),
            ('RustyskeletonhelmetT', u'锈迹斑斑的头盔'),
            ('SilverbootsD', u'这些靴子很坚固，与银头盔很搭。'),
            ('ScrambledeggsT', u'煎蛋'),
            ('AmmoFireD', u'可造成最大可能的伤害。'),
            ('WoodtowerT', u'木塔'),
            ('Block3portalT', u'第三个传送门部件'),
            ('PendulumclockD', u'大型落地钟，用于室内装饰。'),
            ('FishstewT', u'鱼汤'),
            ('CasewithclothesT', u'衣柜'),
            ('RuneT', u'符石'),
            ('WoodD', u'基本的可再生建材，用于制作家具和其他物品。'),
            ('GrindingStoneT', u'磨石'),
            ('BerriesT', u'浆果'),
            ('GoldenhelmetT', u'金头盔'),
            ('ScissorsT', u'剪刀'),
            ('FishstewD', u'可以用鱼简单烹制出几份炖汤。'),
            ('LargestoveD', u'给厨师提供的大的烹饪空间。'),
            ('WoodT', u'木材'),
            ('GrindingStoneD', u'提高剑士技能效率。'),
            ('BerriesD', u'用于制作菜肴、药水和染料的多功能原料。'),
            ('GoldenhelmetD', u'这件精致耐用的金头盔为头部提供很好的保护。'),
            ('ScissorsD', u'剪羊毛需要剪刀。'),
            ('ChristmasTreeToyD', u'好漂亮啊！不过要小心别打破它…'),
            ('GrilledmeatD', u'打猎获得的肉可以在木炭上烹饪。'),
            ('DemonHornsT', u'恶魔角'),
            ('BonesT', u'骨头'),
            ('Plantinapot2T', u'盆栽棕榈树'),
            ('QuartzD', u'一种非常有用的晶体，用于建造特斯拉塔。'),
            ('TeaT', u'茶'),
            ('AlchemistBagT', u'药剂包'),
            ('ChristmasTreeToyT', u'圣诞树装饰品'),
            ('GrilledmeatT', u'烤肉'),
            ('DemonHornsD', u'附带恶魔翅膀。'),
            ('BonesD', u'各种动物遗留的骨头可以用来制作简单的火把。'),
            ('Plantinapot2D', u'装饰室内和房屋周围。'),
            ('QuartzT', u'石英'),
            ('TeaD', u'喝茶让矮人精力充沛，跑得更快。'),
            ('AlchemistBagD', u'提高法师技能效率。'),
            ('BeerD', u'矮人喝上一大杯啤酒能提高生产力。'),
            ('StoneaxeT', u'石斧'),
            ('DemonHunterD', u'一顶时尚的帽子，会提高佩戴者的射击技能。'),
            ('LaddersKitT', u'快速扶梯包'),
            ('ACH_FORTRESS_KEEPER', u'三角旗城堡后卫'),
            ('WoodenspikesD', u'木锥减缓怪物的进攻速度并对它们造成伤害。'),
            ('WaterT', u'水'),
            ('SilverArmorT', u'银盔甲'),
            ('BeerT', u'啤酒'),
            ('Broth_of_combat_madnessT', u'战斗狂热浸剂'),
            ('StoneaxeD', u'用废料制作的普通斧头。用于伐树。'),
            ('ScrambledeggsD', u'你煎蛋饼不可能不打些蛋。'),
            ('LaddersKitD', u'这种包可以让矮人搭起多段临时扶梯，从而抵达目标位置。'),
            ('WoodenspikesT', u'木锥'),
            ('WaterD', u'水普遍用于烹饪、药水制作以及建筑砂浆。要取水，你需要仓库有水桶。'),
            ('PurplediamondT', u'紫水晶'),
            ('CasewithclothesD', u'家具增加家的舒适值，让你的矮人迅速更快恢复生命值。'),
            ('WorkerInStoneD', u'舒适房间的好装饰'),
            ('IronaxeT', u'铁斧'),
            ('PurplediamondD', u'用于制造魔法物品和装备的宝石。'),
            ('RuneD', u'这块石碑是某种机关的一部分。它会是一把钥匙吗？'),
            ('LargestoveT', u'大灶'),
            ('WorkerInStoneT', u'石头中的化石甲虫'),
            ('NecklaceT', u'兽爪项链'),
            ('IronaxeD', u'改良的铁斧，用于伐树。也可以用作武器。'),
            ('CastthefireballD', u'对目标区域多个生物造成伤害。'),
            ('SquarewindowD', u'照亮房屋的普通窗户。'),
            ('GreendiamondT', u'绿水晶'),
            ('PumpkinHatD', u'它无法很好地保护你，但看着很有趣。'),
            ('MithrilIngotD', u'一大块金属，准备用来加工制作物品。'),
            ('MushroomT', u'蘑菇'),
            ('BrickT', u'砖块'),
            ('SquarewindowT', u'方形窗'),
            ('GreendiamondD', u'用于制造魔法物品和装备的宝石。'),
            ('DragonWarriorCuirassT', u'龙战士胸甲'),
            ('PumpkinHatT', u'南瓜头盔'),
            ('MithrilIngotT', u'秘银锭'),
            ('ChitinD', u'壳的残留物。'),
            ('BrickD', u'一种用黏土做成的耐用材料，用于建造墙壁。'),
            ('LoggerSkillT', u'伐木手册'),
            ('DeadlockT', u'单闩锁'),
            ('WizardsstaffMistT', u'秘银法杖'),
            ('ElvenHelmetD', u'寒冰群落精灵的头盔。'),
            ('ClayT', u'黏土'),
            ('ZombiecagewoodenD', u'这种木笼子可以暂时装一些怪物，让矮人攻击它们又没有被反击的危险。'),
            ('ChitinT', u'甲壳质'),
            ('LargetableT', u'大桌'),
            ('FrostlingbowT', u'冰霜人之弓'),
            ('LoggerSkillD', u'提高伐树速度。'),
            ('Broth_of_combat_madnessD', u'这种浸剂采用兽人鲜血、青霉提取物和穴居野兽的牙齿粉末制成，是很好的兴奋剂！它可以提高人们在短时间内的移动和攻击速度。'),
            ('WizardsstaffMistD', u'秘银法杖提高吟唱魔法的效率。'),
            ('ElvenHelmetT', u'精灵头盔'),
            ('ClayD', u'一种建材，可直接从脚下获得，用于建筑和陶瓷。'),
            ('ZombiecagewoodenT', u'木笼'),
            ('SawD', u'提高伐木和木工技能效率。'),
            ('LargetableD', u'这张桌子可已容纳许多各类菜肴。'),
            ('CatapultTowerD', u'一种重型远程防御武器，用于抵御潮水般涌来的怪物，并可对很大的范围造成重大伤害。'),
            ('SilverIngotT', u'银锭'),
            ('HalloweenPictureT', u'万圣节图画'),
            ('StonestepsD', u'虽然矮人能跳能爬，但是有台阶走自然会更开心。'),
            ('IronhelmetT', u'钢盔'),
            ('RailroadswitchD', u'为了让矮人在铁路中间路段（非始站和终点站）能够进入马车，请在中间站台安装这些转辙机。'),
            ('TorchD', u'火把用来照亮地牢，吓跑一些小型生物。'),
            ('CastthehornT', u'号角魔法'),
            ('NailT', u'钉子'),
            ('HalloweenPictureD', u'典型恐怖世界的小型图画。'),
            ('IronhelmetD', u'这种钢铁头盔结构简单且耐磨耐用。'),
            ('RailroadswitchT', u'铁路转辙机'),
            ('TorchT', u'火把'),
            ('ManaPylonD', u'这种水晶可减少魔法在离主仓库较远的地方施展时消耗法力增多的程度。'),
            ('WallskinrugD', u'装饰墙壁的狩猎战利品。'),
            ('SilverT', u'银矿'),
            ('CastthefireballT', u'火球'),
            ('WoodShieldItemT', u'木制盾牌'),
            ('ForgetElixirT', u'忘却药剂'),
            ('FireworksD', u'说明：1) 放置在空旷的地方。2) 日落后点燃。3) 跑开。'),
            ('StonepickaxeD', u'用废料做成的普通镐。哪怕是一把普通镐，采矿速度也比刀等常规工具要快。'),
            ('MetalchestD', u'一种更耐用的金属箱，可以装很多有用的物品。'),
            ('BucketOfWormsD', u'提高渔夫技能效率。'),
            ('SilverD', u'银矿用于制造非常耐用的武器和门。'),
            ('ElvenShieldT', u'精灵盾牌'),
            ('WoodShieldItemD', u'这种盾牌可以吸收一部分伤害。战士的技能可增加封堵机率。'),
            ('WarehouseD', u'建造更多的仓库，节约矮人来回运送物品的时间。'),
            ('ForgetElixirD', u'使矮人忘却自己的技能。'),
            ('FireworksT', u'节日焰火'),
            ('DragonWarriorCuirassD', u'一件精美的胸甲，由遥远东方帝国的一位大师级工匠制作。'),
            ('StonepickaxeT', u'石镐'),
            ('MetalchestT', u'金属箱'),
            ('FunnySceletonCuirassD', u'趣怪骷髅套装的一部分。既提供保护，又很时尚！'),
            ('GlassvaseD', u'精致的玻璃花瓶。'),
            ('Relief1T', u'花朵装饰'),
            ('FlourD', u'磨坊将麦粒磨成面粉，用于烹制馅饼。'),
            ('WitchFingersT', u'女巫手指饼'),
            ('RudolfD', u'居家圣诞节装饰。'),
            ('GlassT', u'玻璃'),
            ('GlassvaseT', u'玻璃花瓶'),
            ('Relief1D', u'一种墙壁装饰。'),
            ('FlourT', u'面粉'),
            ('SpiderPieD', u'美味的派，上面有用糖霜做的蜘蛛网和黑巧克力做的蜘蛛。'),
            ('RudolfT', u'鲁道夫雕像'),
            ('GlassD', u'玻璃用于制作窗户和灯泡以及花瓶等室内玻璃物品。'),
            ('AppleD', u'伐树矮人一发现球果和苹果就可以吃。'),
            ('StonestepsT', u'石阶'),
            ('SofaD', u'沙发可以大幅度提高房屋的舒适值。'),
            ('LongbowT', u'长弓'),
            ('AppleT', u'苹果'),
            ('FunnySceletonHelmetT', u'趣怪骷髅头盔'),
            ('SofaT', u'沙发'),
            ('LongbowD', u'一种经改良用于远程战斗的弓。造成更大伤害值。'),
            ('FrostlingbowD', u'冰霜人用于打猎的小弓。'),
            ('FishingrodD', u'渔具。矮人去钓鱼的时候自己会从你的仓库取钓鱼竿。你的钓鱼竿越多，每次去钓鱼的矮人就越多。'),
            ('WarriorTrainingD', u'这个假人可以让你使用更多巧妙的技巧，更快地训练战士的技能。'),
            ('FabricD', u'面料用来缝制衣服和其他室内物品。'),
            ('FishD', u'一种可再生食物来源，可用于烹饪许多不同的菜肴。需要钓鱼竿。'),
            ('EggT', u'蛋'),
            ('StonecolumnT', u'石柱'),
            ('AmmoSteelT', u'钢制弹药'),
            ('FishingrodT', u'钓鱼竿'),
            ('FabricT', u'面料'),
            ('FishT', u'鱼'),
            ('EggD', u'你煎蛋饼不可能不打些蛋。'),
            ('StonecolumnD', u'礼堂的装饰性柱子。'),
            ('PaperD', u'纸用于制作油画等装饰品。'),
            ('FunnySceletonCuirassT', u'趣怪骷髅半身铠'),
            ('AbstractpaintingT', u'肖像'),
            ('BlackandwhitepennantT', u'黑白三角旗'),
            ('MinerAmuletD', u'这个戒指让你有机会在采矿时获得更多矿石。'),
            ('WoodendoorT', u'木门'),
            ('BirdcageD', u'一只喷怒的鸟在笼子里挣扎，逗乐了矮人。'),
            ('PaperT', u'纸'),
            ('AbstractpaintingD', u'著名矮人的肖像，再加上一些不那么出名的矮人的肖像。'),
            ('BlackandwhitepennantD', u'三角旗。用于室内装饰。'),
            ('CripCatHouseD', u'直接来自宠物公墓！'),
            ('WoodendoorD', u'简单的木门，跟其他门一样，提供庇护的作用，将不速之客拒之门外。'),
            ('SpiderPieT', u'蜘蛛巢派'),
            ('AchivPennantD', u'获得一些成就后，相应的旗帜就可以使用'),
            ('BirdcageT', u'笼中之鸟'),
            ('GrilledfishD', u'要烹饪钓到的鱼，最简单的办法是用一些木炭来烤。'),
            ('MinerslampT', u'矿灯'),
            ('WinterhatT', u'冬帽'),
            ('StonewallT', u'石墙'),
            ('GunnarT', u'贡纳铁拳之雕像'),
            ('WoodenbridgeT', u'木桥'),
            ('ClimberSkillT', u'攀岩手册'),
            ('ElevatorT', u'升降机'),
            ('GrilledfishT', u'烤鱼'),
            ('MinerslampD', u'矿灯可以放在地面上任何地方充当光源。它非常适合用来采矿——当一个地方开采完之后，矿灯可以移到其他位置。'),
            ('StonewallD', u'用石头建成，这种普通墙壁既美观又结实。'),
            ('GunnarD', u'这座雕像是北族妖精之战的战争英雄、传奇将军。他同样出名的还有酗酒和粗暴脾气，不过历史不会记住这些…这座雕像给所有剑士加持5个技能加成。'),
            ('ClimberSkillD', u'提高自己攀登垂直矿井和悬崖的技能，这样掉下来的几率就降低了。'),
            ('ElevatorD', u'垂直轴上安装有一架升降机，每次可以快速在各楼层之间运送几个矮人。'),
            ('RedpennantT', u'黑白三角旗'),
            ('SteelswordD', u'钢剑是基本近身武器。你也可以用它猎杀动物。'),
            ('MillerSkillT', u'碾磨手册'),
            ('WarriorTrainingT', u'机械训练假人'),
            ('TeslatowerT', u'特斯拉塔'),
            ('LogbridgeT', u'独木桥'),
            ('RoomdoorT', u'内门'),
            ('WoodenbridgeD', u'这种木桥简单，却也耐用且容易建造，提供可靠的渡河方式。'),
            ('SteelswordT', u'钢剑'),
            ('MillerSkillD', u'提高麦粒磨成面粉的速度。'),
            ('EliteWallSetD', u'精装内墙的装饰镶板。'),
            ('TeslatowerD', u'这座塔释放闪电攻击来犯的敌人。可以在塔顶建造额外的设施把塔升级到3级。'),
            ('LogbridgeD', u'临时搭建的桥—做工最简单，但不是很耐用。'),
            ('RoomdoorD', u'内门不算是居所的边界。'),
            ('FireplaceT', u'壁炉'),
            ('StewT', u'炖汤'),
            ('IrondoorT', u'铁门'),
            ('CavegoblinSaberD', u'一种用骨头和牙齿做的粗糙武器。'),
            ('GoldbootsD', u'漂亮、坚韧的金靴。'),
            ('RifleT', u'步枪'),
            ('FireplaceD', u'一种壁炉，用于室内装饰。'),
            ('StewD', u'除了烤肉，猎杀的野生动物还可以用来炖汤。'),
            ('StatueT', u'罗里%xb7石肤雕像'),
            ('IrondoorD', u'强化铁门可将不速之客拒之门外。'),
            ('HitinBootsT', u'甲壳质靴'),
            ('ManaElixirT', u'魔法药剂'),
            ('GoldbootsT', u'金靴'),
            ('BucketOfWormsT', u'一桶蚯蚓'),
            ('DecorativeShieldT', u'装饰盾'),
            ('ShamanStaffD', u'这根魔法杖里渗透了如此多的魔法，甚至于会刺痛那些握着它的手！它可提供能同时攻击 4 个目标的能力，并能提高魔法师的技能。'),
            ('Cuckoo-clockD', u'地下不分白天黑夜，所以每个人需要一个钟。'),
            ('FenceD', u'最简单的围墙。稍稍减缓敌人的前进速度。'),
            ('RedpennantD', u'三角旗。用于室内装饰。'),
            ('WheelfortrolleyT', u'金属车轮'),
            ('ShamanStaffT', u'萨满的魔法杖'),
            ('Cuckoo-clockT', u'布谷鸟钟'),
            ('FenceT', u'简易围栏'),
            ('WheelfortrolleyD', u'矿车的主要部件。'),
            ('Stained-glasswindowT', u'彩色玻璃窗'),
            ('WizardsstaffD', u'这种魔法杖可以让持仗者（矮人）可以在战斗中使用配制好的魔法药水。'),
            ('TrunkT', u'枪口'),
            ('StoneknifeD', u'最普通的刀。大部分矮人一出生就会用。既是一种多功能武器，也是搜集资源的工具。'),
            ('AnvilwithahammerT', u'熔炉'),
            ('SmithSkillD', u'提高用金属锻造物品的速度。'),
            ('DragonWarriorBootsD', u'嵌金的结实皮靴。'),
            ('WoolT', u'毛料'),
            ('KnightBootsT', u'黑暗领主的装甲靴'),
            ('ChandelierSmallD', u'光亮提高房子的舒适值。'),
            ('MushPiesD', u'你会惊讶于蘑菇竟能做出那么多的菜肴！'),
            ('Stained-glasswindowD', u'彩色玻璃窗通常用于大厅。'),
            ('WizardsstaffT', u'法杖'),
            ('TrunkD', u'枪支的一种主要部件。'),
            ('StoneknifeT', u'石刀'),
            ('AnvilwithahammerD', u'制造复杂的金属物品需要一个熔炉。'),
            ('SmithSkillT', u'锻造手册'),
            ('WoodmansHatT', u'羽帽'),
            ('WoolD', u'一种狩猎获得的动物皮毛，可用于制作面料和绳索。'),
            ('RustyskeletonmaceT', u'骷髅的生锈权杖'),
            ('ChandelierSmallT', u'小吊灯'),
            ('MushPiesT', u'蘑菇馅饼'),
            ('RoundmirrorD', u'即便是矮人，偶尔看看自己的容颜也并不大碍。'),
            ('IcetableT', u'冰桌'),
            ('CabinetwithshelvesT', u'搁架橱柜'),
            ('HeavyrifleD', u'一种威力强大的远距离步枪，精准度很高。'),
            ('ArcherTrainingD', u'对运动目标进行射击，提供更好的训练。'),
            ('MagicanTrainingSimpleT', u'魔法之球'),
            ('IcearrowelexirD', u'有了这个药剂，矮人法师可以发射冰箭，短时间内减缓敌人的前进速度。'),
            ('KnightSwordD', u'曾经非常伟大的领主之剑，使用时可恢复其主人的生命力。'),
            ('RoundmirrorT', u'圆镜'),
            ('IcetableD', u'用冰做成的桌子。不能用于温暖的地方。'),
            ('CabinetwithshelvesD', u'带有搁架的橱柜。'),
            ('HeavyrifleT', u'强力步枪'),
            ('HitinBootsD', u'用甲壳质护层加固的皮靴。'),
            ('ArcherTrainingT', u'射击场'),
            ('ManaElixirD', u'使用药剂恢复一些魔法值。'),
            ('MagicanTrainingSimpleD', u'训练法师时，这种球体能安全地吸收来自战斗法术的能量。'),
            ('Backpack1D', u'矮人携带物品数量增加 %1。'),
            ('DecorativeShieldD', u'用于室内装饰。'),
            ('ApplepieD', u'馅饼不容易做，不过够养活几张嘴。'),
            ('WoodenwallT', u'木墙'),
            ('SantaArmorD', u'圣诞老人的魔法外套。'),
            ('ApplepieT', u'苹果馅饼'),
            ('KnightHelmetT', u'骑士的角盔'),
            ('NecklaceD', u'项链能让战士的战斗力翻倍'),
            ('WoodenwallD', u'木墙结构简单，是建造简陋庇护所的主要结构。'),
            ('SantaArmorT', u'圣诞老人的外套'),
            ('CasttherainD', u'这种魔法可在地面上召唤普通的降雨或降雪，取决于当下的季节。'),
            ('AngelNimbusD', u'让你与邪恶作斗争！'),
            ('WitchFingersD', u'配上绿色糖霜特别美味！'),
            ('SlimetorchT', u'粘液火把'),
            ('PinkCrystalD', u'一种可在地下最底层发掘的宝石。'),
            ('AngelNimbusT', u'天使光环'),
            ('SlimetorchD', u'矮人不懂存储，只会让它们蒙灰。但是即便是粘液和骷髅也有各自的用途。'),
            ('PinkCrystalT', u'粉水晶'),
            ('WallcarpetT', u'壁毯'),
            ('ElixirofsparkD', u'为魔法杖加持无限闪电。'),
            ('TextilechairT', u'布椅'),
            ('LancetwindowT', u'桃尖拱窗'),
            ('CastthecompasT', u'指南针魔法'),
            ('GreyMushroomT', u'灰蘑菇'),
            ('FunnySceletonClubD', u'能击垮无聊，也能粉碎骨头！对骷髅和僵尸会造成更多的伤害。'),
            ('WallcarpetD', u'一种用于室内装饰的壁毯。'),
            ('ElixirofsparkT', u'闪电药剂'),
            ('TextilechairD', u'普通布椅。'),
            ('LancetwindowD', u'经典木窗。'),
            ('CastthecompasD', u'指南针指向最近的密室。'),
            ('GreyMushroomD', u'炼金药剂的一种原料。'),
            ('MithrilSwordT', u'秘银剑'),
            ('KnightHelmetD', u'这种头盔上的角用于激发敌人的恐惧。'),
            ('DesertbootsT', u'沙漠靴'),
            ('CasttherainT', u'降雨或降雪'),
            ('MithrilSwordD', u'用这种最珍贵金属制造的奢华武器。'),
            ('WineT', u'自制葡萄酒'),
            ('GunpowderT', u'火药'),
            ('MagicanTrainingD', u'这个射击场可以让法师研究战斗法术的所有精妙之处。'),
            ('YataganswordT', u'穆斯林弯刀'),
            ('FatD', u'可用于烹制食物。'),
            ('DarkbluediamondT', u'黑水晶'),
            ('IcestatueT', u'冰雕'),
            ('MagiccauldronT', u'实验室'),
            ('BucketT', u'桶'),
            ('MithrilbootsD', u'旷古至今最好的靴子！'),
            ('WineD', u'一种极好的自制饮料。'),
            ('GunpowderD', u'制作枪支的元件。'),
            ('MagicanTrainingT', u'魔法射击场'),
            ('YataganswordD', u'弯刀做工简单，但是在合适的人手上也是危险的武器。'),
            ('FatT', u'猪油'),
            ('DarkbluediamondD', u'用于制造魔法物品和装备的宝石。'),
            ('IcestatueD', u'用冰做成的雕像。'),
            ('MagiccauldronD', u'一个用于制作魔法药水的魔法大锅，矮人可以独立使用魔法药水。'),
            ('BucketD', u'水桶用来提水。你的水桶越多，矮人一次提的水就越多。'),
            ('MithrilbootsT', u'秘银靴'),
            ('MinerAmuletT', u'矿工戒指'),
            ('BottleT', u'瓶子'),
            ('ManaGeneratorD', u'该装置能增加 300% 的魔法回复。'),
            ('LeavesD', u'树叶用于制作最简单但不耐用的物品。'),
            ('PunchT', u'潘趣酒'),
            ('WoodenchestD', u'室内木箱。被遗弃的房中发现的木箱中可能有有用的物品。'),
            ('SmithApronD', u'提高锻造技能效率。'),
            ('FunnySceletonClubT', u'趣怪骷髅锤'),
            ('LeatherskinD', u'狩猎过程中获得的毛皮可用于制作装饰性和/或实用型室内物品。'),
            ('BottleD', u'用来存放炼金药水。'),
            ('ManaGeneratorT', u'魔法产生器'),
            ('LeavesT', u'树叶'),
            ('PunchD', u'没有潘趣酒还叫什么万圣节？'),
            ('WoodenchestT', u'木箱'),
            ('SmithApronT', u'锻造围裙'),
            ('WarriorTrainingSimpleD', u'选择一个具有战士技能的矮人，并将他送到训练假人那里，以提高他的技能等级。'),
            ('TotemD', u'在房屋周围形成一种光环，保护房屋不受怪物的侵扰。'),
            ('PickCaveGoblinD', u'这些妖精肯定知道如何快速挖掘！巨型蚯蚓的螯角使得挖地快如刀切黄油。'),
            ('CavegoblinSaberT', u'洞穴妖精佩剑'),
            ('MinerLampT', u'手提灯'),
            ('RootD', u'一些植物根可以用于制作药水和香料。'),
            ('ShamanCloakT', u'妖精萨满的帽子'),
            ('WorkshopT', u'作坊'),
            ('CasttheimpsD', u'召唤几个小精灵帮助搜集资源。'),
            ('SulfurT', u'硫'),
            ('BatHatT', u'蝙蝠耳'),
            ('TotemT', u'图腾'),
            ('MinerLampD', u'提高挖矿技能效率。'),
            ('RootT', u'根'),
            ('ShamanCloakD', u'这顶帽子可以使魔法攻击的威力更强，并且可以很好的防雨。'),
            ('WorkbenchD', u'一张工作台，用于加工木材制作复杂物品。'),
            ('WorkshopD', u'一间作坊，将石头加工成复杂的形状。'),
            ('CasttheimpsT', u'小精灵召唤'),
            ('SulfurD', u'制作炸药的成分。'),
            ('BatHatD', u'万圣节节庆装饰。'),
            ('ScaffoldingD', u'矮人可以爬在脚手架上进行高空作业。你可以随时马上搭建或拆除脚手架。'),
            ('ParachuteD', u'据说最先使用降落伞的是危险洞穴里的那些兽人。当从高处下落时，降落伞可以为矮人提供保护。'),
            ('TrickyTokiT', u'狡猾藤树的雕像'),
            ('RecipeT', u'秘笈：'),
            ('ScaffoldingT', u'脚手架'),
            ('ParachuteT', u'降落伞'),
            ('TrickyTokiD', u'藤树是所有矮人故事中一个令人讨厌的主人公，他非常富有，同时也非常聪明！这个人物的雕像可神奇地让整个部落高兴起来，并能提高找到金币的机率！')
        ]
        translateByDict(dom,tranDict)
        self.writeFile(filename,dom.toxml('UTF-8'))
 
    def translateQuestXML(self):
        filename = "Lang/Chinese/data/local/quests.xml"
        string = self.readFile(filename)
        dom = parseString(string)
        tranDict = [
            ('CastaspellT', u'释放魔法'),
            ('FindpreciousmetalsT', u'找到珍贵金属'),
            ('CastaspellD', u'必要时帮助你的矮人很重要。你使用魔法来杀死怪物、打开传送门或者制造一片森林'),
            ('HuntabeastT', u'追捕野兽'),
            ('ShopingD', u'某些物品由于需要很稀少的资源而难以制造。可以通过矮人商店来获取稀有或唯一的物品。'),
            ('FortifythehouseT', u'加固房屋'),
            ('MakeatorchT', u'制作火把'),
            ('UnderwaterworkD', u'创造一个潜水头盔，让矮人可以在水下工作，收集溺水的东西，而不损害他们的健康。必要时，矮人自己戴上头盔。多个头盔可以让多个矮人进行水下工作。'),
            ('ProtectyourhomeD', u'你需要保护庇护所的人口通道，这样矮人守起来就简单些。在怪物来犯的路上建造一些可用的防御设施——笼子或夹子。'),
            ('BuildabridgeD', u'通过桥可以轻易穿过水的障碍。建造一座木制或石桥，方便地穿越到另一边。'),
            ('FarmingD', u'自己种植粮食比花时间觅食强得多。在地里种上小麦，浇灌几次。一旦小麦长成，你就可以收割麦粒，用来烹制食物。'),
            ('FindpreciousmetalsD', u'要打造珠宝和高级武器，你需要稀有珍贵金属：银、金和秘银。挖深点找到它们。'),
            ('BuildabridgeT', u'造桥'),
            ('HuntabeastD', u'动物不仅是食物的来源，也是各种生成资源的来源，如羊毛。在营地附近找到一只野兽，并将其标记为狩猎目标。'),
            ('CollectstonesT', u'搜集石头'),
            ('FortifythehouseD', u'庇护所的墙壁越坚固，怪物就更难攻破它们。用石墙或砖墙来更换脆弱的土墙。'),
            ('Nosh-upT', u'喂食矮人'),
            ('MakeatorchD', u'地下城是黑暗的，到处都是各种怪物。你必须用火把照亮矮人的通道。制作一个火把，并把它安装在隧道里。'),
            ('BuildrailwayD', u'轨道矿车可以更快地将矮人水平运送过矿山。建造一条铁路。沿途设置站台，使用铁轨转辙机。'),
            ('FishingD', u'鱼是永远的食物来源，弄起来也方便。做一根钓鱼竿，找到最近的淡水塘来钓鱼。'),
            ('ProtectyourhomeT', u'保护你的家'),
            ('BuildaladderD', u'如果没有额外的支撑，爬越隧道可能会很危险而且缓慢。建一个梯子，把它放在隧道里。'),
            ('PreaparefoodD', u'在桌上放一些食物，如苹果。矮人饿的时候会自己来拿。'),
            ('MakeatableT', u'制作一张桌子'),
            ('FindundergroundresoursesD', u'往深处挖掘，你会发现一些不同类型的矿物。它们看起来就像常见土块上的斑点。'),
            ('ExploredeepT', u'往深处探索'),
            ('StrengthenarmsT', u'强化武器'),
            ('FindironoreD', u'大多数器械和武器都是用铁锻造而成。寻找一个铁矿矿藏。'),
            ('FindahiddenplaceT', u'找到一间隐蔽的房间'),
            ('Nosh-upD', u'哪个矮人不喜欢美食佳肴！在炉灶上烹制一道具有异国风味的菜肴吧。'),
            ('BuildashelterD', u'建造庇护所。挖一个带竖井的小洞。在竖井里建一个梯子，并在入口安装一个舱口'),
            ('GiveanewweaponT', u'给一种新武器'),
            ('FarmingT', u'耕作'),
            ('BuildaladderT', u'建造梯子'),
            ('PreaparefoodT', u'制作一些食物'),
            ('MakeatableD', u'当矮人工作时，他们逐渐变得饥饿。制作一张矮人们可以吃饭的桌子'),
            ('RepairtheportalD', u'地下某个地方有古老传送门的碎片，传送门可以在两个世界之间开启一道门。找到传送房间然后进行重建。你找到该房间后方块秘笈会自动出现。'),
            ('FindundergroundresoursesT', u'寻找地下资源'),
            ('EnlargetheshelterT', u'扩建庇护所'),
            ('StrengthenarmsD', u'建造一个铁匠台锻造更坚韧的盔甲和武器。使用强化钢铁代替铁。'),
            ('FindironoreT', u'找到铁矿'),
            ('FindahiddenplaceD', u'地下有很多废弃的矿山和房间，它们能够放置一些有用的物品。使用指南针魔法来为你指明附近哪个方向有这种地方。'),
            ('FishingT', u'钓鱼'),
            ('BuildashelterT', u'建造庇护所'),
            ('MakeequipmentD', u'提高矮人的个人防护能力。制造保护性头盔、夹克或靴子，然后给矮人穿上。'),
            ('MakebedsT', u'造床'),
            ('GatherwaterT', u'收集水源'),
            ('MakeawoodenhatchT', u'制造一个木舱口'),
            ('UnderwaterworkT', u'水下作业'),
            ('CutthetreeT', u'砍 1 颗树'),
            ('SetelevatorT', u'放置电梯'),
            ('CollectacoalT', u'搜集煤炭'),
            ('MakeaswordT', u'制造一把剑'),
            ('CompleteashelterT', u'完成庇护所'),
            ('GiveanewweaponD', u"给矮人一个比刀子更强大的武器。点击<装备>图标并从仓库拖动任意武器到矮人的装备栏。"),
            ('MakeequipmentT', u'制造装备'),
            ('IncreasecomfortathomeD', u'矮人在温馨的家内恢复更快。因此在室内放置其他家具来提高庇护所的舒适值：椅子、窗户、梳妆台等。'),
            ('MakebedsD', u'矮人只能在庇护所内休息，但他们需要床。在庇护所内安装床。'),
            ('RepairtheportalT', u'修复传送门'),
            ('MakeawoodenhatchD', u'进入庇护所的入口只能建在外面，建造一个木制的舱口，可以盖住入口。'),
            ('ExploredeepD', u'许多矿物埋在地下深处。挖一个矿来探索更深的矿藏。'),
            ('CutthetreeD', u'木材是基本建材。标记待砍伐的树木。'),
            ('EnlargetheshelterD', u'扩建你的庇护所，让所有的矮人都有空间和床。'),
            ('SetelevatorD', u'为了加快矮人从生产区域到仓库的垂直移动，可以挖出一个竖井，并在顶部安装一个电梯。但是每个电梯都有深度限制。'),
            ('MakeaswordD', u'用挖掘出来的铁做一把剑，这是一种主要的近战武器。'),
            ('CompleteashelterD', u'完成庇护所之前在中央安置一根图腾，可以吓走怪物和邪灵。庇护所四面都必须砌墙，入口须设房门或外门。'),
            ('ShopingT', u'Shoping'),
            ('DigatunnelD', u'许多矿物都在地下深处。标记一列向下的方块来挖一条隧道。'),
            ('Cut30treesT', u'砍 30 颗树'),
            ('BuildrailwayT', u'建造一条轨道'),
            ('GatherwaterD', u'水是烹饪的必要原料，也是许多必需品的组成部分。做一个桶去取水。在那之后，你将能够标记可采集的水块。拥有多个桶将加快这一过程。'),
            ('Kill10skeletonsT', u'击杀 10 个骷髅'),
            ('CollectacoalD', u'寻找煤炭矿藏，你制造武器和烹饪食物的时候要用。'),
            ('CollectasandD', u'砂子用来建筑和制作玻璃。挖几个砂墩。砂子非常松软，所以得小心点，别把矮人埋了。'),
            ('IncreasecomfortathomeT', u'提高房屋的舒适值'),
            ('DigatunnelT', u'挖一条隧道。'),
            ('Cut30treesD', u'你需要大量木材来建造扶梯和家具。砍30颗树，存一些木材。'),
            ('CollectasandT', u'搜集砂子'),
            ('Kill10skeletonsD', u'击杀 10 个来犯骷髅，获取一些战斗经验。标记最近的骷髅这样矮人就会合而攻之。'),
            ('CollectstonesD', u'建造庇护所需要坚固的石墙来抵御怪物。搜集一些石头。')
        ]
        translateByDict(dom,tranDict)
        self.writeFile(filename,dom.toxml('UTF-8'))
 
    def translate(self):
        self.translateLocalXML()
        self.translateResourceXML()
        self.translateQuestXML()
         
 
if __name__ == '__main__':
    editor = Editor()
    #editor.editSkillTree()
    editor.editBlockXML()
    editor.editResourceXML()
    editor.editCreatureXML()
    editor.editItemXML()
    editor.editRecipeXML(2)
    editor.addRecipe({"name":"money","craft_need":"lab","group":"3","count":5,"ingredients":[None,"gold",None,None,"mithril",None,"gold",None,"gold"]})
    editor.editWorldXML({
        "mrainDownfall":"20-30",
        "rainDownfall":"15-20",
        "stormDownfall":"8-15",
        "stormSpeed":"9",
        "rainSpeed":"6",
        "mrainSpeed":"3",
        "LiftCapacity":"6",
        "MinMoneyStart":"10"
    })
    editor.translate()
    editor.editWaveXML()
    editor.close()