/*
 * Decompiled with CFR 0.152.
 */
package unstudio.chinacraft.util;

import java.util.HashMap;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import unstudio.chinacraft.ChinaCraft;
import unstudio.chinacraft.util.BlockRule;

public class BlocksChecker {
    public static final BlocksChecker Pottery_Kiln = new BlocksChecker(new String[][]{{"AAA", "AAA", "AAA"}, {"AAA", "ABA", "AAA"}, {"AAA", "AAA", "AAA"}}, Character.valueOf('A'), new BlockRule(ChinaCraft.blockFirebrick), Character.valueOf('B'), new BlockRule(Blocks.field_150350_a)).setOffset(0, 0, 0);
    private BlockRule[][][] data;
    private int widthX;
    private int widthZ;
    private int height;
    private int offsetX = 0;
    private int offsetZ = 0;
    private int offsetY = 0;

    private BlocksChecker() {
    }

    public BlocksChecker(String[][] data, Object ... args) {
        this.setRule(data, args);
    }

    public void setRule(String[][] blocks, Object ... args) {
        this.height = blocks.length;
        this.widthX = blocks[0].length;
        this.widthZ = blocks[0][0].length();
        HashMap<Character, BlockRule> target = new HashMap<Character, BlockRule>();
        Character key = null;
        for (Object arg : args) {
            if (key == null) {
                key = (Character)arg;
                continue;
            }
            target.put(key, (BlockRule)arg);
            key = null;
        }
        this.data = new BlockRule[this.height][this.widthX][this.widthZ];
        for (int y = 0; y < this.height; ++y) {
            String[] data = blocks[y];
            for (int z = 0; z < this.widthZ; ++z) {
                char[] array = data[z].toCharArray();
                for (int x = 0; x < this.widthX; ++x) {
                    char character = array[x];
                    if (character == ' ') continue;
                    this.data[y][z][x] = (BlockRule)target.get(Character.valueOf(character));
                }
            }
        }
    }

    public BlocksChecker setOffset(int x, int y, int z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public boolean check(World world, int X, int Y, int Z) {
        X += this.offsetX;
        Y += this.offsetY;
        Z += this.offsetZ;
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.widthZ; ++z) {
                for (int x = 0; x < this.widthX; ++x) {
                    BlockRule rule = this.data[y][z][x];
                    if (rule == null || rule.check(world, X + x, Y - y, Z + z)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public BlocksChecker copy() {
        BlocksChecker object = new BlocksChecker();
        object.data = this.data;
        return object;
    }

    public BlockRule[][][] getBlockRule() {
        return this.data;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidthX() {
        return this.widthX;
    }

    public int getWidthZ() {
        return this.widthZ;
    }
}

