/*
 * Decompiled with CFR 0.152.
 */
package unstudio.chinacraft.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import unstudio.chinacraft.inventory.GuiBuhrimill;
import unstudio.chinacraft.recipes.BuhrimillRecipe;

public class BuhrimillRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;
    public static HashSet<Block> efuels;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(71, 10, 22, 12), "milling", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBuhrimill.class;
    }

    public String getRecipeName() {
        return NEIClientUtils.translate((String)"gui.buhrimill.title", (Object[])new Object[0]);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("buhrimill") && ((Object)((Object)this)).getClass() == BuhrimillRecipeHandler.class) {
            ArrayList<BuhrimillRecipe> recipes = BuhrimillRecipe.getRecipes();
            for (BuhrimillRecipe recipe : recipes) {
                this.arecipes.add(new SmeltingPair(recipe.getInput1(), recipe.getInput2(), recipe.getInput2(), recipe.getOutput2()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        ArrayList<BuhrimillRecipe> recipes = BuhrimillRecipe.getRecipes();
        for (BuhrimillRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getOutput1(), (ItemStack)result)) continue;
            this.arecipes.add(new SmeltingPair(recipe.getInput1(), recipe.getOutput1(), recipe.getInput2(), recipe.getOutput2()));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == BuhrimillRecipeHandler.class) {
            this.loadCraftingRecipes("buhrimill", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList<BuhrimillRecipe> recipes = BuhrimillRecipe.getRecipes();
        for (BuhrimillRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getInput1(), (ItemStack)ingredient)) continue;
            SmeltingPair arecipe = new SmeltingPair(recipe.getInput1(), recipe.getOutput1(), recipe.getInput2(), recipe.getOutput2());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.input1), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    public String getGuiTexture() {
        return "chinacraft:textures/gui/nei/buhrimill.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(71, 10, 176, 14, 22, 12, 48, 0);
        this.drawProgressBar(76, 26, 176, 0, 14, 14, 48, 7);
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150466_ao));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        return efuels;
    }

    public String getOverlayIdentifier() {
        return "buhrimill";
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 0, 0, false);
            this.burnTime = burnTime;
        }
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input1;
        PositionedStack input2;
        PositionedStack output1;
        PositionedStack output2;

        public SmeltingPair(ItemStack in1, ItemStack out1, ItemStack in2, ItemStack out2) {
            super((TemplateRecipeHandler)BuhrimillRecipeHandler.this);
            in1.field_77994_a = 1;
            this.input1 = new PositionedStack((Object)in1, 38, 14);
            this.output1 = new PositionedStack((Object)out1, 107, 14);
            if (in2 != null) {
                this.input2 = new PositionedStack((Object)in2, 38, 28);
            }
            if (out2 != null) {
                this.output2 = new PositionedStack((Object)out2, 107, 28);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(BuhrimillRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input1));
        }

        public PositionedStack getResult() {
            return this.output1;
        }
    }
}

