/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WriteConfig {
    private static final String TOMCAT_PORT_PARAMETER_NAME = "tomcat_port";
    private static final String MYSQL_PORT_PARAMETER_NAME = "mysql_port";

    public static void main(String[] args) {
        String configCmdPath = args[0];
        String tomcatPath = args[1];
        String mysqlPath = args[2];
        if (configCmdPath == null || configCmdPath.equals("")) {
            System.out.println("\u672a\u6307\u5b9aconfig.cmd.");
            System.exit(1);
        }
        if (tomcatPath == null || tomcatPath.equals("")) {
            System.out.println("\u672a\u6307\u5b9atomcat_path.");
            System.exit(1);
        }
        if (mysqlPath == null || mysqlPath.equals("")) {
            System.out.println("\u672a\u6307\u5b9amysql_path.");
            System.exit(1);
        }
        String tomcatPort = "";
        try {
            String configPath = String.valueOf(tomcatPath) + "/conf/server.xml";
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(configPath));
            NodeList nodeList = document.getElementsByTagName("Connector");
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element = (Element)nodeList.item(i);
                if (element.getAttribute("protocol").equalsIgnoreCase("HTTP/1.1")) {
                    tomcatPort = element.getAttribute("port");
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String mysqlPort = "";
        try {
            String configPath = String.valueOf(mysqlPath) + "/my.ini";
            File configFile = new File(configPath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(configFile)));
            String line = null;
            block7: while ((line = bufferedReader.readLine()) != null) {
                String[] items;
                String[] stringArray = items = line.split("\\s");
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (item.equals("port")) {
                        mysqlPort = items[2];
                        continue block7;
                    }
                    ++n2;
                }
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Pattern tomcatPortPattern = Pattern.compile("\\s*set\\s+tomcat_port\\s*=\\s*\\d+\\s*", 2);
            Pattern mysqlPortPattern = Pattern.compile("\\s*set\\s+mysql_port\\s*=\\s*\\d+\\s*", 2);
            File configCmdFile = new File(configCmdPath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(configCmdFile)));
            StringBuffer stringBuffer = new StringBuffer();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (tomcatPortPattern.matcher(line).matches()) {
                    line = "set tomcat_port=" + tomcatPort;
                } else if (mysqlPortPattern.matcher(line).matches()) {
                    line = "set mysql_port=" + mysqlPort;
                }
                stringBuffer.append(String.valueOf(line) + "\r\n");
            }
            bufferedReader.close();
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(configCmdFile));
            printWriter.write(stringBuffer.toString());
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

