/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.client;

import com.sun.xml.internal.ws.client.ClientTransportException;
import com.sun.xml.internal.ws.transport.WSConnectionImpl;
import com.sun.xml.internal.ws.transport.http.client.CookieJar;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.soap.MessageFactory;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientTransport
extends WSConnectionImpl {
    private static String LAST_ENDPOINT = "";
    private static boolean redirect = true;
    private static final int START_REDIRECT_COUNT = 3;
    private static int redirectCount = 3;
    int statusCode;
    private Map<String, List<String>> respHeaders = null;
    private MessageFactory _messageFactory;
    HttpURLConnection httpConnection = null;
    String endpoint = null;
    Map<String, Object> context = null;
    CookieJar cookieJar = null;
    boolean isFailure = false;
    OutputStream _logStream = null;

    public HttpClientTransport() {
        this(null, new HashMap<String, Object>());
    }

    public HttpClientTransport(OutputStream outputStream, Map<String, Object> map) {
        this.context = map;
        this._logStream = outputStream;
        String string = (String)map.get("com.sun.xml.internal.ws.binding");
        try {
            if (string == null) {
                string = "http://schemas.xmlsoap.org/wsdl/soap/http";
            }
            this._messageFactory = string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") ? MessageFactory.newInstance("SOAP 1.2 Protocol") : MessageFactory.newInstance("SOAP 1.1 Protocol");
            this.endpoint = (String)map.get("javax.xml.ws.service.endpoint.address");
        }
        catch (Exception exception) {
            throw new ClientTransportException("http.client.cannotCreateMessageFactory", new Object[0]);
        }
    }

    @Override
    public OutputStream getOutput() {
        try {
            boolean bl;
            this.httpConnection = this.createHttpConnection(this.endpoint, this.context);
            this.cookieJar = this.sendCookieAsNeeded();
            String string = this.httpConnection.getRequestMethod();
            boolean bl2 = bl = "GET".equalsIgnoreCase(string) || "HEAD".equalsIgnoreCase(string) || "DELETE".equalsIgnoreCase(string);
            if (!bl) {
                this.outputStream = this.httpConnection.getOutputStream();
            }
            this.connectForResponse();
        }
        catch (Exception exception) {
            throw new ClientTransportException("http.client.failed", new Object[]{exception});
        }
        return this.outputStream;
    }

    @Override
    public InputStream getInput() {
        InputStream inputStream;
        try {
            inputStream = this.readResponse();
        }
        catch (IOException iOException) {
            if (this.statusCode == 204 || this.isFailure && this.statusCode != 500) {
                try {
                    throw new ClientTransportException("http.status.code", this.statusCode, this.httpConnection.getResponseMessage());
                }
                catch (IOException iOException2) {
                    throw new ClientTransportException("http.status.code", this.statusCode, iOException2);
                }
            }
            throw new ClientTransportException("http.client.failed", iOException.getMessage());
        }
        this.httpConnection = null;
        return inputStream;
    }

    @Override
    public OutputStream getDebug() {
        return this._logStream;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.respHeaders != null) {
            return this.respHeaders;
        }
        try {
            this.isFailure = this.checkResponseCode();
            this.respHeaders = this.collectResponseMimeHeaders();
            this.saveCookieAsNeeded(this.cookieJar);
            this.setHeaders(this.respHeaders);
            return this.respHeaders;
        }
        catch (IOException iOException) {
            if (this.statusCode == 204 || this.isFailure && this.statusCode != 500) {
                try {
                    throw new ClientTransportException("http.status.code", this.statusCode, this.httpConnection.getResponseMessage());
                }
                catch (IOException iOException2) {
                    throw new ClientTransportException("http.status.code", this.statusCode, iOException2);
                }
            }
            throw new ClientTransportException("http.client.failed", iOException.getMessage());
        }
    }

    protected InputStream readResponse() throws IOException {
        InputStream inputStream = this.isFailure ? this.httpConnection.getErrorStream() : this.httpConnection.getInputStream();
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        if (inputStream != null) {
            byteArrayBuffer.write(inputStream);
            byteArrayBuffer.close();
        }
        int n = this.httpConnection.getContentLength() == -1 ? byteArrayBuffer.size() : this.httpConnection.getContentLength();
        return byteArrayBuffer.newInputStream(0, n);
    }

    protected Map<String, List<String>> collectResponseMimeHeaders() {
        return this.httpConnection.getHeaderFields();
    }

    protected void connectForResponse() throws IOException {
        this.httpConnection.connect();
    }

    protected boolean checkResponseCode() throws IOException {
        boolean bl = false;
        try {
            this.statusCode = this.httpConnection.getResponseCode();
            this.setStatus(this.statusCode);
            if (this.httpConnection.getResponseCode() == 500) {
                bl = true;
            } else {
                if (this.httpConnection.getResponseCode() == 401) {
                    throw new ClientTransportException("http.client.unauthorized", this.httpConnection.getResponseMessage());
                }
                if (this.httpConnection.getResponseCode() == 404) {
                    throw new ClientTransportException("http.not.found", this.httpConnection.getResponseMessage());
                }
                if (this.statusCode == 302 || this.statusCode == 301) {
                    bl = true;
                    if (!redirect || redirectCount <= 0) {
                        throw new ClientTransportException("http.status.code", this.statusCode, this.getStatusMessage(this.httpConnection));
                    }
                } else {
                    if (this.statusCode < 200 || this.statusCode >= 303 && this.statusCode < 500) {
                        throw new ClientTransportException("http.status.code", this.statusCode, this.getStatusMessage(this.httpConnection));
                    }
                    if (this.statusCode >= 500) {
                        bl = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        return bl;
    }

    protected String getStatusMessage(HttpURLConnection httpURLConnection) throws IOException {
        String string;
        int n = httpURLConnection.getResponseCode();
        String string2 = httpURLConnection.getResponseMessage();
        if ((n == 201 || n >= 300 && n != 304 && n < 400) && (string = httpURLConnection.getHeaderField("Location")) != null) {
            string2 = string2 + " - Location: " + string;
        }
        return string2;
    }

    protected CookieJar sendCookieAsNeeded() {
        Boolean bl = (Boolean)this.context.get("javax.xml.ws.session.maintain");
        if (bl == null) {
            return null;
        }
        if (bl.booleanValue()) {
            CookieJar cookieJar = (CookieJar)this.context.get("com.sun.xml.internal.ws.client.http.CookieJar");
            if (cookieJar == null) {
                cookieJar = new CookieJar();
                BindingProvider bindingProvider = (BindingProvider)this.context.get("com.sun.xml.internal.ws.client.handle");
                bindingProvider.getRequestContext().put("com.sun.xml.internal.ws.client.http.CookieJar", cookieJar);
            }
            cookieJar.applyRelevantCookies(this.httpConnection);
            return cookieJar;
        }
        return null;
    }

    protected void saveCookieAsNeeded(CookieJar cookieJar) {
        if (cookieJar != null) {
            cookieJar.recordAnyCookies(this.httpConnection);
        }
    }

    protected HttpURLConnection createHttpConnection(String string, Map<String, Object> map) throws IOException {
        String string2;
        boolean bl = false;
        String string3 = (String)map.get("com.sun.xml.internal.ws.client.http.HostnameVerificationProperty");
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            bl = true;
        }
        if ((string2 = (String)map.get("com.sun.xml.internal.ws.client.http.RedirectRequestProperty")) != null && string2.equalsIgnoreCase("false")) {
            redirect = false;
        }
        this.checkEndpoints(string);
        HttpURLConnection httpURLConnection = this.createConnection(string);
        if (!bl && httpURLConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(new HttpClientVerifier());
        }
        httpURLConnection.setAllowUserInteraction(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        String string4 = "POST";
        String string5 = (String)map.get("javax.xml.ws.http.request.method");
        if (map.get("com.sun.xml.internal.ws.binding").equals("http://www.w3.org/2004/08/wsdl/http")) {
            string4 = string5 != null ? string5 : string4;
        } else if (map.get("com.sun.xml.internal.ws.binding").equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") && "GET".equalsIgnoreCase(string5)) {
            string4 = string5 != null ? string5 : string4;
        }
        httpURLConnection.setRequestMethod(string4);
        Integer n = (Integer)map.get("com.sun.xml.internal.ws.request.timeout");
        if (n != null) {
            httpURLConnection.setReadTimeout(n);
        }
        for (Map.Entry<String, List<String>> entry : super.getHeaders().entrySet()) {
            httpURLConnection.addRequestProperty(entry.getKey(), entry.getValue().get(0));
        }
        return httpURLConnection;
    }

    private HttpURLConnection createConnection(String string) throws IOException {
        return (HttpURLConnection)new URL(string).openConnection();
    }

    private boolean checkForRedirect(int n) {
        return (n == 301 || n == 302) && redirect && redirectCount-- > 0;
    }

    private void checkEndpoints(String string) {
        if (!LAST_ENDPOINT.equalsIgnoreCase(string)) {
            redirectCount = 3;
            LAST_ENDPOINT = string;
        }
    }

    static class HttpClientVerifier
    implements HostnameVerifier {
        HttpClientVerifier() {
        }

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }
}

