/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.Util;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.NotCompliantMBeanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MBeanAnalyzer<M> {
    private Map<String, List<M>> opMap = Util.newSortedMap();
    private Map<String, AttrMethods<M>> attrMap = Util.newSortedMap();

    void visit(MBeanVisitor<M> mBeanVisitor) {
        for (Map.Entry<String, AttrMethods<M>> entry : this.attrMap.entrySet()) {
            String string = entry.getKey();
            AttrMethods<Object> attrMethods = entry.getValue();
            mBeanVisitor.visitAttribute(string, (AttrMethods<AttrMethods<M>>)attrMethods.getter, (AttrMethods<AttrMethods<M>>)attrMethods.setter);
        }
        for (Map.Entry<String, Object> entry : this.opMap.entrySet()) {
            for (AttrMethods<Object> attrMethods : (List)entry.getValue()) {
                mBeanVisitor.visitOperation(entry.getKey(), attrMethods);
            }
        }
    }

    static <M> MBeanAnalyzer<M> analyzer(Class<?> clazz, MBeanIntrospector<M> mBeanIntrospector) throws NotCompliantMBeanException {
        return new MBeanAnalyzer<M>(clazz, mBeanIntrospector);
    }

    private MBeanAnalyzer(Class<?> clazz, MBeanIntrospector<M> mBeanIntrospector) throws NotCompliantMBeanException {
        if (!clazz.isInterface()) {
            throw new NotCompliantMBeanException("Not an interface: " + clazz.getName());
        }
        try {
            this.initMaps(clazz, mBeanIntrospector);
        }
        catch (Exception exception) {
            throw Introspector.throwException(clazz, exception);
        }
    }

    private void initMaps(Class<?> clazz, MBeanIntrospector<M> mBeanIntrospector) throws Exception {
        Object object;
        Object object2;
        Method[] methodArray = clazz.getMethods();
        List<Method> list = MBeanAnalyzer.eliminateCovariantMethods(methodArray);
        for (Method object3 : list) {
            Object object4;
            object2 = object3.getName();
            object = mBeanIntrospector.mFrom(object3);
            String string = "";
            if (((String)object2).startsWith("get")) {
                string = ((String)object2).substring(3);
            } else if (((String)object2).startsWith("is") && object3.getReturnType() == Boolean.TYPE) {
                string = ((String)object2).substring(2);
            }
            if (string.length() != 0 && object3.getParameterTypes().length == 0 && object3.getReturnType() != Void.TYPE) {
                object4 = this.attrMap.get(string);
                if (object4 == null) {
                    object4 = new AttrMethods();
                } else if (((AttrMethods)object4).getter != null) {
                    String string2 = "Attribute " + string + " has more than one getter";
                    throw new NotCompliantMBeanException(string2);
                }
                ((AttrMethods)object4).getter = object;
                this.attrMap.put(string, (AttrMethods<M>)object4);
                continue;
            }
            if (((String)object2).startsWith("set") && ((String)object2).length() > 3 && object3.getParameterTypes().length == 1 && object3.getReturnType() == Void.TYPE) {
                string = ((String)object2).substring(3);
                object4 = this.attrMap.get(string);
                if (object4 == null) {
                    object4 = new AttrMethods();
                } else if (((AttrMethods)object4).setter != null) {
                    String string3 = "Attribute " + string + " has more than one setter";
                    throw new NotCompliantMBeanException(string3);
                }
                ((AttrMethods)object4).setter = object;
                this.attrMap.put(string, (AttrMethods<M>)object4);
                continue;
            }
            object4 = this.opMap.get(object2);
            if (object4 == null) {
                object4 = Util.newList();
            }
            object4.add(object);
            this.opMap.put((String)object2, (List<M>)object4);
        }
        for (Map.Entry entry : this.attrMap.entrySet()) {
            object2 = (AttrMethods)entry.getValue();
            if (mBeanIntrospector.consistent(((AttrMethods)object2).getter, ((AttrMethods)object2).setter)) continue;
            object = "Getter and setter for " + (String)entry.getKey() + " have inconsistent types";
            throw new NotCompliantMBeanException((String)object);
        }
    }

    static List<Method> eliminateCovariantMethods(Method[] methodArray) {
        Map map = Util.newMap();
        for (Method method : methodArray) {
            List<Method> list = (List<Method>)map.get(method.getName());
            if (list == null) {
                list = Util.newList();
                map.put(method.getName(), list);
            }
            list.add(method);
        }
        Set set = Util.newSet();
        for (Collection collection : map.values()) {
            for (List<Method> list : collection) {
                for (Method method : collection) {
                    if (list == method || !MBeanAnalyzer.overrides((Method)((Object)list), method)) continue;
                    set.add(method);
                }
            }
        }
        List<Method> list = Util.newList(Arrays.asList(methodArray));
        list.removeAll(set);
        return list;
    }

    private static boolean overrides(Method method, Method method2) {
        Class<?>[] classArray;
        if (!method.getName().equals(method2.getName())) {
            return false;
        }
        Class<?> clazz = method.getDeclaringClass();
        Class<?> clazz2 = method2.getDeclaringClass();
        if (!clazz2.isAssignableFrom(clazz) || !method2.getReturnType().isAssignableFrom(method.getReturnType())) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (classArray2[i] == classArray[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttrMethods<M> {
        M getter;
        M setter;

        private AttrMethods() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface MBeanVisitor<M> {
        public void visitAttribute(String var1, M var2, M var3);

        public void visitOperation(String var1, M var2);
    }
}

