/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.CachedJarFile14;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.net.protocol.jar.Handler;
import com.sun.jnlp.JNLPClassLoader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.net.www.protocol.jar.JarURLConnection;

public class JNLPCachedJarURLConnection
extends JarURLConnection {
    private URL _jarFileURL = null;
    private String _entryName;
    private JarEntry _jarEntry;
    private JarFile _jarFile;
    private String _contentType;
    private boolean _useCachedJar = false;

    public JNLPCachedJarURLConnection(URL uRL, Handler handler) throws MalformedURLException, IOException {
        super(uRL, handler);
        this.getJarFileURL();
        this._entryName = this.getEntryName();
    }

    public URL getJarFileURL() {
        if (this._jarFileURL == null) {
            this._jarFileURL = super.getJarFileURL();
            try {
                this._jarFileURL = new URL(URLUtil.canonicalize((String)this._jarFileURL.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this._jarFileURL;
    }

    public JarFile getJarFile() throws IOException {
        this.connect();
        if (this._jarFile instanceof CachedJarFile) {
            try {
                return (JarFile)((CachedJarFile)this._jarFile).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IOException(cloneNotSupportedException.getMessage());
            }
        }
        if (this._jarFile instanceof CachedJarFile14) {
            try {
                return (JarFile)((CachedJarFile14)this._jarFile).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IOException(cloneNotSupportedException.getMessage());
            }
        }
        String string = this._jarFile.getName();
        if (new File(string).exists()) {
            JarFile jarFile = new JarFile(string);
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                manifest.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
            }
            return jarFile;
        }
        return this._jarFile;
    }

    private JarFile getJarFileInternal() throws IOException {
        this.connect();
        return this._jarFile;
    }

    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this._jarEntry;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            this._jarFile = JNLPClassLoader.getInstance().getJarFile(this._jarFileURL);
            if (this._jarFile != null) {
                this._useCachedJar = true;
            } else {
                super.connect();
                this._jarFile = super.getJarFile();
            }
            if (this._entryName != null) {
                this._jarEntry = this._jarFile.getJarEntry(this._entryName);
                if (this._jarEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this._entryName + " not found in " + this._jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this._useCachedJar) {
            Object var1_1 = null;
            if (this._entryName == null) {
                throw new IOException("no entry name specified");
            }
            if (this._jarEntry == null) {
                throw new FileNotFoundException("JAR entry " + this._entryName + " not found in " + this._jarFile.getName());
            }
            return this._jarFile.getInputStream(this._jarEntry);
        }
        return super.getInputStream();
    }

    public Object getContent() throws IOException {
        this.connect();
        if (this._useCachedJar && this._entryName == null) {
            return this.getJarFile();
        }
        return super.getContent();
    }

    public String getContentType() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._useCachedJar) {
            if (this._contentType == null) {
                if (this._entryName == null) {
                    this._contentType = "x-java/jar";
                } else {
                    try {
                        this.connect();
                        InputStream inputStream = this.getJarFileInternal().getInputStream(this._jarEntry);
                        this._contentType = JNLPCachedJarURLConnection.guessContentTypeFromStream(new BufferedInputStream(inputStream));
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this._contentType == null) {
                    this._contentType = JNLPCachedJarURLConnection.guessContentTypeFromName(this._entryName);
                }
                if (this._contentType == null) {
                    this._contentType = "content/unknown";
                }
            }
        } else {
            this._contentType = super.getContentType();
        }
        return this._contentType;
    }

    public int getContentLength() {
        if (this._useCachedJar) {
            return -1;
        }
        return super.getContentLength();
    }
}

