/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.tools.jconsole.JConsoleContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.Resources;

public class Plotter
extends JComponent
implements Accessible,
ActionListener,
PropertyChangeListener {
    static final String[] rangeNames = new String[]{Resources.getText(" 1 min", new Object[0]), Resources.getText(" 5 min", new Object[0]), Resources.getText("10 min", new Object[0]), Resources.getText("30 min", new Object[0]), Resources.getText(" 1 hour", new Object[0]), Resources.getText(" 2 hours", new Object[0]), Resources.getText(" 3 hours", new Object[0]), Resources.getText(" 6 hours", new Object[0]), Resources.getText("12 hours", new Object[0]), Resources.getText(" 1 day", new Object[0]), Resources.getText(" 7 days", new Object[0]), Resources.getText(" 1 month", new Object[0]), Resources.getText(" 3 months", new Object[0]), Resources.getText(" 6 months", new Object[0]), Resources.getText(" 1 year", new Object[0]), Resources.getText("All", new Object[0])};
    static final int[] rangeValues = new int[]{1, 5, 10, 30, 60, 120, 180, 360, 720, 1440, 10080, 44640, 133920, 267840, 527040, -1};
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final Color bgColor = new Color(250, 250, 250);
    static final Color defaultColor = Color.blue.darker();
    static final int ARRAY_SIZE_INCREMENT = 4000;
    private static Stroke dashedStroke;
    private TimeStamps times = new TimeStamps();
    private ArrayList<Sequence> seqs = new ArrayList();
    private JPopupMenu popupMenu;
    private JMenu timeRangeMenu;
    private JRadioButtonMenuItem[] menuRBs;
    private JMenuItem saveAsMI;
    private JFileChooser saveFC;
    private int viewRange = -1;
    private Unit unit;
    private Border border = null;
    private Rectangle r = new Rectangle(1, 1, 1, 1);
    private Font smallFont = null;
    private int topMargin = 10;
    private int bottomMargin = 45;
    private int leftMargin = 65;
    private int rightMargin = 70;

    public Plotter() {
        this(Unit.NONE);
    }

    public Plotter(Unit unit) {
        this.unit = unit;
        this.enableEvents(16L);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (Plotter.this.getParent() instanceof PlotterPanel) {
                    Plotter.this.getParent().requestFocusInWindow();
                }
            }
        });
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public void createSequence(String string, String string2, Color color, boolean bl) {
        Sequence sequence = this.getSequence(string);
        if (sequence == null) {
            sequence = new Sequence(string);
        }
        sequence.name = string2;
        sequence.color = color != null ? color : defaultColor;
        sequence.isPlotted = bl;
        this.seqs.add(sequence);
    }

    public void setUseDashedTransitions(String string, boolean bl) {
        Sequence sequence = this.getSequence(string);
        if (sequence != null) {
            sequence.transitionStroke = bl ? Plotter.getDashedStroke() : null;
        }
    }

    public void setIsPlotted(String string, boolean bl) {
        Sequence sequence = this.getSequence(string);
        if (sequence != null) {
            sequence.isPlotted = bl;
        }
    }

    public synchronized void addValues(long l, long ... lArray) {
        assert (lArray.length == this.seqs.size());
        this.times.add(l);
        for (int i = 0; i < lArray.length; ++i) {
            this.seqs.get(i).add(lArray[i]);
        }
        this.repaint();
    }

    private Sequence getSequence(String string) {
        for (Sequence sequence : this.seqs) {
            if (!sequence.key.equals(string)) continue;
            return sequence;
        }
        return null;
    }

    public int getViewRange() {
        return this.viewRange;
    }

    public void setViewRange(int n) {
        if (n != this.viewRange) {
            int n2 = this.viewRange;
            this.viewRange = n;
            this.firePropertyChange("viewRange", n2, this.viewRange);
            if (this.popupMenu != null) {
                for (int i = 0; i < this.menuRBs.length; ++i) {
                    if (rangeValues[i] != this.viewRange) continue;
                    this.menuRBs[i].setSelected(true);
                    break;
                }
            }
            this.repaint();
        }
    }

    public JPopupMenu getComponentPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu(Resources.getText("Chart:", new Object[0]));
            this.timeRangeMenu = new JMenu(Resources.getText("Plotter.timeRangeMenu", new Object[0]));
            this.timeRangeMenu.setMnemonic(Resources.getMnemonicInt("Plotter.timeRangeMenu"));
            this.popupMenu.add(this.timeRangeMenu);
            this.menuRBs = new JRadioButtonMenuItem[rangeNames.length];
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i = 0; i < rangeNames.length; ++i) {
                this.menuRBs[i] = new JRadioButtonMenuItem(rangeNames[i]);
                buttonGroup.add(this.menuRBs[i]);
                this.menuRBs[i].addActionListener(this);
                if (this.viewRange == rangeValues[i]) {
                    this.menuRBs[i].setSelected(true);
                }
                this.timeRangeMenu.add(this.menuRBs[i]);
            }
            this.popupMenu.addSeparator();
            this.saveAsMI = new JMenuItem(Resources.getText("Plotter.saveAsMenuItem", new Object[0]));
            this.saveAsMI.setMnemonic(Resources.getMnemonicInt("Plotter.saveAsMenuItem"));
            this.saveAsMI.addActionListener(this);
            this.popupMenu.add(this.saveAsMI);
        }
        return this.popupMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        if (jComponent == this.saveAsMI) {
            this.saveAs();
        } else {
            int n = this.timeRangeMenu.getPopupMenu().getComponentIndex(jComponent);
            this.setViewRange(rangeValues[n]);
        }
    }

    private void saveAs() {
        int n;
        if (this.saveFC == null) {
            this.saveFC = new SaveDataFileChooser();
        }
        if ((n = this.saveFC.showSaveDialog(this)) == 0) {
            this.saveDataToFile(this.saveFC.getSelectedFile());
        }
    }

    private void saveDataToFile(File file) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.print("Time");
            for (Sequence sequence : this.seqs) {
                printStream.print("," + sequence.name);
            }
            printStream.println();
            if (this.seqs.size() > 0 && this.seqs.get((int)0).size > 0) {
                for (int i = 0; i < this.seqs.get((int)0).size; ++i) {
                    double d = Formatter.toExcelTime(this.times.time(i));
                    printStream.print(String.format(Locale.ENGLISH, "%.6f", d));
                    for (Sequence sequence : this.seqs) {
                        printStream.print("," + sequence.value(i));
                    }
                    printStream.println();
                }
            }
            printStream.close();
            JOptionPane.showMessageDialog(this, Resources.getText("FileChooser.savedFile", file.getAbsolutePath(), file.length()));
        }
        catch (IOException iOException) {
            String string = iOException.getLocalizedMessage();
            String string2 = file.getAbsolutePath();
            if (string.startsWith(string2)) {
                string = string.substring(string2.length()).trim();
            }
            JOptionPane.showMessageDialog(this, Resources.getText("FileChooser.saveFailed.message", string2, string), Resources.getText("FileChooser.saveFailed.title", new Object[0]), 0);
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        Color color2 = this.getForeground();
        Color color3 = this.getBackground();
        boolean bl = color3.getRed() > 200 && color3.getGreen() > 200 && color3.getBlue() > 200;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.smallFont == null) {
            this.smallFont = font.deriveFont(9.0f);
        }
        this.r.x = this.leftMargin - 5;
        this.r.y = this.topMargin - 8;
        this.r.width = this.getWidth() - this.leftMargin - this.rightMargin;
        this.r.height = this.getHeight() - this.topMargin - this.bottomMargin + 16;
        if (this.border == null) {
            this.border = new BevelBorder(1, this.getBackground().brighter().brighter(), this.getBackground().brighter(), this.getBackground().darker().darker(), this.getBackground().darker());
        }
        this.border.paintBorder(this, graphics, this.r.x, this.r.y, this.r.width, this.r.height);
        graphics.setColor(bgColor);
        graphics.fillRect(this.r.x + 2, this.r.y + 2, this.r.width - 4, this.r.height - 4);
        graphics.setColor(color);
        long l = Long.MAX_VALUE;
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MAX_VALUE;
        long l4 = 1L;
        int n6 = this.getWidth() - this.rightMargin - this.leftMargin - 10;
        int n7 = this.getHeight() - this.topMargin - this.bottomMargin;
        if (this.times.size > 1) {
            l = Math.min(l, this.times.time(0));
            l2 = Math.max(l2, this.times.time(this.times.size - 1));
        }
        long l5 = this.viewRange > 0 ? (long)this.viewRange * 60000L : l2 - l;
        for (Sequence sequence : this.seqs) {
            if (sequence.size > 0) {
                for (int i = 0; i < sequence.size; ++i) {
                    long l6;
                    if (sequence.size != 1 && this.times.time(i) < l2 - l5 || (l6 = sequence.value(i)) <= Long.MIN_VALUE) continue;
                    l4 = Math.max(l4, l6);
                    l3 = Math.min(l3, l6);
                }
            } else {
                l3 = 0L;
            }
            if (this.unit != Unit.BYTES && sequence.isPlotted) continue;
            break;
        }
        l4 = this.normalizeMax(l4);
        if (l3 > 0L) {
            l3 = l4 / l3 > 4L ? 0L : this.normalizeMin(l3);
        }
        graphics.setColor(color2);
        int n8 = this.leftMargin - 18;
        int n9 = this.topMargin;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.getSizeString(l3, l4);
        String string2 = this.getSizeString(l4, l4);
        int n10 = n8 - 6 - fontMetrics.stringWidth(string);
        int n11 = n8 - 6 - fontMetrics.stringWidth(string2);
        if (this.checkLeftMargin(n10) || this.checkLeftMargin(n11)) {
            return;
        }
        graphics.drawString(string2, n11, n9 + 4);
        graphics.drawString(string, n10, n9 + n7 + 4);
        graphics.drawLine(n8, n9, n8, n9 + n7);
        graphics.drawLine(n8 - 5, n9, n8 + 5, n9);
        graphics.drawLine(n8 - 5, n9 + n7, n8 + 5, n9 + n7);
        int n12 = 5;
        if (("" + l4).startsWith("2")) {
            n12 = 4;
        } else if (("" + l4).startsWith("3")) {
            n12 = 6;
        } else if (("" + l4).startsWith("4")) {
            n12 = 4;
        } else if (("" + l4).startsWith("6")) {
            n12 = 6;
        } else if (("" + l4).startsWith("7")) {
            n12 = 7;
        } else if (("" + l4).startsWith("8")) {
            n12 = 8;
        } else if (("" + l4).startsWith("9")) {
            n12 = 3;
        }
        for (int i = 0; i < n12; ++i) {
            long l7 = (long)i * l4 / (long)n12;
            if (l7 <= l3) continue;
            n9 = this.topMargin + n7 - (int)((long)n7 * (l7 - l3) / (l4 - l3));
            graphics.drawLine(n8 - 2, n9, n8 + 2, n9);
            object = this.getSizeString(l7, l4);
            int n13 = n8 - 6 - fontMetrics.stringWidth((String)object);
            if (n9 < this.topMargin + n7 - 13) {
                if (this.checkLeftMargin(n13)) {
                    return;
                }
                graphics.drawString((String)object, n13, n9 + 4);
            }
            graphics.setColor(Color.lightGray);
            graphics.drawLine(this.r.x + 4, n9, this.r.x + this.r.width - 4, n9);
            graphics.setColor(color2);
        }
        n8 = this.leftMargin;
        n9 = this.topMargin + n7 + 15;
        graphics.drawLine(n8, n9, n8 + n6, n9);
        if (l2 > 0L) {
            long l8 = Formatter.timeDF.getTimeZone().getOffset(l2);
            long l9 = this.calculateTickInterval(n6, 40, l5);
            if (l9 > 10800000L) {
                l9 = this.calculateTickInterval(n6, 80, l5);
            }
            for (long i = l9 - (l2 - l5 + l8) % l9; i < l5; i += l9) {
                n8 = this.leftMargin + (int)((long)n6 * i / l5);
                graphics.drawLine(n8, n9 - 2, n8, n9 + 2);
                long l10 = l2 - l5 + i;
                String string3 = Formatter.formatClockTime(l10);
                graphics.drawString(string3, n8, n9 + 16);
                if ((l10 + l8) % 86400000L == 0L) {
                    string3 = Formatter.formatDate(l10);
                    graphics.drawString(string3, n8, n9 + 27);
                }
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n8, this.topMargin, n8, this.topMargin + n7);
                graphics.setColor(color2);
            }
        }
        int n14 = 0;
        n10 = 0;
        n11 = this.seqs.size();
        if (n11 > 0) {
            n10 = this.seqs.get((int)0).size;
        }
        if (n10 == 0) {
            graphics.setColor(color);
            return;
        }
        object = this.seqs.get(0);
        for (n5 = 0; n5 < ((Sequence)object).size; ++n5) {
            if (this.times.time(n5) < l2 - l5) continue;
            n14 = n5;
            break;
        }
        if ((n4 = (n10 - n14) / n6) < 4) {
            n4 = 1;
        }
        for (n5 = n11 - 1; n5 >= 0; --n5) {
            n3 = this.leftMargin;
            int n15 = this.topMargin + n7 + 1;
            Sequence sequence = this.seqs.get(n5);
            if (!sequence.isPlotted || sequence.size <= 0) continue;
            for (int i = 0; i < 2; ++i) {
                graphics.setColor(i == 0 ? Color.white : sequence.color);
                n2 = -1;
                long l11 = -1L;
                for (int j = n14; j < n10; j += n4) {
                    if (n4 > 1 && j >= n10 - n4) {
                        j = n10 - 1;
                    }
                    n = l5 == 0L ? 0 : (int)((long)n6 * (this.times.time(j) - (l2 - l5)) / l5);
                    long l12 = sequence.value(j);
                    if (l12 >= l3 && l12 <= l4) {
                        int n16 = (int)((long)n7 * (l12 - l3) / (l4 - l3));
                        if (n2 >= 0 && l11 >= l3 && l11 <= l4) {
                            int n17 = (int)((long)n7 * (l11 - l3) / (l4 - l3));
                            if (n17 == n16) {
                                graphics.fillRect(n3 + n2, n15 - n17 - i, n - n2, 1);
                            } else {
                                Graphics2D graphics2D = (Graphics2D)graphics;
                                Stroke stroke = null;
                                if (sequence.transitionStroke != null) {
                                    stroke = graphics2D.getStroke();
                                    graphics2D.setStroke(sequence.transitionStroke);
                                }
                                graphics.drawLine(n3 + n2, n15 - n17 - i, n3 + n, n15 - n16 - i);
                                if (stroke != null) {
                                    graphics2D.setStroke(stroke);
                                }
                            }
                        } else if (sequence.size == 1) {
                            graphics.fillRect(n3, n15 - n16 - i, n6, 1);
                        }
                    }
                    n2 = n;
                    l11 = l12;
                }
            }
            long l13 = sequence.value(sequence.size - 1);
            if (l13 >= l3 && l13 <= l4) {
                if (bl) {
                    graphics.setColor(sequence.color);
                } else {
                    graphics.setColor(color2);
                }
                n8 = this.r.x + this.r.width + 2;
                n9 = this.topMargin + n7 - (int)((long)n7 * (l13 - l3) / (l4 - l3));
                graphics.fillPolygon(new int[]{n8 + 2, n8 + 6, n8 + 6}, new int[]{n9, n9 + 3, n9 - 3}, 3);
            }
            graphics.setColor(color2);
        }
        int[] nArray = new int[n11];
        for (n3 = 0; n3 < n11; ++n3) {
            nArray[n3] = -1;
        }
        for (n3 = 0; n3 < n11; ++n3) {
            Sequence sequence = this.seqs.get(n3);
            if (!sequence.isPlotted || sequence.size <= 0) continue;
            long l14 = sequence.value(sequence.size - 1);
            if (l14 >= l3 && l14 <= l4) {
                n8 = this.r.x + this.r.width + 2;
                n9 = this.topMargin + n7 - (int)((long)n7 * (l14 - l3) / (l4 - l3));
                n2 = this.getValueStringSlot(nArray, n9, 20, n3);
                graphics.setFont(this.smallFont);
                if (bl) {
                    graphics.setColor(sequence.color);
                } else {
                    graphics.setColor(color2);
                }
                String string4 = this.unit == Unit.PERCENT ? l14 + "%" : String.format("%,d", l14);
                int n18 = fontMetrics.stringWidth(string4);
                String string5 = sequence.name;
                n = fontMetrics.stringWidth(string5);
                if (this.checkRightMargin(n18) || this.checkRightMargin(n)) {
                    return;
                }
                graphics.drawString(string5, n8 + 17, Math.min(this.topMargin + n7, n2 + 3 - 10));
                graphics.drawString(string4, n8 + 17, Math.min(this.topMargin + n7 + 10, n2 + 3));
                if (n2 > n9 + 3) {
                    graphics.drawLine(n8 + 9, n9 + 2, n8 + 14, n2);
                } else if (n2 < n9 - 3) {
                    graphics.drawLine(n8 + 9, n9 - 2, n8 + 14, n2);
                }
            }
            graphics.setFont(font);
            graphics.setColor(color2);
        }
        graphics.setColor(color);
    }

    private boolean checkLeftMargin(int n) {
        if (n < 2) {
            this.leftMargin += 2 - n;
            this.repaint();
            return true;
        }
        return false;
    }

    private boolean checkRightMargin(int n) {
        if (n + 2 > this.rightMargin) {
            this.rightMargin = n + 2;
            this.repaint();
            return true;
        }
        return false;
    }

    private int getValueStringSlot(int[] nArray, int n, int n2, int n3) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n && nArray[i] < n + n2) {
                if (nArray[i] > n2) {
                    return this.getValueStringSlot(nArray, nArray[i] - n2, n2, n3);
                }
                return this.getValueStringSlot(nArray, nArray[i] + n2, n2, n3);
            }
            if (n < n2 || nArray[i] <= n - n2 || nArray[i] >= n) continue;
            return this.getValueStringSlot(nArray, nArray[i] + n2, n2, n3);
        }
        nArray[n3] = n;
        return n;
    }

    private long calculateTickInterval(int n, int n2, long l) {
        long l2 = l * (long)n2 / (long)n;
        l2 = l2 < 60000L ? 60000L : (l2 < 300000L ? 300000L : (l2 < 600000L ? 600000L : (l2 < 1800000L ? 1800000L : (l2 < 3600000L ? 3600000L : (l2 < 10800000L ? 10800000L : (l2 < 21600000L ? 21600000L : (l2 < 43200000L ? 43200000L : (l2 < 86400000L ? 86400000L : this.normalizeMax(l2 / 86400000L) * 86400000L))))))));
        return l2;
    }

    private long normalizeMin(long l) {
        int n = (int)Math.log10(l);
        long l2 = (long)Math.pow(10.0, n);
        int n2 = (int)(l / l2);
        return (long)n2 * l2;
    }

    private long normalizeMax(long l) {
        int n = (int)Math.log10(l);
        long l2 = (long)Math.pow(10.0, n);
        int n2 = (int)(l / l2);
        l = (long)(n2 + 1) * l2;
        return l;
    }

    private String getSizeString(long l, long l2) {
        String string;
        switch (this.unit) {
            case BYTES: {
                string = Formatter.formatBytes(l, l2);
                break;
            }
            case PERCENT: {
                string = l + "%";
                break;
            }
            default: {
                string = String.format("%,d", l);
            }
        }
        return string;
    }

    private static synchronized Stroke getDashedStroke() {
        if (dashedStroke == null) {
            dashedStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f, 3.0f}, 0.0f);
        }
        return dashedStroke;
    }

    private static Object extendArray(Object object) {
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n + 4000);
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    long getValue() {
        return 0L;
    }

    long getLastTimeStamp() {
        return this.times.time(this.times.size - 1);
    }

    long getLastValue(String string) {
        Sequence sequence = this.getSequence(string);
        return sequence != null && sequence.size > 0 ? sequence.value(sequence.size - 1) : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "connectionState") {
            JConsoleContext.ConnectionState connectionState = (JConsoleContext.ConnectionState)((Object)propertyChangeEvent.getNewValue());
            switch (connectionState) {
                case DISCONNECTED: {
                    Plotter plotter = this;
                    synchronized (plotter) {
                        long l = System.currentTimeMillis();
                        this.times.add(l);
                        for (Sequence sequence : this.seqs) {
                            sequence.add(Long.MIN_VALUE);
                        }
                        break;
                    }
                }
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePlotter();
        }
        return this.accessibleContext;
    }

    protected class AccessiblePlotter
    extends JComponent.AccessibleJComponent {
        protected AccessiblePlotter() {
            super(Plotter.this);
            this.setAccessibleName(Resources.getText("Plotter.accessibleName", new Object[0]));
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (Plotter.this.seqs.size() > 0 && ((Sequence)((Plotter)Plotter.this).seqs.get((int)0)).size > 0) {
                String string2 = "";
                for (Sequence sequence : Plotter.this.seqs) {
                    if (!sequence.isPlotted) continue;
                    String string3 = "null";
                    if (sequence.size > 0) {
                        string3 = "" + sequence.value(sequence.size - 1);
                        if (Plotter.this.unit == Unit.PERCENT) {
                            string3 = string3 + "%";
                        } else if (Plotter.this.unit == Unit.BYTES) {
                            string3 = Resources.getText("Size Bytes", sequence.value(sequence.size - 1));
                        }
                    }
                    string2 = string2 + Resources.getText("Plotter.accessibleName.keyAndValue", sequence.key, string3);
                }
                string = string + "\n" + string2 + ".";
            } else {
                string = string + "\n" + Resources.getText("Plotter.accessibleName.noData", new Object[0]);
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CANVAS;
        }
    }

    private static class SaveDataFileChooser
    extends JFileChooser {
        SaveDataFileChooser() {
            this.setFileFilter(new FileNameExtensionFilter("CSV file", "csv"));
        }

        public void approveSelection() {
            File file = this.getSelectedFile();
            if (file != null) {
                Object object;
                FileFilter fileFilter = this.getFileFilter();
                if (fileFilter != null && fileFilter instanceof FileNameExtensionFilter) {
                    object = ((FileNameExtensionFilter)fileFilter).getExtensions();
                    boolean bl = false;
                    for (String string : object) {
                        if (!file.getName().toLowerCase().endsWith("." + string.toLowerCase())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        file = new File(file.getParent(), file.getName() + "." + object[0]);
                    }
                }
                if (file.exists()) {
                    object = Resources.getText("FileChooser.fileExists.okOption", new Object[0]);
                    String string = Resources.getText("FileChooser.fileExists.cancelOption", new Object[0]);
                    int n = JOptionPane.showOptionDialog(this, Resources.getText("FileChooser.fileExists.message", file.getName()), Resources.getText("FileChooser.fileExists.title", new Object[0]), 2, 2, null, new Object[]{object, string}, object);
                    if (n != 0) {
                        return;
                    }
                }
                this.setSelectedFile(file);
            }
            super.approveSelection();
        }
    }

    private static class Sequence {
        String key;
        String name;
        Color color;
        boolean isPlotted;
        Stroke transitionStroke = null;
        Object values = new byte[4000 + (int)(Math.random() * 100.0)];
        int size = 0;

        public Sequence(String string) {
            this.key = string;
        }

        public long value(int n) {
            return Array.getLong(this.values, n);
        }

        public void add(long l) {
            if ((this.values instanceof byte[] || this.values instanceof short[] || this.values instanceof int[]) && l > Integer.MAX_VALUE) {
                long[] lArray = new long[Array.getLength(this.values)];
                for (int i = 0; i < this.size; ++i) {
                    lArray[i] = Array.getLong(this.values, i);
                }
                this.values = lArray;
            } else if ((this.values instanceof byte[] || this.values instanceof short[]) && l > 32767L) {
                int[] nArray = new int[Array.getLength(this.values)];
                for (int i = 0; i < this.size; ++i) {
                    nArray[i] = Array.getInt(this.values, i);
                }
                this.values = nArray;
            } else if (this.values instanceof byte[] && l > 127L) {
                short[] sArray = new short[Array.getLength(this.values)];
                for (int i = 0; i < this.size; ++i) {
                    sArray[i] = Array.getShort(this.values, i);
                }
                this.values = sArray;
            }
            if (Array.getLength(this.values) == this.size) {
                this.values = Plotter.extendArray(this.values);
            }
            if (this.values instanceof long[]) {
                ((long[])this.values)[this.size] = l;
            } else if (this.values instanceof int[]) {
                ((int[])this.values)[this.size] = (int)l;
            } else if (this.values instanceof short[]) {
                ((short[])this.values)[this.size] = (short)l;
            } else {
                ((byte[])this.values)[this.size] = (byte)l;
            }
            ++this.size;
        }
    }

    private static class TimeStamps {
        long[] offsets = new long[0];
        int[] indices = new int[0];
        int[] rtimes = new int[4000];
        int size = 0;

        private TimeStamps() {
        }

        public long time(int n) {
            long l = 0L;
            for (int i = this.indices.length - 1; i >= 0; --i) {
                if (n < this.indices[i]) continue;
                l = this.offsets[i];
                break;
            }
            return l + (long)this.rtimes[n];
        }

        public void add(long l) {
            int n = this.offsets.length;
            if (n == 0 || l - this.offsets[n - 1] > Integer.MAX_VALUE) {
                this.offsets = Arrays.copyOf(this.offsets, n + 1);
                this.offsets[n] = l;
                this.indices = Arrays.copyOf(this.indices, n + 1);
                this.indices[n] = this.size;
            }
            if (this.rtimes.length == this.size) {
                this.rtimes = (int[])Plotter.extendArray(this.rtimes);
            }
            this.rtimes[this.size] = (int)(l - this.offsets[this.offsets.length - 1]);
            ++this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Unit {
        NONE,
        BYTES,
        PERCENT;

    }
}

