/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import java.util.ArrayList;
import java.util.List;
import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;

public class SwitchCase
extends AstNode {
    private AstNode expression;
    private List<AstNode> statements;

    public SwitchCase() {
        this.type = 115;
    }

    public SwitchCase(int n) {
        super(n);
        this.type = 115;
    }

    public SwitchCase(int n, int n2) {
        super(n, n2);
        this.type = 115;
    }

    public AstNode getExpression() {
        return this.expression;
    }

    public void setExpression(AstNode astNode) {
        this.expression = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public boolean isDefault() {
        return this.expression == null;
    }

    public List<AstNode> getStatements() {
        return this.statements;
    }

    public void setStatements(List<AstNode> list) {
        if (this.statements != null) {
            this.statements.clear();
        }
        for (AstNode astNode : list) {
            this.addStatement(astNode);
        }
    }

    public void addStatement(AstNode astNode) {
        this.assertNotNull(astNode);
        if (this.statements == null) {
            this.statements = new ArrayList<AstNode>();
        }
        int n = astNode.getPosition() + astNode.getLength();
        this.setLength(n - this.getPosition());
        this.statements.add(astNode);
        astNode.setParent(this);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        if (this.expression == null) {
            stringBuilder.append("default:\n");
        } else {
            stringBuilder.append("case ");
            stringBuilder.append(this.expression.toSource(0));
            stringBuilder.append(":\n");
        }
        if (this.statements != null) {
            for (AstNode astNode : this.statements) {
                stringBuilder.append(astNode.toSource(n + 1));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            if (this.expression != null) {
                this.expression.visit(nodeVisitor);
            }
            if (this.statements != null) {
                for (AstNode astNode : this.statements) {
                    astNode.visit(nodeVisitor);
                }
            }
        }
    }
}

