/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.util.transform;

import com.sun.xml.internal.messaging.saaj.util.FastInfosetReflection;
import com.sun.xml.internal.messaging.saaj.util.XMLDeclarationParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class EfficientStreamingTransformer
extends Transformer {
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Transformer m_realTransformer = null;
    private Object m_fiDOMDocumentParser = null;
    private Object m_fiDOMDocumentSerializer = null;

    private EfficientStreamingTransformer() {
    }

    private void materialize() throws TransformerException {
        if (this.m_realTransformer == null) {
            this.m_realTransformer = this.transformerFactory.newTransformer();
        }
    }

    @Override
    public void clearParameters() {
        if (this.m_realTransformer != null) {
            this.m_realTransformer.clearParameters();
        }
    }

    @Override
    public ErrorListener getErrorListener() {
        try {
            this.materialize();
            return this.m_realTransformer.getErrorListener();
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    @Override
    public Properties getOutputProperties() {
        try {
            this.materialize();
            return this.m_realTransformer.getOutputProperties();
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    @Override
    public String getOutputProperty(String string) throws IllegalArgumentException {
        try {
            this.materialize();
            return this.m_realTransformer.getOutputProperty(string);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    @Override
    public Object getParameter(String string) {
        try {
            this.materialize();
            return this.m_realTransformer.getParameter(string);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    @Override
    public URIResolver getURIResolver() {
        try {
            this.materialize();
            return this.m_realTransformer.getURIResolver();
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        try {
            this.materialize();
            this.m_realTransformer.setErrorListener(errorListener);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Override
    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        try {
            this.materialize();
            this.m_realTransformer.setOutputProperties(properties);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Override
    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        try {
            this.materialize();
            this.m_realTransformer.setOutputProperty(string, string2);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Override
    public void setParameter(String string, Object object) {
        try {
            this.materialize();
            this.m_realTransformer.setParameter(string, object);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Override
    public void setURIResolver(URIResolver uRIResolver) {
        try {
            this.materialize();
            this.m_realTransformer.setURIResolver(uRIResolver);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    private InputStream getInputStreamFromSource(StreamSource streamSource) throws TransformerException {
        InputStream inputStream = streamSource.getInputStream();
        if (inputStream != null) {
            return inputStream;
        }
        if (streamSource.getReader() != null) {
            return null;
        }
        String string = streamSource.getSystemId();
        if (string != null) {
            try {
                String string2 = string;
                if (string.startsWith("file:///")) {
                    String string3;
                    String string4 = string.substring(7);
                    boolean bl = string4.indexOf(":") > 0;
                    string2 = bl ? (string3 = string4.substring(1)) : string4;
                }
                try {
                    return new FileInputStream(new File(new URI(string2)));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new TransformerException(uRISyntaxException);
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException.toString());
            }
        }
        throw new TransformerException("Unexpected StreamSource object");
    }

    @Override
    public void transform(Source source, Result result) throws TransformerException {
        if (source instanceof StreamSource && result instanceof StreamResult) {
            block21: {
                try {
                    int n;
                    StreamSource streamSource = (StreamSource)source;
                    InputStream inputStream = this.getInputStreamFromSource(streamSource);
                    OutputStream outputStream = ((StreamResult)result).getOutputStream();
                    if (outputStream == null) {
                        throw new TransformerException("Unexpected StreamResult object contains null OutputStream");
                    }
                    if (inputStream != null) {
                        int n2;
                        if (inputStream.markSupported()) {
                            inputStream.mark(Integer.MAX_VALUE);
                        }
                        byte[] byArray = new byte[8192];
                        while ((n2 = inputStream.read(byArray)) != -1) {
                            outputStream.write(byArray, 0, n2);
                        }
                        if (inputStream.markSupported()) {
                            inputStream.reset();
                        }
                        return;
                    }
                    Reader reader = streamSource.getReader();
                    if (reader == null) break block21;
                    if (reader.markSupported()) {
                        reader.mark(Integer.MAX_VALUE);
                    }
                    PushbackReader pushbackReader = new PushbackReader(reader, 4096);
                    XMLDeclarationParser xMLDeclarationParser = new XMLDeclarationParser(pushbackReader);
                    try {
                        xMLDeclarationParser.parse();
                    }
                    catch (Exception exception) {
                        throw new TransformerException("Unable to run the JAXP transformer on a stream " + exception.getMessage());
                    }
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                    xMLDeclarationParser.writeTo(outputStreamWriter);
                    char[] cArray = new char[8192];
                    while ((n = pushbackReader.read(cArray)) != -1) {
                        ((Writer)outputStreamWriter).write(cArray, 0, n);
                    }
                    ((Writer)outputStreamWriter).flush();
                    if (reader.markSupported()) {
                        reader.reset();
                    }
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new TransformerException(iOException.toString());
                }
            }
            throw new TransformerException("Unexpected StreamSource object");
        }
        if (FastInfosetReflection.isFastInfosetSource(source) && result instanceof DOMResult) {
            try {
                if (this.m_fiDOMDocumentParser == null) {
                    this.m_fiDOMDocumentParser = FastInfosetReflection.DOMDocumentParser_new();
                }
                FastInfosetReflection.DOMDocumentParser_parse(this.m_fiDOMDocumentParser, (Document)((DOMResult)result).getNode(), FastInfosetReflection.FastInfosetSource_getInputStream(source));
                return;
            }
            catch (Exception exception) {
                throw new TransformerException(exception);
            }
        }
        if (source instanceof DOMSource && FastInfosetReflection.isFastInfosetResult(result)) {
            try {
                if (this.m_fiDOMDocumentSerializer == null) {
                    this.m_fiDOMDocumentSerializer = FastInfosetReflection.DOMDocumentSerializer_new();
                }
                FastInfosetReflection.DOMDocumentSerializer_setOutputStream(this.m_fiDOMDocumentSerializer, FastInfosetReflection.FastInfosetResult_getOutputStream(result));
                FastInfosetReflection.DOMDocumentSerializer_serialize(this.m_fiDOMDocumentSerializer, ((DOMSource)source).getNode());
                return;
            }
            catch (Exception exception) {
                throw new TransformerException(exception);
            }
        }
        this.materialize();
        this.m_realTransformer.transform(source, result);
    }

    public static Transformer newTransformer() {
        return new EfficientStreamingTransformer();
    }
}

