/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.compiler;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xml.internal.utils.QName;
import com.sun.org.apache.xml.internal.utils.SAXSourceLocator;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.axes.LocPathIterator;
import com.sun.org.apache.xpath.internal.axes.UnionPathIterator;
import com.sun.org.apache.xpath.internal.axes.WalkerFactory;
import com.sun.org.apache.xpath.internal.compiler.FunctionTable;
import com.sun.org.apache.xpath.internal.compiler.OpMap;
import com.sun.org.apache.xpath.internal.functions.FuncExtFunction;
import com.sun.org.apache.xpath.internal.functions.FuncExtFunctionAvailable;
import com.sun.org.apache.xpath.internal.functions.Function;
import com.sun.org.apache.xpath.internal.functions.WrongNumberArgsException;
import com.sun.org.apache.xpath.internal.objects.XNumber;
import com.sun.org.apache.xpath.internal.objects.XString;
import com.sun.org.apache.xpath.internal.operations.And;
import com.sun.org.apache.xpath.internal.operations.Bool;
import com.sun.org.apache.xpath.internal.operations.Div;
import com.sun.org.apache.xpath.internal.operations.Equals;
import com.sun.org.apache.xpath.internal.operations.Gt;
import com.sun.org.apache.xpath.internal.operations.Gte;
import com.sun.org.apache.xpath.internal.operations.Lt;
import com.sun.org.apache.xpath.internal.operations.Lte;
import com.sun.org.apache.xpath.internal.operations.Minus;
import com.sun.org.apache.xpath.internal.operations.Mod;
import com.sun.org.apache.xpath.internal.operations.Mult;
import com.sun.org.apache.xpath.internal.operations.Neg;
import com.sun.org.apache.xpath.internal.operations.NotEquals;
import com.sun.org.apache.xpath.internal.operations.Number;
import com.sun.org.apache.xpath.internal.operations.Operation;
import com.sun.org.apache.xpath.internal.operations.Or;
import com.sun.org.apache.xpath.internal.operations.Plus;
import com.sun.org.apache.xpath.internal.operations.UnaryOperation;
import com.sun.org.apache.xpath.internal.operations.Variable;
import com.sun.org.apache.xpath.internal.patterns.FunctionPattern;
import com.sun.org.apache.xpath.internal.patterns.StepPattern;
import com.sun.org.apache.xpath.internal.patterns.UnionPattern;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;

public class Compiler
extends OpMap {
    private int locPathDepth = -1;
    private static final boolean DEBUG = false;
    private static long s_nextMethodId = 0L;
    private PrefixResolver m_currentPrefixResolver = null;
    ErrorListener m_errorHandler;
    SourceLocator m_locator;
    private FunctionTable m_functionTable;

    public Compiler(ErrorListener errorListener, SourceLocator sourceLocator, FunctionTable functionTable) {
        this.m_errorHandler = errorListener;
        this.m_locator = sourceLocator;
        this.m_functionTable = functionTable;
    }

    public Compiler() {
        this.m_errorHandler = null;
        this.m_locator = null;
    }

    public Expression compile(int n) throws TransformerException {
        int n2 = this.getOp(n);
        Expression expression = null;
        switch (n2) {
            case 1: {
                expression = this.compile(n + 2);
                break;
            }
            case 2: {
                expression = this.or(n);
                break;
            }
            case 3: {
                expression = this.and(n);
                break;
            }
            case 4: {
                expression = this.notequals(n);
                break;
            }
            case 5: {
                expression = this.equals(n);
                break;
            }
            case 6: {
                expression = this.lte(n);
                break;
            }
            case 7: {
                expression = this.lt(n);
                break;
            }
            case 8: {
                expression = this.gte(n);
                break;
            }
            case 9: {
                expression = this.gt(n);
                break;
            }
            case 10: {
                expression = this.plus(n);
                break;
            }
            case 11: {
                expression = this.minus(n);
                break;
            }
            case 12: {
                expression = this.mult(n);
                break;
            }
            case 13: {
                expression = this.div(n);
                break;
            }
            case 14: {
                expression = this.mod(n);
                break;
            }
            case 16: {
                expression = this.neg(n);
                break;
            }
            case 17: {
                expression = this.string(n);
                break;
            }
            case 18: {
                expression = this.bool(n);
                break;
            }
            case 19: {
                expression = this.number(n);
                break;
            }
            case 20: {
                expression = this.union(n);
                break;
            }
            case 21: {
                expression = this.literal(n);
                break;
            }
            case 22: {
                expression = this.variable(n);
                break;
            }
            case 23: {
                expression = this.group(n);
                break;
            }
            case 27: {
                expression = this.numberlit(n);
                break;
            }
            case 26: {
                expression = this.arg(n);
                break;
            }
            case 24: {
                expression = this.compileExtension(n);
                break;
            }
            case 25: {
                expression = this.compileFunction(n);
                break;
            }
            case 28: {
                expression = this.locationPath(n);
                break;
            }
            case 29: {
                expression = null;
                break;
            }
            case 30: {
                expression = this.matchPattern(n + 2);
                break;
            }
            case 31: {
                expression = this.locationPathPattern(n);
                break;
            }
            case 15: {
                this.error("ER_UNKNOWN_OPCODE", new Object[]{"quo"});
                break;
            }
            default: {
                this.error("ER_UNKNOWN_OPCODE", new Object[]{Integer.toString(this.getOp(n))});
            }
        }
        return expression;
    }

    private Expression compileOperation(Operation operation, int n) throws TransformerException {
        int n2 = Compiler.getFirstChildPos(n);
        int n3 = this.getNextOpPos(n2);
        operation.setLeftRight(this.compile(n2), this.compile(n3));
        return operation;
    }

    private Expression compileUnary(UnaryOperation unaryOperation, int n) throws TransformerException {
        int n2 = Compiler.getFirstChildPos(n);
        unaryOperation.setRight(this.compile(n2));
        return unaryOperation;
    }

    protected Expression or(int n) throws TransformerException {
        return this.compileOperation(new Or(), n);
    }

    protected Expression and(int n) throws TransformerException {
        return this.compileOperation(new And(), n);
    }

    protected Expression notequals(int n) throws TransformerException {
        return this.compileOperation(new NotEquals(), n);
    }

    protected Expression equals(int n) throws TransformerException {
        return this.compileOperation(new Equals(), n);
    }

    protected Expression lte(int n) throws TransformerException {
        return this.compileOperation(new Lte(), n);
    }

    protected Expression lt(int n) throws TransformerException {
        return this.compileOperation(new Lt(), n);
    }

    protected Expression gte(int n) throws TransformerException {
        return this.compileOperation(new Gte(), n);
    }

    protected Expression gt(int n) throws TransformerException {
        return this.compileOperation(new Gt(), n);
    }

    protected Expression plus(int n) throws TransformerException {
        return this.compileOperation(new Plus(), n);
    }

    protected Expression minus(int n) throws TransformerException {
        return this.compileOperation(new Minus(), n);
    }

    protected Expression mult(int n) throws TransformerException {
        return this.compileOperation(new Mult(), n);
    }

    protected Expression div(int n) throws TransformerException {
        return this.compileOperation(new Div(), n);
    }

    protected Expression mod(int n) throws TransformerException {
        return this.compileOperation(new Mod(), n);
    }

    protected Expression neg(int n) throws TransformerException {
        return this.compileUnary(new Neg(), n);
    }

    protected Expression string(int n) throws TransformerException {
        return this.compileUnary(new com.sun.org.apache.xpath.internal.operations.String(), n);
    }

    protected Expression bool(int n) throws TransformerException {
        return this.compileUnary(new Bool(), n);
    }

    protected Expression number(int n) throws TransformerException {
        return this.compileUnary(new Number(), n);
    }

    protected Expression literal(int n) {
        n = Compiler.getFirstChildPos(n);
        return (XString)this.getTokenQueue().elementAt(this.getOp(n));
    }

    protected Expression numberlit(int n) {
        n = Compiler.getFirstChildPos(n);
        return (XNumber)this.getTokenQueue().elementAt(this.getOp(n));
    }

    protected Expression variable(int n) throws TransformerException {
        Variable variable = new Variable();
        int n2 = this.getOp(n = Compiler.getFirstChildPos(n));
        String string = -2 == n2 ? null : (String)this.getTokenQueue().elementAt(n2);
        String string2 = (String)this.getTokenQueue().elementAt(this.getOp(n + 1));
        QName qName = new QName(string, string2);
        variable.setQName(qName);
        return variable;
    }

    protected Expression group(int n) throws TransformerException {
        return this.compile(n + 2);
    }

    protected Expression arg(int n) throws TransformerException {
        return this.compile(n + 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression union(int n) throws TransformerException {
        ++this.locPathDepth;
        try {
            LocPathIterator locPathIterator = UnionPathIterator.createUnionIterator(this, n);
            return locPathIterator;
        }
        finally {
            --this.locPathDepth;
        }
    }

    public int getLocationPathDepth() {
        return this.locPathDepth;
    }

    FunctionTable getFunctionTable() {
        return this.m_functionTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression locationPath(int n) throws TransformerException {
        ++this.locPathDepth;
        try {
            DTMIterator dTMIterator = WalkerFactory.newDTMIterator(this, n, this.locPathDepth == 0);
            Expression expression = (Expression)((Object)dTMIterator);
            return expression;
        }
        finally {
            --this.locPathDepth;
        }
    }

    public Expression predicate(int n) throws TransformerException {
        return this.compile(n + 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression matchPattern(int n) throws TransformerException {
        ++this.locPathDepth;
        try {
            int n2 = n;
            int n3 = 0;
            while (this.getOp(n2) == 31) {
                n2 = this.getNextOpPos(n2);
                ++n3;
            }
            if (n3 == 1) {
                Expression expression = this.compile(n);
                return expression;
            }
            UnionPattern unionPattern = new UnionPattern();
            StepPattern[] stepPatternArray = new StepPattern[n3];
            n3 = 0;
            while (this.getOp(n) == 31) {
                n2 = this.getNextOpPos(n);
                stepPatternArray[n3] = (StepPattern)this.compile(n);
                n = n2;
                ++n3;
            }
            unionPattern.setPatterns(stepPatternArray);
            UnionPattern unionPattern2 = unionPattern;
            return unionPattern2;
        }
        finally {
            --this.locPathDepth;
        }
    }

    public Expression locationPathPattern(int n) throws TransformerException {
        n = Compiler.getFirstChildPos(n);
        return this.stepPattern(n, 0, null);
    }

    public int getWhatToShow(int n) {
        int n2 = this.getOp(n);
        int n3 = this.getOp(n + 3);
        switch (n3) {
            case 1030: {
                return 128;
            }
            case 1031: {
                return 12;
            }
            case 1032: {
                return 64;
            }
            case 1033: {
                switch (n2) {
                    case 49: {
                        return 4096;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 38: 
                    case 42: 
                    case 48: {
                        return -1;
                    }
                }
                if (this.getOp(0) == 30) {
                    return -1283;
                }
                return -3;
            }
            case 35: {
                return 1280;
            }
            case 1034: {
                return 65536;
            }
            case 34: {
                switch (n2) {
                    case 49: {
                        return 4096;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 52: 
                    case 53: {
                        return 1;
                    }
                }
                return 1;
            }
        }
        return -1;
    }

    protected StepPattern stepPattern(int n, int n2, StepPattern stepPattern) throws TransformerException {
        StepPattern stepPattern2;
        int n3;
        int n4 = n;
        int n5 = this.getOp(n);
        if (-1 == n5) {
            return null;
        }
        boolean bl = true;
        int n6 = this.getNextOpPos(n);
        switch (n5) {
            case 25: {
                bl = false;
                n3 = this.getOp(n + 1);
                stepPattern2 = new FunctionPattern(this.compileFunction(n), 10, 3);
                break;
            }
            case 50: {
                bl = false;
                n3 = this.getArgLengthOfStep(n);
                n = Compiler.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(1280, 10, 3);
                break;
            }
            case 51: {
                n3 = this.getArgLengthOfStep(n);
                n = Compiler.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(2, this.getStepNS(n4), this.getStepLocalName(n4), 10, 2);
                break;
            }
            case 52: {
                n3 = this.getArgLengthOfStep(n);
                n = Compiler.getFirstChildPosOfStep(n);
                int n7 = this.getWhatToShow(n4);
                if (1280 == n7) {
                    bl = false;
                }
                stepPattern2 = new StepPattern(this.getWhatToShow(n4), this.getStepNS(n4), this.getStepLocalName(n4), 0, 3);
                break;
            }
            case 53: {
                n3 = this.getArgLengthOfStep(n);
                n = Compiler.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(this.getWhatToShow(n4), this.getStepNS(n4), this.getStepLocalName(n4), 10, 3);
                break;
            }
            default: {
                this.error("ER_UNKNOWN_MATCH_OPERATION", null);
                return null;
            }
        }
        stepPattern2.setPredicates(this.getCompiledPredicates(n + n3));
        if (null != stepPattern) {
            stepPattern2.setRelativePathPattern(stepPattern);
        }
        StepPattern stepPattern3 = this.stepPattern(n6, n2 + 1, stepPattern2);
        return null != stepPattern3 ? stepPattern3 : stepPattern2;
    }

    public Expression[] getCompiledPredicates(int n) throws TransformerException {
        int n2 = this.countPredicates(n);
        if (n2 > 0) {
            Expression[] expressionArray = new Expression[n2];
            this.compilePredicates(n, expressionArray);
            return expressionArray;
        }
        return null;
    }

    public int countPredicates(int n) throws TransformerException {
        int n2 = 0;
        while (29 == this.getOp(n)) {
            ++n2;
            n = this.getNextOpPos(n);
        }
        return n2;
    }

    private void compilePredicates(int n, Expression[] expressionArray) throws TransformerException {
        int n2 = 0;
        while (29 == this.getOp(n)) {
            expressionArray[n2] = this.predicate(n);
            n = this.getNextOpPos(n);
            ++n2;
        }
    }

    Expression compileFunction(int n) throws TransformerException {
        int n2 = n + this.getOp(n + 1) - 1;
        n = Compiler.getFirstChildPos(n);
        int n3 = this.getOp(n);
        ++n;
        if (-1 != n3) {
            Function function = this.m_functionTable.getFunction(n3);
            if (function instanceof FuncExtFunctionAvailable) {
                ((FuncExtFunctionAvailable)function).setFunctionTable(this.m_functionTable);
            }
            function.postCompileStep(this);
            try {
                int n4 = 0;
                int n5 = n;
                while (n5 < n2) {
                    function.setArg(this.compile(n5), n4);
                    n5 = this.getNextOpPos(n5);
                    ++n4;
                }
                function.checkNumberArgs(n4);
            }
            catch (WrongNumberArgsException wrongNumberArgsException) {
                String string = this.m_functionTable.getFunctionName(n3);
                this.m_errorHandler.fatalError(new TransformerException(XSLMessages.createXPATHMessage("ER_ONLY_ALLOWS", new Object[]{string, wrongNumberArgsException.getMessage()}), this.m_locator));
            }
            return function;
        }
        this.error("ER_FUNCTION_TOKEN_NOT_FOUND", null);
        return null;
    }

    private synchronized long getNextMethodId() {
        if (s_nextMethodId == Long.MAX_VALUE) {
            s_nextMethodId = 0L;
        }
        return s_nextMethodId++;
    }

    private Expression compileExtension(int n) throws TransformerException {
        int n2 = n + this.getOp(n + 1) - 1;
        n = Compiler.getFirstChildPos(n);
        String string = (String)this.getTokenQueue().elementAt(this.getOp(n));
        String string2 = (String)this.getTokenQueue().elementAt(this.getOp(++n));
        ++n;
        FuncExtFunction funcExtFunction = new FuncExtFunction(string, string2, String.valueOf(this.getNextMethodId()));
        try {
            int n3 = 0;
            while (n < n2) {
                int n4 = this.getNextOpPos(n);
                ((Function)funcExtFunction).setArg(this.compile(n), n3);
                n = n4;
                ++n3;
            }
        }
        catch (WrongNumberArgsException wrongNumberArgsException) {
            // empty catch block
        }
        return funcExtFunction;
    }

    public void warn(String string, Object[] objectArray) throws TransformerException {
        String string2 = XSLMessages.createXPATHWarning(string, objectArray);
        if (null != this.m_errorHandler) {
            this.m_errorHandler.warning(new TransformerException(string2, this.m_locator));
        } else {
            System.out.println(string2 + "; file " + this.m_locator.getSystemId() + "; line " + this.m_locator.getLineNumber() + "; column " + this.m_locator.getColumnNumber());
        }
    }

    public void assertion(boolean bl, String string) {
        if (!bl) {
            String string2 = XSLMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    @Override
    public void error(String string, Object[] objectArray) throws TransformerException {
        String string2 = XSLMessages.createXPATHMessage(string, objectArray);
        if (null == this.m_errorHandler) {
            throw new TransformerException(string2, (SAXSourceLocator)this.m_locator);
        }
        this.m_errorHandler.fatalError(new TransformerException(string2, this.m_locator));
    }

    public PrefixResolver getNamespaceContext() {
        return this.m_currentPrefixResolver;
    }

    public void setNamespaceContext(PrefixResolver prefixResolver) {
        this.m_currentPrefixResolver = prefixResolver;
    }
}

